/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.randvar.RandUnuran;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class UnuranDiscreteInt
extends RandomVariateGenInt {
    private RandUnuran unuran = new RandUnuran();

    public UnuranDiscreteInt(RandomStream randomStream, String string) {
        if (randomStream == null) {
            throw new IllegalArgumentException("mainStream must not be null.");
        }
        this.unuran.mainStream = this.unuran.auxStream = randomStream;
        this.unuran.init(string);
        if (!this.unuran.isDiscrete()) {
            this.unuran.close();
            throw new IllegalArgumentException("not a discrete distribution");
        }
    }

    public UnuranDiscreteInt(RandomStream randomStream, RandomStream randomStream2, String string) {
        if (randomStream == null) {
            throw new IllegalArgumentException("mainStream must not be null.");
        }
        if (randomStream2 == null) {
            throw new IllegalArgumentException("auxStream must not be null.");
        }
        this.unuran.mainStream = randomStream;
        this.unuran.auxStream = randomStream2;
        this.unuran.init(string);
        if (!this.unuran.isDiscrete()) {
            this.unuran.close();
            throw new IllegalArgumentException("not a discrete distribution");
        }
    }

    public int nextInt() {
        if (this.unuran.nativeParams == 0) {
            throw new IllegalStateException();
        }
        return this.unuran.getRandDisc(this.unuran.mainStream.nextDouble(), this.unuran.nativeParams);
    }

    public void nextArrayOfInt(int[] nArray, int n, int n2) {
        if (nArray == null || n < 0 || n2 < 0 || n + n2 > nArray.length) {
            throw new IllegalArgumentException();
        }
        if (this.unuran.unifArray == null || this.unuran.unifArray.length < n2) {
            this.unuran.unifArray = new double[n2];
        }
        if (this.unuran.mainStream != this.unuran.auxStream && (this.unuran.unifAuxArray == null || this.unuran.unifAuxArray.length < n2)) {
            this.unuran.unifAuxArray = new double[n2];
        }
        this.unuran.getRandDiscArray(this.unuran.nativeParams, this.unuran.unifArray, this.unuran.unifAuxArray, nArray, n, n2);
    }

    protected void finalize() {
        this.unuran.close();
    }

    public DiscreteDistributionInt getDistribution() {
        return null;
    }

    public RandomStream getStream() {
        return this.unuran.mainStream;
    }

    public RandomStream getAuxStream() {
        return this.unuran.auxStream;
    }
}

