/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.PrintWriter;
import java.security.InvalidKeyException;
import umontreal.iro.lecuyer.rng.Rijndael_Properties;

final class Rijndael_Algorithm {
    static final String NAME = "Rijndael_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel;
    static final PrintWriter err;
    static final boolean TRACE;
    static final int BLOCK_SIZE = 16;
    static final int[] alog;
    static final int[] log;
    static final byte[] S;
    static final byte[] Si;
    static final int[] T1;
    static final int[] T2;
    static final int[] T3;
    static final int[] T4;
    static final int[] T5;
    static final int[] T6;
    static final int[] T7;
    static final int[] T8;
    static final int[] U1;
    static final int[] U2;
    static final int[] U3;
    static final int[] U4;
    static final byte[] rcon;
    static final int[][][] shifts;
    private static final char[] HEX_DIGITS;

    Rijndael_Algorithm() {
    }

    static void debug(String string) {
        err.println(">>> Rijndael_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            err.println((bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            err.println("<=> Rijndael_Algorithm." + string);
        }
    }

    static final int mul(int n, int n2) {
        return n != 0 && n2 != 0 ? alog[(log[n & 0xFF] + log[n2 & 0xFF]) % 255] : 0;
    }

    static final int mul4(int n, byte[] byArray) {
        if (n == 0) {
            return 0;
        }
        n = log[n & 0xFF];
        int n2 = byArray[0] != 0 ? alog[(n + log[byArray[0] & 0xFF]) % 255] & 0xFF : 0;
        int n3 = byArray[1] != 0 ? alog[(n + log[byArray[1] & 0xFF]) % 255] & 0xFF : 0;
        int n4 = byArray[2] != 0 ? alog[(n + log[byArray[2] & 0xFF]) % 255] & 0xFF : 0;
        int n5 = byArray[3] != 0 ? alog[(n + log[byArray[3] & 0xFF]) % 255] & 0xFF : 0;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static Object makeKey(byte[] byArray) throws InvalidKeyException {
        return Rijndael_Algorithm.makeKey(byArray, 16);
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])((Object[])object)[0];
        int n2 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n3 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n4 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n5 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n6 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        for (int i = 1; i < n2; ++i) {
            nArray2 = nArray[i];
            int n7 = T1[n3 >>> 24 & 0xFF] ^ T2[n4 >>> 16 & 0xFF] ^ T3[n5 >>> 8 & 0xFF] ^ T4[n6 & 0xFF] ^ nArray2[0];
            int n8 = T1[n4 >>> 24 & 0xFF] ^ T2[n5 >>> 16 & 0xFF] ^ T3[n6 >>> 8 & 0xFF] ^ T4[n3 & 0xFF] ^ nArray2[1];
            int n9 = T1[n5 >>> 24 & 0xFF] ^ T2[n6 >>> 16 & 0xFF] ^ T3[n3 >>> 8 & 0xFF] ^ T4[n4 & 0xFF] ^ nArray2[2];
            int n10 = T1[n6 >>> 24 & 0xFF] ^ T2[n3 >>> 16 & 0xFF] ^ T3[n4 >>> 8 & 0xFF] ^ T4[n5 & 0xFF] ^ nArray2[3];
            n3 = n7;
            n4 = n8;
            n5 = n9;
            n6 = n10;
        }
        byte[] byArray2 = new byte[16];
        nArray2 = nArray[n2];
        int n11 = nArray2[0];
        byArray2[0] = (byte)(S[n3 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[1] = (byte)(S[n4 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[2] = (byte)(S[n5 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[3] = (byte)(S[n6 & 0xFF] ^ n11);
        n11 = nArray2[1];
        byArray2[4] = (byte)(S[n4 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[5] = (byte)(S[n5 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[6] = (byte)(S[n6 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[7] = (byte)(S[n3 & 0xFF] ^ n11);
        n11 = nArray2[2];
        byArray2[8] = (byte)(S[n5 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[9] = (byte)(S[n6 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[10] = (byte)(S[n3 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[11] = (byte)(S[n4 & 0xFF] ^ n11);
        n11 = nArray2[3];
        byArray2[12] = (byte)(S[n6 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[13] = (byte)(S[n3 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[14] = (byte)(S[n4 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[15] = (byte)(S[n5 & 0xFF] ^ n11);
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int[][] nArray = (int[][])((Object[])object)[1];
        int n2 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n3 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n4 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n5 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n6 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        for (int i = 1; i < n2; ++i) {
            nArray2 = nArray[i];
            int n7 = T5[n3 >>> 24 & 0xFF] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ nArray2[0];
            int n8 = T5[n4 >>> 24 & 0xFF] ^ T6[n3 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ nArray2[1];
            int n9 = T5[n5 >>> 24 & 0xFF] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n3 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ nArray2[2];
            int n10 = T5[n6 >>> 24 & 0xFF] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n3 & 0xFF] ^ nArray2[3];
            n3 = n7;
            n4 = n8;
            n5 = n9;
            n6 = n10;
        }
        byte[] byArray2 = new byte[16];
        nArray2 = nArray[n2];
        int n11 = nArray2[0];
        byArray2[0] = (byte)(Si[n3 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[1] = (byte)(Si[n6 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[2] = (byte)(Si[n5 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[3] = (byte)(Si[n4 & 0xFF] ^ n11);
        n11 = nArray2[1];
        byArray2[4] = (byte)(Si[n4 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[5] = (byte)(Si[n3 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[6] = (byte)(Si[n6 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[7] = (byte)(Si[n5 & 0xFF] ^ n11);
        n11 = nArray2[2];
        byArray2[8] = (byte)(Si[n5 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[9] = (byte)(Si[n4 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[10] = (byte)(Si[n3 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[11] = (byte)(Si[n6 & 0xFF] ^ n11);
        n11 = nArray2[3];
        byArray2[12] = (byte)(Si[n6 >>> 24 & 0xFF] ^ n11 >>> 24);
        byArray2[13] = (byte)(Si[n5 >>> 16 & 0xFF] ^ n11 >>> 16);
        byArray2[14] = (byte)(Si[n4 >>> 8 & 0xFF] ^ n11 >>> 8);
        byArray2[15] = (byte)(Si[n3 & 0xFF] ^ n11);
        return byArray2;
    }

    public static boolean self_test() {
        return Rijndael_Algorithm.self_test(16);
    }

    public static int blockSize() {
        return 16;
    }

    public static synchronized Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        int n2;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        int n3 = Rijndael_Algorithm.getRounds(byArray.length, n);
        int n4 = n / 4;
        int[][] nArray = new int[n3 + 1][n4];
        int[][] nArray2 = new int[n3 + 1][n4];
        int n5 = (n3 + 1) * n4;
        int n6 = byArray.length / 4;
        int[] nArray3 = new int[n6];
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            nArray3[n7++] = (byArray[n8++] & 0xFF) << 24 | (byArray[n8++] & 0xFF) << 16 | (byArray[n8++] & 0xFF) << 8 | byArray[n8++] & 0xFF;
        }
        int n9 = 0;
        for (n8 = 0; n8 < n6 && n9 < n5; ++n8, ++n9) {
            nArray[n9 / n4][n9 % n4] = nArray3[n8];
            nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
        }
        int n10 = 0;
        while (n9 < n5) {
            n2 = nArray3[n6 - 1];
            nArray3[0] = nArray3[0] ^ ((S[n2 >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n2 & 0xFF] & 0xFF) << 8 ^ S[n2 >>> 24 & 0xFF] & 0xFF ^ (rcon[n10++] & 0xFF) << 24);
            if (n6 != 8) {
                n7 = 1;
                n8 = 0;
                while (n7 < n6) {
                    int n11 = n7++;
                    nArray3[n11] = nArray3[n11] ^ nArray3[n8++];
                }
            } else {
                n7 = 1;
                n8 = 0;
                while (n7 < n6 / 2) {
                    int n12 = n7++;
                    nArray3[n12] = nArray3[n12] ^ nArray3[n8++];
                }
                n2 = nArray3[n6 / 2 - 1];
                int n13 = n6 / 2;
                nArray3[n13] = nArray3[n13] ^ (S[n2 & 0xFF] & 0xFF ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >>> 16 & 0xFF] & 0xFF) << 16 ^ (S[n2 >>> 24 & 0xFF] & 0xFF) << 24);
                n8 = n6 / 2;
                n7 = n8 + 1;
                while (n7 < n6) {
                    int n14 = n7++;
                    nArray3[n14] = nArray3[n14] ^ nArray3[n8++];
                }
            }
            for (n8 = 0; n8 < n6 && n9 < n5; ++n8, ++n9) {
                nArray[n9 / n4][n9 % n4] = nArray3[n8];
                nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
            }
        }
        for (int i = 1; i < n3; ++i) {
            for (n8 = 0; n8 < n4; ++n8) {
                n2 = nArray2[i][n8];
                nArray2[i][n8] = U1[n2 >>> 24 & 0xFF] ^ U2[n2 >>> 16 & 0xFF] ^ U3[n2 >>> 8 & 0xFF] ^ U4[n2 & 0xFF];
            }
        }
        Object[] objectArray = new Object[]{nArray, nArray2};
        return objectArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object, int n2) {
        int n3;
        if (n2 == 16) {
            return Rijndael_Algorithm.blockEncrypt(byArray, n, object);
        }
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[0];
        int n4 = n2 / 4;
        int n5 = nArray.length - 1;
        int n6 = n4 == 4 ? 0 : (n4 == 6 ? 1 : 2);
        int n7 = shifts[n6][1][0];
        int n8 = shifts[n6][2][0];
        int n9 = shifts[n6][3][0];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        byte[] byArray2 = new byte[n2];
        int n10 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n3];
        }
        for (int i = 1; i < n5; ++i) {
            for (n3 = 0; n3 < n4; ++n3) {
                nArray2[n3] = T1[nArray3[n3] >>> 24 & 0xFF] ^ T2[nArray3[(n3 + n7) % n4] >>> 16 & 0xFF] ^ T3[nArray3[(n3 + n8) % n4] >>> 8 & 0xFF] ^ T4[nArray3[(n3 + n9) % n4] & 0xFF] ^ nArray[i][n3];
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n11 = nArray[n5][n3];
            byArray2[n10++] = (byte)(S[nArray3[n3] >>> 24 & 0xFF] ^ n11 >>> 24);
            byArray2[n10++] = (byte)(S[nArray3[(n3 + n7) % n4] >>> 16 & 0xFF] ^ n11 >>> 16);
            byArray2[n10++] = (byte)(S[nArray3[(n3 + n8) % n4] >>> 8 & 0xFF] ^ n11 >>> 8);
            byArray2[n10++] = (byte)(S[nArray3[(n3 + n9) % n4] & 0xFF] ^ n11);
        }
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object, int n2) {
        int n3;
        if (n2 == 16) {
            return Rijndael_Algorithm.blockDecrypt(byArray, n, object);
        }
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[1];
        int n4 = n2 / 4;
        int n5 = nArray.length - 1;
        int n6 = n4 == 4 ? 0 : (n4 == 6 ? 1 : 2);
        int n7 = shifts[n6][1][1];
        int n8 = shifts[n6][2][1];
        int n9 = shifts[n6][3][1];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        byte[] byArray2 = new byte[n2];
        int n10 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray3[n3] = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n3];
        }
        for (int i = 1; i < n5; ++i) {
            for (n3 = 0; n3 < n4; ++n3) {
                nArray2[n3] = T5[nArray3[n3] >>> 24 & 0xFF] ^ T6[nArray3[(n3 + n7) % n4] >>> 16 & 0xFF] ^ T7[nArray3[(n3 + n8) % n4] >>> 8 & 0xFF] ^ T8[nArray3[(n3 + n9) % n4] & 0xFF] ^ nArray[i][n3];
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n11 = nArray[n5][n3];
            byArray2[n10++] = (byte)(Si[nArray3[n3] >>> 24 & 0xFF] ^ n11 >>> 24);
            byArray2[n10++] = (byte)(Si[nArray3[(n3 + n7) % n4] >>> 16 & 0xFF] ^ n11 >>> 16);
            byArray2[n10++] = (byte)(Si[nArray3[(n3 + n8) % n4] >>> 8 & 0xFF] ^ n11 >>> 8);
            byArray2[n10++] = (byte)(Si[nArray3[(n3 + n9) % n4] & 0xFF] ^ n11);
        }
        return byArray2;
    }

    private static boolean self_test(int n) {
        boolean bl = false;
        try {
            int n2;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            for (n2 = 0; n2 < n; ++n2) {
                byArray[n2] = (byte)n2;
            }
            for (n2 = 0; n2 < 16; ++n2) {
                byArray2[n2] = (byte)n2;
            }
            Object object = Rijndael_Algorithm.makeKey(byArray, 16);
            byte[] byArray3 = Rijndael_Algorithm.blockEncrypt(byArray2, 0, object, 16);
            byte[] byArray4 = Rijndael_Algorithm.blockDecrypt(byArray3, 0, object, 16);
            bl = Rijndael_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static int getRounds(int n, int n2) {
        switch (n) {
            case 16: {
                return n2 == 16 ? 10 : (n2 == 24 ? 12 : 14);
            }
            case 24: {
                return n2 != 32 ? 12 : 14;
            }
        }
        return 14;
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static String byteToString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(cArray);
    }

    private static String intToString(int n) {
        char[] cArray = new char[8];
        for (int i = 7; i >= 0; --i) {
            cArray[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static String toString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            cArray[n2++] = HEX_DIGITS[n3 >>> 28 & 0xF];
            cArray[n2++] = HEX_DIGITS[n3 >>> 24 & 0xF];
            cArray[n2++] = HEX_DIGITS[n3 >>> 20 & 0xF];
            cArray[n2++] = HEX_DIGITS[n3 >>> 16 & 0xF];
            cArray[n2++] = HEX_DIGITS[n3 >>> 12 & 0xF];
            cArray[n2++] = HEX_DIGITS[n3 >>> 8 & 0xF];
            cArray[n2++] = HEX_DIGITS[n3 >>> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[n3 & 0xF];
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        Rijndael_Algorithm.self_test(16);
        Rijndael_Algorithm.self_test(24);
        Rijndael_Algorithm.self_test(32);
    }

    static {
        int n;
        int n2;
        debuglevel = 0;
        err = null;
        TRACE = Rijndael_Properties.isTraceable(NAME);
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        shifts = new int[][][]{new int[][]{{0, 0}, {1, 3}, {2, 2}, {3, 1}}, new int[][]{{0, 0}, {1, 5}, {2, 4}, {3, 3}}, new int[][]{{0, 0}, {1, 7}, {3, 5}, {4, 4}}};
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        long l = System.currentTimeMillis();
        int n3 = 283;
        int n4 = 0;
        Rijndael_Algorithm.alog[0] = 1;
        for (n2 = 1; n2 < 256; ++n2) {
            n4 = alog[n2 - 1] << 1 ^ alog[n2 - 1];
            if ((n4 & 0x100) != 0) {
                n4 ^= n3;
            }
            Rijndael_Algorithm.alog[n2] = n4;
        }
        for (n2 = 1; n2 < 255; ++n2) {
            Rijndael_Algorithm.log[Rijndael_Algorithm.alog[n2]] = n2;
        }
        byte[][] byArrayArray = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] byArray = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] byArray2 = new byte[256][8];
        byArray2[1][7] = 1;
        for (n2 = 2; n2 < 256; ++n2) {
            n4 = alog[255 - log[n2]];
            for (n = 0; n < 8; ++n) {
                byArray2[n2][n] = (byte)(n4 >>> 7 - n & 1);
            }
        }
        byte[][] byArray3 = new byte[256][8];
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 8; ++n) {
                byArray3[n2][n] = byArray[n];
                for (n4 = 0; n4 < 8; ++n4) {
                    byte[] byArray4 = byArray3[n2];
                    int n5 = n;
                    byArray4[n5] = (byte)(byArray4[n5] ^ byArrayArray[n][n4] * byArray2[n2][n4]);
                }
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            Rijndael_Algorithm.S[n2] = (byte)(byArray3[n2][0] << 7);
            for (n = 1; n < 8; ++n) {
                int n6 = n2;
                S[n6] = (byte)(S[n6] ^ byArray3[n2][n] << 7 - n);
            }
            Rijndael_Algorithm.Si[Rijndael_Algorithm.S[n2] & 0xFF] = (byte)n2;
        }
        byte[][] byArrayArray2 = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] byArray5 = new byte[4][8];
        for (n2 = 0; n2 < 4; ++n2) {
            for (n4 = 0; n4 < 4; ++n4) {
                byArray5[n2][n4] = byArrayArray2[n2][n4];
            }
            byArray5[n2][n2 + 4] = 1;
        }
        byte[][] byArray6 = new byte[4][4];
        for (n2 = 0; n2 < 4; ++n2) {
            byte by = byArray5[n2][n2];
            if (by == 0) {
                for (n = n2 + 1; byArray5[n][n2] == 0 && n < 4; ++n) {
                }
                if (n == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                for (n4 = 0; n4 < 8; ++n4) {
                    byte by2 = byArray5[n2][n4];
                    byArray5[n2][n4] = byArray5[n][n4];
                    byArray5[n][n4] = by2;
                }
                by = byArray5[n2][n2];
            }
            for (n4 = 0; n4 < 8; ++n4) {
                if (byArray5[n2][n4] == 0) continue;
                byArray5[n2][n4] = (byte)alog[(255 + log[byArray5[n2][n4] & 0xFF] - log[by & 0xFF]) % 255];
            }
            for (n = 0; n < 4; ++n) {
                if (n2 == n) continue;
                for (n4 = n2 + 1; n4 < 8; ++n4) {
                    byte[] byArray7 = byArray5[n];
                    int n7 = n4;
                    byArray7[n7] = (byte)(byArray7[n7] ^ Rijndael_Algorithm.mul(byArray5[n2][n4], byArray5[n][n2]));
                }
                byArray5[n][n2] = 0;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n4 = 0; n4 < 4; ++n4) {
                byArray6[n2][n4] = byArray5[n2][n4 + 4];
            }
        }
        for (n = 0; n < 256; ++n) {
            byte by = S[n];
            Rijndael_Algorithm.T1[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[0]);
            Rijndael_Algorithm.T2[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[1]);
            Rijndael_Algorithm.T3[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[2]);
            Rijndael_Algorithm.T4[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[3]);
            by = Si[n];
            Rijndael_Algorithm.T5[n] = Rijndael_Algorithm.mul4(by, byArray6[0]);
            Rijndael_Algorithm.T6[n] = Rijndael_Algorithm.mul4(by, byArray6[1]);
            Rijndael_Algorithm.T7[n] = Rijndael_Algorithm.mul4(by, byArray6[2]);
            Rijndael_Algorithm.T8[n] = Rijndael_Algorithm.mul4(by, byArray6[3]);
            Rijndael_Algorithm.U1[n] = Rijndael_Algorithm.mul4(n, byArray6[0]);
            Rijndael_Algorithm.U2[n] = Rijndael_Algorithm.mul4(n, byArray6[1]);
            Rijndael_Algorithm.U3[n] = Rijndael_Algorithm.mul4(n, byArray6[2]);
            Rijndael_Algorithm.U4[n] = Rijndael_Algorithm.mul4(n, byArray6[3]);
        }
        Rijndael_Algorithm.rcon[0] = 1;
        int n8 = 1;
        n = 1;
        while (n < 30) {
            int n9 = n++;
            n8 = Rijndael_Algorithm.mul(2, n8);
            Rijndael_Algorithm.rcon[n9] = (byte)n8;
        }
        l = System.currentTimeMillis() - l;
    }
}

