% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my.dsn.R
\name{my.dsn}
\alias{my.dsn}
\alias{dsn}
\alias{psn}
\alias{qsn}
\title{my.dsn}
\usage{
my.dsn(x, xi = 0, omega = 1, lambda = 1)

dsn(x, xi = 0, omega = 1, alpha = 0, tau = 0)

psn(q, xi = -Inf, omega = 1, alpha = 0, tau = 0, ...)

qsn(p, xi = Inf, omega = 1, alpha = 0, tau = 0, ...)
}
\arguments{
\item{x}{vector of quantiles. Missing values (‘NA’'s) and ‘Inf’'s are   allowed.}

\item{xi}{vector of location parameters.}

\item{omega}{vector of scale parameters; must be positive}

\item{lambda}{param}

\item{alpha}{vector of slant parameter(s)}

\item{tau}{= 0}

\item{q}{vector of quantiles}

\item{...}{arguments passed to sn}

\item{p}{vector of probabilities. Missing values (‘NA’'s) are allowed}
}
\value{
fits the Density function for the skew-normal (SN) distribution.
}
\description{
density of skew-normal using the appromimation of Ashour, Samir K. and Abdel-hameed, Mahmood A.
}
\details{
See \url{https://en.wikipedia.org/wiki/Skew_normal_distribution} for discussion of the skew-normal.
Using the appromimation of Ashour, Samir K. and Abdel-hameed, Mahmood A.
"Approximate Skew Normal Distribution", Journal of Advanced Research, 2010, 1:4.
It accepts the parameters xi, omega, lambda (Ashour et. al. 2010). Other foumulations may use
different parameterizations. The sn (skew-normal) package incluse the extended skew-normal (ESN) distribution. For the SN the
tau parameter is 0.

RFlocalfdr also uses wrappers around the functions dsn, qsn and psn from the package "sn"
https://cran.r-project.org/web/packages/sn/.
This is due to the fact that
fitdistrplus::fitdist(imp, "sn", start = list(xi = mean(imp)...
returns warnings such as
The dsn function should return a zero-length vector when input has length zero and not raise an error
The psn function should have its first argument named: q as in base R
These wrappers ensure conformity with the expectations of fitdistrplus::fitdist
}
\examples{
library(sn)
curve(sn::dsn(x,xi=0, omega=1, alpha=1, tau=0),xlim=c(-10,10),col="blue")
curve(sn::dsn(x,xi=0, omega=1, alpha=0.1, tau=0),xlim=c(-10,10),col="blue",add=TRUE)
curve(sn::dsn(x,xi=1, omega=2, alpha=2, tau=0),xlim=c(-10,20),col="blue",add=TRUE)
curve(sn::dsn(x,xi=3, omega=4, alpha=4, tau=0),xlim=c(-10,20),col="blue",add=TRUE)

curve(my.dsn(x),xlim=c(-10,10),col="red",add=TRUE)
curve(my.dsn(x,lambda=0.1),xlim=c(-10,10),col="red",add=TRUE)
curve(my.dsn(x,xi=1, omega=2, lambda=2),xlim=c(-10,20),col="red",add=TRUE)
curve(my.dsn(x,xi=3, omega=4, lambda=4),xlim=c(-10,20),col="red",add=TRUE)

#dsn, qsn and psn are wrappers around the provided functions provided by sn. This is done to
# overcome some checking done by fitdistrplus
\donttest{
library(sn)
getAnywhere("dsn")
RFlocalfdr::my.test1fun("sn::dsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))
RFlocalfdr::my.test1fun("sn::psn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))
RFlocalfdr::my.test1fun("sn::qsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))
#all return FALSE

detach("package:sn", unload=TRUE)
getAnywhere("dsn")
RFlocalfdr::my.test1fun("dsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))#TRUE
RFlocalfdr::my.test1fun("psn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))#TRUE
RFlocalfdr::my.test1fun("qsn", list(xi = -Inf, omega =1, alpha=0 ), fix.arg = list(tau = 0))#TRUE
}
}
\keyword{normal}
\keyword{skew}
