/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class DefaultEdge
extends DefaultGraphCell
implements Edge {
    protected static final int center = 500;
    protected static final Point defaultLabel = new Point(500, 500);
    public static final ArrayList defaultPoints = new ArrayList();
    protected Object source;
    protected Object target;

    public DefaultEdge() {
        this(null);
    }

    public DefaultEdge(Object object) {
        this(object, false);
    }

    public DefaultEdge(Object object, boolean bl) {
        super(object, bl);
        GraphConstants.setPoints(this.attributes, new ArrayList(defaultPoints));
        GraphConstants.setLabelPosition(this.attributes, defaultLabel);
    }

    public Map changeAttributes(Map map) {
        Map map2 = super.changeAttributes(map);
        List list = GraphConstants.getPoints(this.attributes);
        if (list == null) {
            GraphConstants.setPoints(this.attributes, new ArrayList(defaultPoints));
        }
        return map2;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public void setTarget(Object object) {
        this.target = object;
    }

    public Object clone() {
        DefaultEdge defaultEdge = (DefaultEdge)super.clone();
        defaultEdge.source = null;
        defaultEdge.target = null;
        return defaultEdge;
    }

    static {
        defaultPoints.add(new Point(10, 10));
        defaultPoints.add(new Point(20, 20));
    }

    public static class DefaultRouting
    implements Edge.Routing {
        public void route(EdgeView edgeView, List list) {
            int n = list.size();
            Point point = edgeView.getPoint(0);
            if (edgeView.getSource() instanceof PortView) {
                point = ((PortView)edgeView.getSource()).getLocation(null);
            } else if (edgeView.getSource() != null) {
                point = edgeView.getSource().getBounds().getLocation();
            }
            Point point2 = edgeView.getPoint(n - 1);
            if (edgeView.getTarget() instanceof PortView) {
                point2 = ((PortView)edgeView.getTarget()).getLocation(null);
            } else if (edgeView.getTarget() != null) {
                point2 = edgeView.getTarget().getBounds().getLocation();
            }
            if (point != null && point2 != null) {
                Point[] pointArray;
                int n2;
                int n3;
                if (edgeView.getSource() == edgeView.getTarget() && edgeView.getSource() != null) {
                    Rectangle rectangle = edgeView.getSource().getParentView().getBounds();
                    n3 = edgeView.getGraph().getGridSize();
                    n2 = (int)(rectangle.getWidth() / 3.0);
                    pointArray = new Point[]{new Point(rectangle.x + n2, rectangle.y + rectangle.height), new Point(rectangle.x + n2, rectangle.y + rectangle.height + n3), new Point(rectangle.x + 2 * n2, rectangle.y + rectangle.height + n3), new Point(rectangle.x + 2 * n2, rectangle.y + rectangle.height)};
                } else {
                    int n4 = Math.abs(point.x - point2.x);
                    n3 = Math.abs(point.y - point2.y);
                    n2 = point.x + (point2.x - point.x) / 2;
                    int n5 = point.y + (point2.y - point.y) / 2;
                    pointArray = new Point[2];
                    if (n4 > n3) {
                        pointArray[0] = new Point(n2, point.y);
                        pointArray[1] = new Point(n2, point2.y);
                    } else {
                        pointArray[0] = new Point(point.x, n5);
                        pointArray[1] = new Point(point2.x, n5);
                    }
                }
                int n6 = 0;
                while (n6 < pointArray.length) {
                    if (list.size() > n6 + 2) {
                        list.set(n6 + 1, pointArray[n6]);
                    } else {
                        list.add(n6 + 1, pointArray[n6]);
                    }
                    ++n6;
                }
                while (list.size() > pointArray.length + 2) {
                    list.remove(list.size() - 2);
                }
            }
        }
    }
}

