/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.control.Schedule;
import freak.core.event.PortsChangedEventListener;
import freak.core.graph.GraphException;
import freak.core.graph.GraphSyntaxException;
import freak.core.graph.HasFloatingNumberOfInPorts;
import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.InPort;
import freak.core.graph.Operator;
import freak.core.graph.OperatorGraph;
import freak.core.graph.OutPort;
import freak.core.graph.OutputLengthMismatchException;
import freak.core.graph.Port;
import freak.core.modulesupport.AbstractBasicModule;
import freak.core.modulesupport.PropertyManager;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.IndividualList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public abstract class AbstractOperator
extends AbstractBasicModule
implements Operator {
    protected OperatorGraph graph = null;
    private ArrayList outPorts = new ArrayList();
    private ArrayList inPorts = new ArrayList();
    protected String name;
    private PortsChangedEventListener portsChangedListener;
    private int receivedInputs = 0;

    public AbstractOperator(OperatorGraph graph) {
        if (graph == null) {
            throw new NullPointerException("Operator graph is null.");
        }
        this.graph = graph;
        this.name = this.getName();
    }

    public void checkSyntax() throws GraphSyntaxException {
        int i = 0;
        while (i < this.inPorts.size()) {
            ((InPort)this.inPorts.get(i)).checkSyntax();
            ++i;
        }
        i = 0;
        while (i < this.outPorts.size()) {
            ((OutPort)this.outPorts.get(i)).checkSyntax();
            ++i;
        }
    }

    public String[] getListOfPropertyNames() {
        return PropertyManager.getListOfPropertyNames(this);
    }

    public String[] getListOfPropertyNamesWithType(Class type) {
        return PropertyManager.getListOfPropertyNamesWithType(this, type);
    }

    public void setProperty(String key, Object property) {
        PropertyManager.setProperty(this, key, property);
    }

    public Object getProperty(String key) {
        return PropertyManager.getProperty(this, key);
    }

    public Class getPropertyType(String key) {
        return PropertyManager.getPropertyType(this, key);
    }

    public void addInPort() {
        this.addInPort(this.inPorts.size());
    }

    public void addOutPort() {
        this.addOutPort(this.outPorts.size());
    }

    public void addInPort(int index) {
        InPort newPort = new InPort(this, index);
        this.inPorts.add(index, newPort);
        int i = index + 1;
        while (i < this.inPorts.size()) {
            ((InPort)this.inPorts.get(i)).setNumber(i);
            ++i;
        }
        this.firePortAddedEvent(newPort);
    }

    public void addOutPort(int index) {
        OutPort newPort = new OutPort(this, index);
        this.outPorts.add(index, newPort);
        int i = index + 1;
        while (i < this.outPorts.size()) {
            ((OutPort)this.outPorts.get(i)).setNumber(i);
            ++i;
        }
        this.firePortAddedEvent(newPort);
    }

    public void removeInPort(int index) {
        Port removed = (Port)this.inPorts.get(index);
        this.getOperatorGraph().getSchedule().getEventController().removeModule(removed);
        this.inPorts.remove(index);
        int i = index;
        while (i < this.inPorts.size()) {
            ((InPort)this.inPorts.get(i)).setNumber(i);
            ++i;
        }
        this.firePortRemovedEvent(removed);
    }

    public void removeOutPort(int index) {
        Port removed = (Port)this.outPorts.get(index);
        this.getOperatorGraph().getSchedule().getEventController().removeModule(removed);
        this.outPorts.remove(index);
        int i = index;
        while (i < this.outPorts.size()) {
            ((OutPort)this.outPorts.get(i)).setNumber(i);
            ++i;
        }
        this.firePortRemovedEvent(removed);
    }

    public InPort getInPort(int index) {
        if (index > this.inPorts.size() - 1 && this instanceof HasFloatingNumberOfInPorts) {
            int i = this.inPorts.size() - 1;
            while (i < index) {
                this.addInPort();
                ++i;
            }
        }
        return (InPort)this.inPorts.get(index);
    }

    public OutPort getOutPort(int index) {
        if (index > this.outPorts.size() - 1 && this instanceof HasFloatingNumberOfOutPorts) {
            int i = this.outPorts.size() - 1;
            while (i < index) {
                this.addOutPort();
                ++i;
            }
        }
        return (OutPort)this.outPorts.get(index);
    }

    public void exchangeInPorts(int x, int y) {
        InPort xPort = (InPort)this.inPorts.get(x);
        this.inPorts.set(x, this.inPorts.get(y));
        this.inPorts.set(y, xPort);
        ((Port)this.inPorts.get(y)).setNumber(y);
        ((Port)this.inPorts.get(x)).setNumber(x);
        this.firePortsExchangedEvent((Port)this.inPorts.get(x), (Port)this.inPorts.get(y));
    }

    public void exchangeOutPorts(int x, int y) {
        OutPort xPort = (OutPort)this.outPorts.get(x);
        this.outPorts.set(x, this.inPorts.get(y));
        this.outPorts.set(y, xPort);
        ((Port)this.outPorts.get(y)).setNumber(y);
        ((Port)this.outPorts.get(x)).setNumber(x);
        this.firePortsExchangedEvent((Port)this.outPorts.get(x), (Port)this.outPorts.get(y));
    }

    public OperatorGraph getOperatorGraph() {
        return this.graph;
    }

    public void activate() throws GraphException {
        IndividualList[] input = new IndividualList[this.inPorts.size()];
        int i = 0;
        while (i < input.length) {
            input[i] = ((InPort)this.inPorts.get(i)).get();
            ++i;
        }
        IndividualList[] output = this.process(input);
        int outPortsSize = this.outPorts.size();
        if (output == null && outPortsSize != 0 || output.length != outPortsSize) {
            throw new OutputLengthMismatchException("Output array doesn't match number of outPorts in " + this.getName() + ". " + this.outPorts.size() + " outports but output array contains " + (output != null ? output.length : 0) + " elements.");
        }
        int i2 = 0;
        while (i2 < outPortsSize) {
            if (output[i2] == null) {
                throw new OutputLengthMismatchException("Output array contains null entry.");
            }
            ((OutPort)this.outPorts.get(i2)).send(output[i2]);
            ++i2;
        }
        int inPortsSize = this.inPorts.size();
        int i3 = 0;
        while (i3 < inPortsSize) {
            ((InPort)this.inPorts.get(i3)).clearCache();
            ++i3;
        }
        this.receivedInputs = 0;
    }

    public abstract IndividualList[] process(IndividualList[] var1) throws GraphException;

    public String toString() {
        return this.name;
    }

    public int getNumberOfInPorts() {
        return this.inPorts.size();
    }

    public int getNumberOfOutPorts() {
        return this.outPorts.size();
    }

    public Method getGetterMethod(String property) {
        String methodName = "getProperty" + property;
        Method m = null;
        try {
            m = this.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Property name: " + property);
            throw new RuntimeException(e);
        }
        return m;
    }

    public Method getSetterMethod(String property) {
        String methodName = "setProperty" + property;
        Method m = null;
        try {
            Class[] args = new Class[]{this.getPropertyType(property)};
            m = this.getClass().getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Property name: " + property);
            throw new RuntimeException(e);
        }
        return m;
    }

    public int getIndexOfPort(Port port) {
        if (this.inPorts.contains(port)) {
            return this.inPorts.indexOf(port);
        }
        if (this.outPorts.contains(port)) {
            int offset = this.inPorts.size();
            return offset + this.outPorts.indexOf(port);
        }
        throw new NoSuchElementException("This operator doesn't contain port " + port);
    }

    public Port getPortAt(int index) {
        int numInPorts = this.inPorts.size();
        if (numInPorts > 0) {
            if (index < numInPorts) {
                return (Port)this.inPorts.get(index);
            }
            return (Port)this.outPorts.get(index - numInPorts);
        }
        return (Port)this.outPorts.get(index);
    }

    public void setPortsChangedListener(PortsChangedEventListener listener) {
        this.portsChangedListener = listener;
    }

    protected void firePortAddedEvent(Port port) {
        if (this.portsChangedListener != null) {
            this.portsChangedListener.portAdded(this, port);
        }
    }

    protected void firePortRemovedEvent(Port port) {
        if (this.portsChangedListener != null) {
            this.portsChangedListener.portRemoved(this, port);
        }
    }

    protected void firePortsExchangedEvent(Port port1, Port port2) {
        if (this.portsChangedListener != null) {
            this.portsChangedListener.portsExchanged(this, port1, port2);
        }
    }

    public String getPropertyName() {
        return this.name;
    }

    public void setPropertyName(String name) {
        this.name = name;
    }

    public void initialize() {
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
    }
}

