/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.ScheduleEvent;
import freak.core.event.ScheduleEventListener;
import freak.core.graph.Finish;
import freak.core.graph.GraphException;
import freak.core.graph.GraphSyntaxException;
import freak.core.graph.HasFloatingNumberOfInPorts;
import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.InPort;
import freak.core.graph.Operator;
import freak.core.graph.OutPort;
import freak.core.graph.Port;
import freak.core.graph.PortConnectException;
import freak.core.graph.Start;
import freak.core.modulesupport.AbstractModule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.parametercontroller.ParameterController;
import freak.core.population.IndividualList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OperatorGraph
extends AbstractModule
implements Configurable,
ScheduleEventListener {
    private ArrayList initNodes = new ArrayList();
    private String description = "";
    private String name = "";
    private ArrayList nodes = new ArrayList();
    private Start start;
    private Finish finish;
    private LinkedList ready = new LinkedList();
    private List parameterControllers = new ArrayList();

    public OperatorGraph(Schedule schedule) {
        super(schedule);
        this.start = new Start(this);
        this.start.createEvents();
        this.finish = new Finish(this);
        this.finish.createEvents();
        this.addOperator(this.start);
        this.addOperator(this.finish);
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public IndividualList process(IndividualList population) throws GraphException {
        this.start.putPopulation(population);
        int i = this.initNodes.size() - 1;
        while (i >= 0) {
            ((Operator)this.initNodes.get(i)).activate();
            --i;
        }
        IndividualList result = this.finish.getResultPopulation();
        if (result == null) {
            throw new NullPointerException("Graph/Finish node must not return null.");
        }
        return result;
    }

    public void checkSyntax() throws GraphSyntaxException {
        int i = 0;
        while (i < this.parameterControllers.size()) {
            ((ParameterController)this.parameterControllers.get(i)).checkSyntax();
            ++i;
        }
        i = 0;
        while (i < this.nodes.size()) {
            ((Operator)this.nodes.get(i)).checkSyntax();
            ++i;
        }
        HashSet visitedOperators = new HashSet();
        int i2 = 0;
        while (i2 < this.nodes.size()) {
            if (!visitedOperators.contains(this.nodes.get(i2)) && this.hasCircle((Operator)this.nodes.get(i2), new HashSet(), visitedOperators)) {
                throw new GraphSyntaxException("Graph ist not free from circles");
            }
            ++i2;
        }
        visitedOperators = new HashSet();
        this.undirectedDFS(this.start, visitedOperators);
        if (visitedOperators.size() < this.nodes.size()) {
            throw new GraphSyntaxException("Unconnected operators");
        }
    }

    private void undirectedDFS(Operator node, HashSet visitedOperators) {
        if (!visitedOperators.contains(node)) {
            visitedOperators.add(node);
            int i = 0;
            while (i < node.getNumberOfInPorts() + node.getNumberOfOutPorts()) {
                Iterator iter = node.getPortAt(i).getPartnerIterator();
                while (iter.hasNext()) {
                    this.undirectedDFS(((Port)iter.next()).getOperator(), visitedOperators);
                }
                ++i;
            }
        }
    }

    private void directedDFS(Operator node, HashSet visitedOperators, ArrayList dfsNumbers) {
        if (!visitedOperators.contains(node)) {
            visitedOperators.add(node);
            int i = 0;
            while (i < node.getNumberOfOutPorts()) {
                Iterator iter = node.getOutPort(i).getPartnerIterator();
                while (iter.hasNext()) {
                    this.directedDFS(((Port)iter.next()).getOperator(), visitedOperators, dfsNumbers);
                }
                ++i;
            }
            if (dfsNumbers != null) {
                dfsNumbers.add(node);
            }
        }
    }

    private boolean hasCircle(Operator operator, HashSet activeOperators, HashSet visitedOperators) {
        activeOperators.add(operator);
        visitedOperators.add(operator);
        int i = 0;
        while (i < operator.getNumberOfOutPorts()) {
            Iterator iter = operator.getOutPort(i).getPartnerIterator();
            while (iter.hasNext()) {
                Port port = (Port)iter.next();
                if (activeOperators.contains(port.getOperator())) {
                    return true;
                }
                if (visitedOperators.contains(port.getOperator()) || !this.hasCircle(port.getOperator(), activeOperators, visitedOperators)) continue;
                return true;
            }
            ++i;
        }
        activeOperators.remove(operator);
        return false;
    }

    void enqueueReadyOperator(Operator operator) {
        this.ready.add(operator);
    }

    public int getOperatorCount() {
        return this.nodes.size();
    }

    public boolean containsOperator(Operator operator) {
        return this.nodes.contains(operator);
    }

    public Start getStart() {
        return this.start;
    }

    public Finish getFinish() {
        return this.finish;
    }

    public Operator getOperator(int index) {
        return (Operator)this.nodes.get(index);
    }

    public void addOperator(Operator operator) {
        if (operator == null) {
            throw new NullPointerException("Can't add null as operator.");
        }
        this.nodes.add(operator);
    }

    public void removeOperator(Operator operator) {
        if (operator.equals(this.start) || operator.equals(this.finish)) {
            throw new UnsupportedOperationException();
        }
        this.schedule.getEventController().removeModule(operator);
        int i = 0;
        while (i < operator.getNumberOfInPorts() + operator.getNumberOfOutPorts()) {
            this.schedule.getEventController().removeModule(operator.getPortAt(i));
            ++i;
        }
        i = 0;
        while (i < this.parameterControllers.size()) {
            ((ParameterController)this.parameterControllers.get(i)).objectRemoved(operator);
            ++i;
        }
        this.nodes.remove(operator);
    }

    public boolean isOperatorRemovable(Operator operator) {
        return !operator.equals(this.start) && !operator.equals(this.finish);
    }

    public boolean isEmpty() {
        return this.nodes.size() == 2 && this.start.getOutPort(0).getNumberOfPartners() == 0 && this.finish.getInPort(0).getNumberOfPartners() == 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toDotGraph() {
        StringBuffer s = new StringBuffer();
        s.append("digraph G {\n");
        s.append("\trankdir=LR;\n");
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.nodes.size()) {
            map.put(this.nodes.get(i), new Integer(i));
            s.append("\tn" + i + "[shape=record,label=\"{");
            int j = 0;
            while (j < ((Operator)this.nodes.get(i)).getNumberOfInPorts()) {
                if (j == 0) {
                    s.append("{");
                }
                s.append("<in" + j + "> " + j);
                if (j == ((Operator)this.nodes.get(i)).getNumberOfInPorts() - 1) {
                    s.append("}");
                }
                s.append("|");
                ++j;
            }
            s.append(((Operator)this.nodes.get(i)).getName());
            j = 0;
            while (j < ((Operator)this.nodes.get(i)).getNumberOfOutPorts()) {
                if (j == 0) {
                    s.append("|");
                    s.append("{");
                }
                s.append("<out" + j + "> " + j);
                if (j < ((Operator)this.nodes.get(i)).getNumberOfOutPorts() - 1) {
                    s.append("|");
                } else {
                    s.append("}");
                }
                ++j;
            }
            s.append("}\"];\n");
            ++i;
        }
        i = 0;
        while (i < this.nodes.size()) {
            Operator g = (Operator)this.nodes.get(i);
            int j = 0;
            while (j < g.getNumberOfOutPorts()) {
                Iterator iter = g.getOutPort(j).getPartnerIterator();
                while (iter.hasNext()) {
                    Port p = (Port)iter.next();
                    s.append("\t\"n" + i + "\":out" + j + " -> \"n" + map.get(p.getOperator()) + "\":in" + p.getNumber() + ";\n");
                }
                ++j;
            }
            ++i;
        }
        s.append("}");
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Name: " + this.name);
        s.append("Description: " + this.description);
        s.append("Nodes: ");
        int i = 0;
        while (i < this.nodes.size()) {
            s.append(String.valueOf(i) + ") " + this.nodes.get(i).toString());
            ++i;
        }
        return s.toString();
    }

    public void connect(Port sourcePort, Port targetPort) throws PortConnectException {
        if (!(sourcePort instanceof OutPort) || !(targetPort instanceof InPort)) {
            throw new PortConnectException("sourcePort has to be an OutPort and targetPort has to be an InPort.");
        }
        sourcePort.addPartner(targetPort);
    }

    public void disconnect(Port sourcePort, Port targetPort) {
        sourcePort.removePartner(targetPort);
    }

    public void scheduleEdited(ScheduleEvent evt) {
        int i = 0;
        while (i < this.nodes.size()) {
            int j;
            if (this.nodes.get(i) instanceof HasFloatingNumberOfInPorts) {
                j = ((Operator)this.nodes.get(i)).getNumberOfInPorts() - 1;
                while (j >= 0) {
                    if (((Operator)this.nodes.get(i)).getInPort(j).getNumberOfPartners() == 0) {
                        ((HasFloatingNumberOfInPorts)this.nodes.get(i)).removeInPort(j);
                    }
                    --j;
                }
            }
            if (this.nodes.get(i) instanceof HasFloatingNumberOfOutPorts) {
                j = ((Operator)this.nodes.get(i)).getNumberOfOutPorts() - 1;
                while (j >= 0) {
                    if (((Operator)this.nodes.get(i)).getOutPort(j).getNumberOfPartners() == 0) {
                        ((HasFloatingNumberOfOutPorts)this.nodes.get(i)).removeOutPort(j);
                    }
                    --j;
                }
            }
            ++i;
        }
        this.initNodes.clear();
        HashSet visited = new HashSet();
        int i2 = 0;
        while (i2 < this.nodes.size()) {
            if (!visited.contains(this.nodes.get(i2))) {
                this.directedDFS((Operator)this.nodes.get(i2), visited, this.initNodes);
            }
            ++i2;
        }
    }

    public Object[] getAllPossibleEventSources() {
        ArrayList<OutPort> ports = new ArrayList<OutPort>();
        int i = 0;
        while (i < this.nodes.size()) {
            Operator g = (Operator)this.nodes.get(i);
            int j = 0;
            while (j < g.getNumberOfOutPorts()) {
                if (g.getOutPort(j).getNumberOfPartners() != 0 || !(g instanceof HasFloatingNumberOfOutPorts)) {
                    ports.add(g.getOutPort(j));
                }
                ++j;
            }
            ++i;
        }
        return ports.toArray();
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, ScheduleEvent.class, this.schedule);
    }

    public List getParameterControllers() {
        return this.parameterControllers;
    }

    public void removeFromEventController() {
        this.schedule.getEventController().removeModule(this);
        Iterator it = this.parameterControllers.iterator();
        while (it.hasNext()) {
            this.schedule.getEventController().removeModule(it.next());
        }
        for (Operator node : this.nodes) {
            this.schedule.getEventController().removeModule(node);
            int i = 0;
            while (i < node.getNumberOfInPorts()) {
                this.schedule.getEventController().removeModule(node.getInPort(i));
                ++i;
            }
            i = 0;
            while (i < node.getNumberOfOutPorts()) {
                this.schedule.getEventController().removeModule(node.getOutPort(i));
                ++i;
            }
        }
    }

    public List getParameterControllersForProperty(Operator operator, String propName) {
        ArrayList<ParameterController> controllers = new ArrayList<ParameterController>();
        List parameterControllers = operator.getOperatorGraph().getParameterControllers();
        for (ParameterController controller : parameterControllers) {
            String[] paramNames = controller.getListOfParameters();
            int i = 0;
            while (i < paramNames.length) {
                if (controller.getOperatorForParameter(paramNames[i]) == operator && controller.getPropNameForParameter(paramNames[i]).equals(propName)) {
                    controllers.add(controller);
                }
                ++i;
            }
        }
        return controllers;
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        Iterator iter = this.nodes.iterator();
        while (iter.hasNext()) {
            ((Operator)iter.next()).testSchedule(schedule);
        }
        iter = this.parameterControllers.iterator();
        while (iter.hasNext()) {
            ((ParameterController)iter.next()).testSchedule(schedule);
        }
    }
}

