/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.SearchSpace;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;
import freak.module.searchspace.logictree.AndNode;

public class TheftCrossover
extends MultiPairwiseCrossover
implements CompatibleWithDifferentSearchSpaces {
    public TheftCrossover(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof BooleanFunction)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        BooleanFunctionGenotype bf1 = (BooleanFunctionGenotype)ind1.getGenotype();
        BooleanFunctionGenotype bf2 = (BooleanFunctionGenotype)ind2.getGenotype();
        BooleanFunctionGenotype bfout = (BooleanFunctionGenotype)bf1.clone();
        AndNode an = bf2.getUsedAndNodeRandomly();
        bfout.insertAnd(an);
        return new Individual(this.graph.getSchedule(), bfout, new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "Adds one AndNode from the second individual to the first individual.";
    }

    public String getName() {
        return "TheftCrossover";
    }
}

