/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.view.SingleIndividualView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;

public class IsingModelCliquesView
extends SingleIndividualView
implements Configurable,
FreakSwingModel {
    private static final float MAXIMAL_HUE = 0.8f;
    private static float SATURATION = 1.0f;
    private static float BRIGHTNESS = 1.0f;
    private int maximalNumberOfBridges = 1000;
    private boolean rotateCliques = true;

    public IsingModelCliquesView(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException("Does only work with the fitness IsingModelCliques");
        }
    }

    public JPanel createIndividualPanel() {
        return new CliquesPanel(this);
    }

    public String getName() {
        return "Ising Model Cliques";
    }

    public String getDescription() {
        return "Shows the nodes of the Ising Model on cliques. Only the bridges between the cliques are displayed.";
    }

    public void setPropertyMaximalNumberOfBridges(Integer number) {
        if (number > 0) {
            this.maximalNumberOfBridges = number;
        }
    }

    public Integer getPropertyMaximalNumberOfBridges() {
        return new Integer(this.maximalNumberOfBridges);
    }

    public String getShortDescriptionForMaximalNumberOfBridges() {
        return "Maximal number of bridges";
    }

    public String getLongDescriptionForMaximalNumberOfBridges() {
        return "Sets the maximal number of bridges displayed in the view. If more bridges are to be displayed, only the first ones are shown.";
    }

    public void setPropertyRotateCliques(Boolean b) {
        this.rotateCliques = b;
        UpdateManager.markDirty(this);
    }

    public Boolean getPropertyRotateCliques() {
        return new Boolean(this.rotateCliques);
    }

    public String getShortDescriptionForRotateCliques() {
        return "Rotate cliques";
    }

    public String getLongDescriptionForRotateCliques() {
        return "If set, all cliques will be rotated so that they face the center of the graph.";
    }

    class CliquesPanel
    extends JPanel {
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private IsingModelCliquesView view;
        private IsingModelCliques.Clique[] cliques;
        private boolean oldRotateCliques;
        private int[][] nodePositions;
        private int[][] cliquePositions;
        private int nodeRadius;
        private double cliqueRadius;
        private double graphRadius;

        public CliquesPanel(IsingModelCliquesView view) {
            this.view = view;
            this.setBackground(Color.white);
        }

        private void computeCoordinates() {
            int n = ((GeneralString)IsingModelCliquesView.this.getSchedule().getGenotypeSearchSpace()).getDimension();
            this.nodePositions = new int[n][2];
            this.cliquePositions = new int[this.cliques.length][2];
            this.computeRadii();
            int currentPosition = 0;
            int i = 0;
            while (i < this.cliques.length) {
                this.cliquePositions[i][0] = this.currentWidth / 2 + (int)(Math.sin(Math.PI * 2 * (double)i / (double)this.cliques.length) * this.graphRadius);
                this.cliquePositions[i][1] = this.currentHeight / 2 - (int)(Math.cos(Math.PI * 2 * (double)i / (double)this.cliques.length) * this.graphRadius);
                double cliqueRotation = IsingModelCliquesView.this.rotateCliques ? Math.PI * -2 * (double)i / (double)this.cliques.length : 0.0;
                int j = 0;
                while (j < this.cliques[i].getSize()) {
                    this.nodePositions[currentPosition][0] = this.cliquePositions[i][0] + (int)(Math.sin(Math.PI * 2 * (double)j / (double)this.cliques[i].getSize() + cliqueRotation) * this.cliqueRadius);
                    this.nodePositions[currentPosition][1] = this.cliquePositions[i][1] + (int)(Math.cos(Math.PI * 2 * (double)j / (double)this.cliques[i].getSize() + cliqueRotation) * this.cliqueRadius);
                    ++currentPosition;
                    ++j;
                }
                ++i;
            }
        }

        private void computeRadii() {
            this.graphRadius = Math.min(this.currentWidth, this.currentHeight) / 2;
            this.cliqueRadius = Math.sin(Math.PI / (double)this.cliques.length) * this.graphRadius * 0.5;
            this.nodeRadius = (int)(Math.sin(Math.PI / (double)this.cliques[0].getSize()) * this.cliqueRadius);
            double scale = this.graphRadius / (this.graphRadius + this.cliqueRadius + (double)this.nodeRadius);
            this.graphRadius *= scale;
            this.cliqueRadius *= scale;
            this.nodeRadius = (int)((double)this.nodeRadius * scale);
            this.nodeRadius = Math.max(this.nodeRadius, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            int oldCurrentWidth = this.currentWidth;
            int oldCurrentHeight = this.currentHeight;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            IsingModelCliquesView isingModelCliquesView = this.view;
            synchronized (isingModelCliquesView) {
                IsingModelCliques ising = (IsingModelCliques)IsingModelCliquesView.this.getSchedule().getRealFitnessFunction();
                if (this.cliques == null || this.cliques != ising.getCliques() || oldCurrentWidth != this.currentWidth || oldCurrentHeight != this.currentHeight || this.oldRotateCliques != IsingModelCliquesView.this.rotateCliques) {
                    this.oldRotateCliques = IsingModelCliquesView.this.rotateCliques;
                    this.cliques = ising.getCliques();
                    if (this.cliques != null) {
                        this.computeCoordinates();
                    }
                }
                if (this.cliques != null) {
                    Color[] colors = new Color[((GeneralString)IsingModelCliquesView.this.getSchedule().getGenotypeSearchSpace()).getPropertyNumberOfChars().intValue()];
                    int i = 0;
                    while (i < colors.length) {
                        colors[i] = this.getColor(i);
                        ++i;
                    }
                    Individual individual = IsingModelCliquesView.this.getIndividualToDisplay();
                    if (individual != null) {
                        g.setColor(Color.black);
                        int[][] bridges = ising.getBridges();
                        int i2 = 0;
                        while (i2 < Math.min(bridges.length, IsingModelCliquesView.this.maximalNumberOfBridges)) {
                            int x1 = this.nodePositions[bridges[i2][0]][0];
                            int y1 = this.nodePositions[bridges[i2][0]][1];
                            int x2 = this.nodePositions[bridges[i2][1]][0];
                            int y2 = this.nodePositions[bridges[i2][1]][1];
                            g.drawLine(x1, y1, x2, y2);
                            ++i2;
                        }
                        g.setColor(Color.gray);
                        i2 = 0;
                        while (i2 < this.cliques.length) {
                            g.drawOval(this.cliquePositions[i2][0] - (int)this.cliqueRadius, this.cliquePositions[i2][1] - (int)this.cliqueRadius, (int)this.cliqueRadius * 2, (int)this.cliqueRadius * 2);
                            ++i2;
                        }
                        int[] genotype = ((GeneralStringGenotype)individual.getGenotype()).getIntArray();
                        int i3 = 0;
                        while (i3 < genotype.length) {
                            g.setColor(colors[genotype[i3]]);
                            int x = this.nodePositions[i3][0];
                            int y = this.nodePositions[i3][1];
                            g.fillOval(x - this.nodeRadius / 2, y - this.nodeRadius / 2, this.nodeRadius, this.nodeRadius);
                            ++i3;
                        }
                    }
                }
            }
        }

        private Color getColor(int value) {
            int k = ((GeneralString)IsingModelCliquesView.this.getSchedule().getGenotypeSearchSpace()).getPropertyNumberOfChars();
            return new Color(Color.HSBtoRGB((float)value / (float)k * 0.8f, SATURATION, BRIGHTNESS));
        }
    }
}

