/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.utilities.graph;

import edu.ucsb.cs.jicos.applications.utilities.graph.GraphEuclidean;

public final class OldWeightedMatch {
    public static final boolean MINIMIZE = true;
    public static final boolean MAXIMIZE = false;
    private static final boolean DEBUG = false;
    private static final int UNMATCHED = 0;
    private static int V;
    private static int E;
    private static int dummyVertex;
    private static int dummyEdge;
    private static int[] a;
    private static int[] end;
    private static int[] mate;
    private static int[] weight;
    private static int[] base;
    private static int[] lastEdge;
    private static int[] lastVertex;
    private static int[] link;
    private static int[] nextDelta;
    private static int[] nextEdge;
    private static int[] nextPair;
    private static int[] nextVertex;
    private static int[] y;
    private static int delta;
    private static int lastDelta;
    private static int newBase;
    private static int nextBase;
    private static int oldBase;
    private static int stopScan;
    private static int pairPoint;
    private static int neighbor;
    private static int newLast;
    private static int nextPoint;
    private static int firstMate;
    private static int newMate;
    private static int oldFirst;
    private static int oldMate;
    private static int secondMate;
    private static int f;
    private static int nxtEdge;
    private static int nextE;
    private static int nextU;
    private static int e;
    private static int v;
    private static int i;

    public static int[] weightedMatch(int[][] nArray, boolean bl) {
        boolean bl2 = true;
        OldWeightedMatch.input(nArray);
        OldWeightedMatch.initialize(nArray, bl);
        while (true) {
            int n;
            delta = 0;
            v = 1;
            while (v <= V) {
                if (mate[v] == dummyEdge) {
                    OldWeightedMatch.pointer(dummyVertex, v, dummyEdge);
                }
                ++v;
            }
            while (true) {
                i = 1;
                n = 2;
                while (n <= V) {
                    if (nextDelta[i] > nextDelta[n]) {
                        i = n;
                    }
                    ++n;
                }
                delta = nextDelta[i];
                if (delta == lastDelta) {
                    OldWeightedMatch.setBounds();
                    OldWeightedMatch.unpairAll();
                    i = 1;
                    while (i <= V) {
                        OldWeightedMatch.mate[OldWeightedMatch.i] = end[mate[i]];
                        if (mate[i] == dummyVertex) {
                            OldWeightedMatch.mate[OldWeightedMatch.i] = 0;
                        }
                        ++i;
                    }
                    return mate;
                }
                v = base[i];
                if (link[v] >= 0) {
                    if (!OldWeightedMatch.pair()) continue;
                    break;
                }
                int n2 = OldWeightedMatch.bmate(v);
                if (link[n2] < 0) {
                    OldWeightedMatch.pointer(v, n2, OldWeightedMatch.oppEdge(nextEdge[i]));
                    continue;
                }
                OldWeightedMatch.unpair(v, n2);
            }
            lastDelta -= delta;
            OldWeightedMatch.setBounds();
            n = OldWeightedMatch.oppEdge(e);
            OldWeightedMatch.rematch(OldWeightedMatch.bend(e), n);
            OldWeightedMatch.rematch(OldWeightedMatch.bend(n), e);
        }
    }

    private static int bend(int n) {
        return base[end[n]];
    }

    private static int blink(int n) {
        return base[end[link[n]]];
    }

    private static int bmate(int n) {
        return base[end[mate[n]]];
    }

    private static int oppEdge(int n) {
        return (n - V) % 2 == 0 ? n - 1 : n + 1;
    }

    private static int slack(int n) {
        return y[end[n]] + y[end[OldWeightedMatch.oppEdge(n)]] - weight[n];
    }

    private static void initialize(int[][] nArray, boolean bl) {
        int n;
        OldWeightedMatch.setUp(nArray);
        dummyVertex = V + 1;
        dummyEdge = V + 2 * E + 1;
        OldWeightedMatch.end[OldWeightedMatch.dummyEdge] = dummyVertex;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n4 < V) {
            int n5 = n4 + 1;
            while (n5 < V) {
                n = 2 * nArray[n4][n5];
                if (n > n2) {
                    n2 = n;
                }
                if (n < n3) {
                    n3 = n;
                }
                ++n5;
            }
            ++n4;
        }
        if (bl) {
            if (V % 2 != 0) {
                throw new IllegalArgumentException("|V| must be even for a minimum cost maximum matching.");
            }
            n2 += 2;
            n = V + 1;
            while (n <= V + 2 * E) {
                OldWeightedMatch.weight[n] = n2 - weight[n];
                ++n;
            }
            n2 -= n3;
        }
        lastDelta = n2 / 2;
        n = V + 2;
        mate = new int[n];
        link = new int[n];
        base = new int[n];
        nextVertex = new int[n];
        lastVertex = new int[n];
        y = new int[n];
        nextDelta = new int[n];
        nextEdge = new int[n];
        n = V + 2 * E + 2;
        nextPair = new int[n];
        i = 1;
        while (i <= V + 1) {
            OldWeightedMatch.mate[OldWeightedMatch.i] = OldWeightedMatch.nextEdge[OldWeightedMatch.i] = dummyEdge;
            OldWeightedMatch.nextVertex[OldWeightedMatch.i] = 0;
            OldWeightedMatch.link[OldWeightedMatch.i] = -dummyEdge;
            OldWeightedMatch.base[OldWeightedMatch.i] = OldWeightedMatch.lastVertex[OldWeightedMatch.i] = i;
            OldWeightedMatch.y[OldWeightedMatch.i] = OldWeightedMatch.nextDelta[OldWeightedMatch.i] = lastDelta;
            ++i;
        }
    }

    private static void input(int[][] nArray) {
        V = nArray.length;
        E = V * (V - 1) / 2;
        int n = V + 2 * E + 2;
        a = new int[n];
        end = new int[n];
        weight = new int[n];
        int n2 = 0;
        while (n2 < n) {
            OldWeightedMatch.weight[n2] = 0;
            OldWeightedMatch.end[n2] = 0;
            OldWeightedMatch.a[n2] = 0;
            ++n2;
        }
    }

    private static void insertPair() {
        int n = OldWeightedMatch.slack(e) / 2;
        nextPoint = nextPair[pairPoint];
        while (end[nextPoint] < neighbor) {
            pairPoint = nextPoint;
            nextPoint = nextPair[nextPoint];
        }
        if (end[nextPoint] == neighbor) {
            if (n >= OldWeightedMatch.slack(nextPoint) / 2) {
                return;
            }
            nextPoint = nextPair[nextPoint];
        }
        OldWeightedMatch.nextPair[OldWeightedMatch.pairPoint] = e;
        pairPoint = e;
        OldWeightedMatch.nextPair[OldWeightedMatch.e] = nextPoint;
        if (nextDelta[newBase] > n) {
            OldWeightedMatch.nextDelta[OldWeightedMatch.newBase] = n;
        }
    }

    private static void linkPath(int n) {
        v = OldWeightedMatch.bend(n);
        while (v != newBase) {
            int n2 = OldWeightedMatch.bmate(v);
            OldWeightedMatch.link[n2] = OldWeightedMatch.oppEdge(n);
            OldWeightedMatch.nextVertex[OldWeightedMatch.newLast] = v;
            OldWeightedMatch.nextVertex[OldWeightedMatch.lastVertex[OldWeightedMatch.v]] = n2;
            newLast = lastVertex[n2];
            i = v;
            do {
                OldWeightedMatch.base[OldWeightedMatch.i] = newBase;
            } while ((i = nextVertex[i]) != dummyVertex);
            n = link[v];
            v = OldWeightedMatch.bend(n);
        }
    }

    private static void mergePairs(int n) {
        OldWeightedMatch.nextDelta[n] = lastDelta;
        pairPoint = dummyEdge;
        f = nextEdge[n];
        while (f != dummyEdge) {
            e = f;
            neighbor = end[e];
            f = nextPair[f];
            if (base[neighbor] == newBase) continue;
            OldWeightedMatch.insertPair();
        }
    }

    private static boolean pair() {
        e = nextEdge[v];
        while (OldWeightedMatch.slack(e) != 2 * delta) {
            e = nextPair[e];
        }
        int n = OldWeightedMatch.bend(e);
        OldWeightedMatch.link[OldWeightedMatch.bmate((int)n)] = -e;
        int n2 = OldWeightedMatch.bmate(v);
        while (link[n2] != -e) {
            OldWeightedMatch.link[n2] = -e;
            if (mate[n] != dummyEdge) {
                int n3 = v;
                v = n;
                n = n3;
            }
            v = OldWeightedMatch.blink(v);
            n2 = OldWeightedMatch.bmate(v);
        }
        if (n2 == dummyVertex && v != n) {
            return true;
        }
        newLast = newBase = v;
        oldFirst = nextVertex[v];
        OldWeightedMatch.linkPath(e);
        OldWeightedMatch.linkPath(OldWeightedMatch.oppEdge(e));
        OldWeightedMatch.nextVertex[OldWeightedMatch.newLast] = oldFirst;
        if (lastVertex[newBase] == newBase) {
            OldWeightedMatch.lastVertex[OldWeightedMatch.newBase] = newLast;
        }
        OldWeightedMatch.nextPair[OldWeightedMatch.dummyEdge] = dummyEdge;
        OldWeightedMatch.mergePairs(newBase);
        i = nextVertex[newBase];
        do {
            OldWeightedMatch.mergePairs(i);
            i = nextVertex[lastVertex[i]];
            OldWeightedMatch.scan(i, 2 * delta - OldWeightedMatch.slack(mate[i]));
        } while ((i = nextVertex[lastVertex[i]]) != oldFirst);
        return false;
    }

    private static void pointer(int n, int n2, int n3) {
        int n4;
        int n5;
        OldWeightedMatch.link[n] = -dummyEdge;
        int n6 = dummyVertex;
        OldWeightedMatch.nextVertex[OldWeightedMatch.lastVertex[n2]] = n6;
        OldWeightedMatch.nextVertex[OldWeightedMatch.lastVertex[n]] = n6;
        if (lastVertex[n] != n) {
            n5 = mate[nextVertex[n]];
            n4 = -OldWeightedMatch.slack(n5) / 2;
        } else {
            n4 = lastDelta;
        }
        n5 = n;
        while (n5 != dummyVertex) {
            int n7 = n5;
            y[n7] = y[n7] + n4;
            int n8 = n5;
            nextDelta[n8] = nextDelta[n8] + n4;
            n5 = nextVertex[n5];
        }
        if (link[n2] < 0) {
            OldWeightedMatch.link[n2] = n3;
            OldWeightedMatch.nextPair[OldWeightedMatch.dummyEdge] = dummyEdge;
            OldWeightedMatch.scan(n2, delta);
        } else {
            OldWeightedMatch.link[n2] = n3;
        }
    }

    private static void rematch(int n, int n2) {
        OldWeightedMatch.mate[n] = n2;
        nextE = -link[n];
        while (nextE != dummyEdge) {
            n2 = nextE;
            f = OldWeightedMatch.oppEdge(n2);
            n = OldWeightedMatch.bend(n2);
            secondMate = OldWeightedMatch.bend(f);
            nextE = -link[n];
            OldWeightedMatch.link[n] = -mate[secondMate];
            OldWeightedMatch.link[OldWeightedMatch.secondMate] = -mate[n];
            OldWeightedMatch.mate[n] = f;
            OldWeightedMatch.mate[OldWeightedMatch.secondMate] = n2;
        }
    }

    private static void scan(int n, int n2) {
        newBase = base[n];
        stopScan = nextVertex[lastVertex[n]];
        while (n != stopScan) {
            int n3 = n;
            y[n3] = y[n3] + n2;
            OldWeightedMatch.nextDelta[n] = lastDelta;
            pairPoint = dummyEdge;
            e = a[n];
            while (e != 0) {
                neighbor = end[e];
                int n4 = base[neighbor];
                if (link[n4] < 0) {
                    int n5;
                    if ((link[OldWeightedMatch.bmate(n4)] < 0 || lastVertex[n4] != n4) && nextDelta[neighbor] > (n5 = OldWeightedMatch.slack(e))) {
                        OldWeightedMatch.nextDelta[OldWeightedMatch.neighbor] = n5;
                        OldWeightedMatch.nextEdge[OldWeightedMatch.neighbor] = e;
                    }
                } else if (n4 != newBase) {
                    OldWeightedMatch.insertPair();
                }
                e = a[e];
            }
            n = nextVertex[n];
        }
        OldWeightedMatch.nextEdge[OldWeightedMatch.newBase] = nextPair[dummyEdge];
    }

    private static void setBounds() {
        v = 1;
        while (v <= V) {
            if (link[v] < 0 || base[v] != v) {
                OldWeightedMatch.nextDelta[OldWeightedMatch.v] = lastDelta;
            } else {
                OldWeightedMatch.link[OldWeightedMatch.v] = -link[v];
                i = v;
                while (i != dummyVertex) {
                    int n = i;
                    y[n] = y[n] - delta;
                    i = nextVertex[i];
                }
                f = mate[v];
                if (f != dummyEdge) {
                    i = OldWeightedMatch.bend(f);
                    int n = OldWeightedMatch.slack(f);
                    while (i != dummyVertex) {
                        int n2 = i;
                        y[n2] = y[n2] - n;
                        i = nextVertex[i];
                    }
                }
                OldWeightedMatch.nextDelta[OldWeightedMatch.v] = lastDelta;
            }
            ++v;
        }
    }

    private static void setUp(int[][] nArray) {
        int n = V + 2;
        int n2 = V;
        while (n2 >= 1) {
            int n3 = n2 - 1;
            while (n3 >= 1) {
                int n4;
                OldWeightedMatch.weight[n - 1] = OldWeightedMatch.weight[n] = (n4 = 2 * nArray[n2 - 1][n3 - 1]);
                OldWeightedMatch.end[n - 1] = n2;
                OldWeightedMatch.end[n] = n3;
                OldWeightedMatch.a[n] = a[n2];
                OldWeightedMatch.a[n2] = n;
                OldWeightedMatch.a[n - 1] = a[n3];
                OldWeightedMatch.a[n3] = n - 1;
                n += 2;
                --n3;
            }
            --n2;
        }
    }

    private static void unlink(int n) {
        i = newBase = nextVertex[n];
        nextBase = nextVertex[lastVertex[newBase]];
        e = link[nextBase];
        int n2 = 1;
        while (n2 <= 2) {
            do {
                nxtEdge = OldWeightedMatch.oppEdge(link[newBase]);
                int n3 = 1;
                while (n3 <= 2) {
                    OldWeightedMatch.link[OldWeightedMatch.newBase] = -link[newBase];
                    do {
                        OldWeightedMatch.base[OldWeightedMatch.i] = newBase;
                    } while ((i = nextVertex[i]) != nextBase);
                    newBase = nextBase;
                    nextBase = nextVertex[lastVertex[newBase]];
                    ++n3;
                }
            } while (link[nextBase] == nxtEdge);
            if (n2 != 1) break;
            OldWeightedMatch.lastEdge[1] = nxtEdge;
            nxtEdge = OldWeightedMatch.oppEdge(e);
            if (link[nextBase] != nxtEdge) break;
            ++n2;
        }
        OldWeightedMatch.lastEdge[2] = nxtEdge;
        if (base[lastVertex[n]] == n) {
            OldWeightedMatch.nextVertex[n] = newBase;
        } else {
            OldWeightedMatch.nextVertex[n] = dummyVertex;
            OldWeightedMatch.lastVertex[n] = n;
        }
    }

    private static void unpair(int n, int n2) {
        int n3;
        int n4;
        OldWeightedMatch.unlink(n);
        int n5 = OldWeightedMatch.bmate(n2);
        if (n5 != n) {
            OldWeightedMatch.link[n] = -dummyEdge;
            OldWeightedMatch.rematch(n5, mate[n]);
            int n6 = OldWeightedMatch.link[OldWeightedMatch.secondMate] = f == lastEdge[1] ? -lastEdge[2] : -lastEdge[1];
        }
        if ((n4 = OldWeightedMatch.bend(OldWeightedMatch.oppEdge(n3 = link[n2]))) == n5) {
            OldWeightedMatch.pointer(n5, n2, n3);
            return;
        }
        OldWeightedMatch.link[OldWeightedMatch.bmate((int)n4)] = -n3;
        do {
            n3 = -link[n4];
            v = OldWeightedMatch.bmate(n4);
            OldWeightedMatch.pointer(n4, v, -link[v]);
        } while ((n4 = OldWeightedMatch.bend(n3)) != n5);
        n3 = OldWeightedMatch.oppEdge(n3);
        OldWeightedMatch.pointer(n5, n2, n3);
    }

    private static void unpairAll() {
        v = 1;
        while (v <= V) {
            if (base[v] == v && lastVertex[v] != v) {
                nextU = v;
                OldWeightedMatch.nextVertex[OldWeightedMatch.lastVertex[OldWeightedMatch.nextU]] = dummyVertex;
                do {
                    int n = nextU;
                    nextU = nextVertex[nextU];
                    OldWeightedMatch.unlink(n);
                    if (lastVertex[n] != n) {
                        f = lastEdge[2] == OldWeightedMatch.oppEdge(e) ? lastEdge[1] : lastEdge[2];
                        OldWeightedMatch.nextVertex[OldWeightedMatch.lastVertex[OldWeightedMatch.bend((int)OldWeightedMatch.f)]] = n;
                    }
                    if ((newBase = OldWeightedMatch.bmate(OldWeightedMatch.bmate(n))) != dummyVertex && newBase != n) {
                        OldWeightedMatch.link[n] = -dummyEdge;
                        OldWeightedMatch.rematch(newBase, mate[n]);
                    }
                    while (lastVertex[nextU] == nextU && nextU != dummyVertex) {
                        nextU = nextVertex[nextU];
                    }
                } while (lastVertex[nextU] != nextU || nextU != dummyVertex);
            }
            ++v;
        }
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        GraphEuclidean graphEuclidean = new GraphEuclidean(n, n, 100);
        int[][] nArray = graphEuclidean.getCosts();
        long l = System.currentTimeMillis();
        int[] nArray2 = OldWeightedMatch.weightedMatch(nArray, true);
        long l2 = System.currentTimeMillis();
        System.out.println("Elapsed time (in milliseconds) for " + n + " node graph is " + (l2 - l));
        int n2 = 1;
        while (n2 <= nArray.length) {
            System.out.println(" " + n2 + " matches " + nArray2[n2]);
            ++n2;
        }
        System.out.println("main: Done.");
    }

    static {
        lastEdge = new int[3];
    }
}

