/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.mapper.Mapper;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.gui.ModuleList;
import freak.gui.scheduleeditor.ScheduleEditor;
import freak.gui.scheduleeditor.ScheduleEditorPanel;
import freak.gui.scheduleeditor.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PanelMapper
extends ScheduleEditorPanel {
    private Module[] mapper;
    private boolean scheduleStarted = false;
    private int lastSelectedIndex;
    private JButton buConfigMapper;
    private JCheckBox cbUseMapper;
    private JLabel jLabel1;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JList listMapper;
    private JPanel panelMapper;
    private JTextArea taDescrMapper;
    private JTextField tfOptionsMapper;

    public PanelMapper(ScheduleEditor scheduleEditor) {
        super(scheduleEditor);
        this.initComponents();
    }

    public static String getDescription() {
        return "Select Genotype-Mapper";
    }

    protected void initForStartedSchedule() {
        this.cbUseMapper.setEnabled(false);
        this.buConfigMapper.setVisible(false);
        this.listMapper.setEnabled(false);
        this.scheduleStarted = true;
    }

    public String getHelpURL() {
        return "node4.html#SECTION00443000000000000000";
    }

    public boolean mayAdvance() {
        return true;
    }

    public void enter() {
        super.enter();
        boolean useMapper = this.schedule.getMapper() != null;
        this.mapper = this.moduleCollector.getMapper(this.schedule.getPhenotypeSearchSpace());
        ((ModuleList)this.listMapper).setModules(this.mapper, this.schedule.getMapper());
        if (useMapper) {
            this.lastSelectedIndex = this.listMapper.getSelectedIndex();
        }
        this.cbUseMapper.setSelected(useMapper);
        this.updateStatus();
    }

    private void updateStatus() {
        boolean useMapper = this.cbUseMapper.isSelected();
        this.listMapper.setEnabled(useMapper && !this.scheduleStarted);
        if (useMapper) {
            this.listMapper.setSelectedIndex(this.lastSelectedIndex);
        } else {
            this.lastSelectedIndex = this.listMapper.getSelectedIndex();
            this.listMapper.getSelectionModel().clearSelection();
        }
        this.buConfigMapper.setEnabled(useMapper && this.schedule.getMapper() instanceof Configurable);
        this.taDescrMapper.setEnabled(useMapper);
    }

    private void parse() {
        Mapper m = this.schedule.getMapper();
        Util.displayText(this.taDescrMapper, m != null ? m.getDescription() : "<no mapper selected>");
        if (m instanceof Configurable) {
            Util.displayText(this.tfOptionsMapper, ((Configurable)((Object)m)).getConfiguration().getDescription());
        } else {
            Util.displayText(this.tfOptionsMapper, "<not configurable>");
        }
        this.buConfigMapper.setEnabled(m instanceof Configurable);
    }

    private void initComponents() {
        this.panelMapper = new JPanel();
        this.buConfigMapper = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.listMapper = new ModuleList();
        this.jLabel2 = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.taDescrMapper = new JTextArea();
        this.jLabel18 = new JLabel();
        this.tfOptionsMapper = new JTextField();
        this.cbUseMapper = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Select Mapper"));
        this.panelMapper.setLayout(new GridBagLayout());
        this.buConfigMapper.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.buConfigMapper.setMnemonic('o');
        this.buConfigMapper.setText("Configure...");
        this.buConfigMapper.setEnabled(false);
        this.buConfigMapper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelMapper.this.buConfigMapperActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.panelMapper.add((Component)this.buConfigMapper, gridBagConstraints);
        this.jLabel1.setText("Options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panelMapper.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane5.setMinimumSize(new Dimension(220, 0));
        this.jScrollPane5.setPreferredSize(new Dimension(220, 0));
        this.listMapper.setSelectionMode(0);
        this.listMapper.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PanelMapper.this.listMapperValueChanged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.listMapper);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panelMapper.add((Component)this.jScrollPane5, gridBagConstraints);
        this.jLabel2.setText("Mapper:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panelMapper.add((Component)this.jLabel2, gridBagConstraints);
        this.taDescrMapper.setEditable(false);
        this.taDescrMapper.setLineWrap(true);
        this.taDescrMapper.setText("<no mapper selected>");
        this.taDescrMapper.setWrapStyleWord(true);
        this.jScrollPane6.setViewportView(this.taDescrMapper);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panelMapper.add((Component)this.jScrollPane6, gridBagConstraints);
        this.jLabel18.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.panelMapper.add((Component)this.jLabel18, gridBagConstraints);
        this.tfOptionsMapper.setEditable(false);
        this.tfOptionsMapper.setText("<no mapper selected>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.panelMapper.add((Component)this.tfOptionsMapper, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.2;
        this.add((Component)this.panelMapper, gridBagConstraints);
        this.cbUseMapper.setText("Use Phenotype - Genotype Mapper");
        this.cbUseMapper.setToolTipText("Check this to enable the selection of a mapper module that maps phenotype individuals to genotype individuals and vice versa.");
        this.cbUseMapper.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelMapper.this.cbUseMapperActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0E-4;
        this.add((Component)this.cbUseMapper, gridBagConstraints);
    }

    private void cbUseMapperActionPerformed(ActionEvent evt) {
        this.updateStatus();
        if (!this.cbUseMapper.isSelected() && this.schedule.getMapper() != null) {
            this.schedule.getEventController().removeModule(this.schedule.getMapper());
            this.schedule.setMapper(null);
            this.scheduleDependencyChecker.processNewMapper();
        }
    }

    private void buConfigMapperActionPerformed(ActionEvent evt) {
        String s = Util.configureModule(this.scheduleEditor, this.schedule.getMapper(), this.schedule);
        if (s != null) {
            Util.displayText(this.tfOptionsMapper, s);
        }
        this.scheduleDependencyChecker.processNewModuleConfiguration(this.schedule.getMapper());
        this.scheduleEditor.updateComponents();
    }

    private void listMapperValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        if (!this.listMapper.isValid() || !this.listMapper.isEnabled()) {
            return;
        }
        Mapper oldObj = this.schedule.getMapper();
        Mapper newObj = (Mapper)this.listMapper.getSelectedValue();
        if (newObj != oldObj) {
            if (oldObj != null) {
                this.eventController.replaceGlobalEventSource(oldObj, newObj);
                this.eventController.removeModule(oldObj);
            }
            this.schedule.setMapper(newObj);
            this.scheduleDependencyChecker.processNewMapper();
            if (newObj != null) {
                newObj.createEvents();
            }
            this.scheduleEditor.updateComponents();
        }
        this.parse();
    }
}

