/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.split;

import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Split;
import freak.core.modulesupport.inspector.CustomizableInspector;
import freak.core.population.IndividualList;
import freak.core.population.Population;

public class RandomChoice
extends Split
implements HasFloatingNumberOfOutPorts,
CompatibleWithDifferentSearchSpaces {
    private Double[] prob = new Double[0];
    private transient CustomizableInspector inspector;
    private boolean uniformly;

    public RandomChoice(OperatorGraph graph) {
        super(graph);
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        if (this.getNumberOfOutPorts() == 0) {
            return new IndividualList[0];
        }
        double rand = this.getOperatorGraph().getSchedule().getRandomElement().uniform(0.0, 1.0);
        double pr = 0.0;
        int choose = this.getNumberOfInPorts() - 1;
        int bound = this.getNumberOfOutPorts();
        int i = 0;
        while (i < bound) {
            if (rand < (pr += this.prob[i].doubleValue())) {
                choose = i;
                break;
            }
            ++i;
        }
        IndividualList[] result = new IndividualList[this.getNumberOfOutPorts()];
        bound = this.getNumberOfOutPorts();
        int i2 = 0;
        while (i2 < bound) {
            result[i2] = new Population(this.getOperatorGraph().getSchedule());
            ++i2;
        }
        result[choose] = input[0];
        return result;
    }

    public String getDescription() {
        return "This operator chooses one of its outports at random and sends the whole input to this outport. The distribution over the outports can be specified by the properties Uniformly and Distribution.";
    }

    public String getName() {
        return "Random Choice";
    }

    public void setPropertyUniformly(Boolean b) {
        this.uniformly = b;
        if (this.uniformly) {
            this.setProbUniformly();
        }
    }

    public Boolean getPropertyUniformly() {
        return new Boolean(this.uniformly);
    }

    private void setProbUniformly() {
        int i = 0;
        while (i < this.prob.length) {
            this.prob[i] = new Double(1.0 / (double)this.prob.length);
            ++i;
        }
    }

    public String getShortDescriptionForProbVector() {
        return "Distribution";
    }

    public String getShortDescriptionForUniformly() {
        return "Uniformly";
    }

    public String getLongDescriptionForProbVector() {
        return "This property specifies the distribution over the outports which determines to which outport the whole input is sent.";
    }

    public String getLongDescriptionForUniformly() {
        return "If checked, the probability distribution is set to the uniform distribution.";
    }

    public void setPropertyProbVector(Double[] vector) {
        double sum = 0.0;
        int i = 1;
        while (i < vector.length) {
            sum += vector[i].doubleValue();
            if (vector[i] < 0.0) {
                return;
            }
            ++i;
        }
        if (sum > 1.0) {
            return;
        }
        if (vector.length > 0) {
            vector[0] = new Double(1.0 - sum);
        }
        this.uniformly = false;
        this.prob = vector;
    }

    public Double[] getPropertyProbVector() {
        return this.prob;
    }

    public void addOutPort() {
        super.addOutPort();
        int numOutPorts = 0;
        int i = 0;
        while (i < this.getNumberOfOutPorts()) {
            if (this.getOutPort(i).getNumberOfPartners() != 0) {
                ++numOutPorts;
            }
            ++i;
        }
        if (numOutPorts < this.prob.length) {
            return;
        }
        Double[] newProb = new Double[numOutPorts];
        int i2 = 0;
        while (i2 < this.prob.length) {
            newProb[i2] = this.prob[i2];
            ++i2;
        }
        double sum = 0.0;
        int i3 = 0;
        while (i3 < this.prob.length) {
            sum += newProb[i3].doubleValue();
            ++i3;
        }
        if (this.prob.length < numOutPorts) {
            newProb[this.prob.length] = new Double(1.0 - sum);
        }
        i3 = this.prob.length + 1;
        while (i3 < numOutPorts) {
            newProb[i3] = new Double(0.0);
            ++i3;
        }
        this.prob = newProb;
        if (this.uniformly) {
            this.setProbUniformly();
        }
        if (this.inspector != null) {
            this.inspector.getTable().updateTable();
        }
    }

    public void removeOutPort(int index) {
        super.removeOutPort(index);
        int numOutPorts = 0;
        int i = 0;
        while (i < this.getNumberOfOutPorts()) {
            if (this.getOutPort(i).getNumberOfPartners() != 0) {
                ++numOutPorts;
            }
            ++i;
        }
        Double[] newProb = new Double[numOutPorts];
        int i2 = 0;
        while (i2 < numOutPorts) {
            newProb[i2] = this.prob[i2];
            ++i2;
        }
        double sum = 0.0;
        int i3 = 1;
        while (i3 < numOutPorts) {
            sum += newProb[i3].doubleValue();
            ++i3;
        }
        if (this.prob.length > 0) {
            this.prob[0] = new Double(1.0 - sum);
        }
        this.prob = newProb;
        if (this.uniformly) {
            this.setProbUniformly();
        }
        if (this.inspector != null) {
            this.inspector.getTable().updateTable();
        }
    }
}

