% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get-mgmt.R
\name{get_profile}
\alias{get_profile}
\title{Gets a view (profile) to which the user has access to}
\usage{
get_profile(account.id, webproperty.id, profile.id, token,
  verbose = getOption("rga.verbose"))
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve the goal for.}

\item{webproperty.id}{character. Web property ID to retrieve the goal for.}

\item{profile.id}{View (Profile) ID to retrieve the goal for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
An Analytics view (profile).
\item{id}{View (Profile) ID.}
\item{kind}{Resource type for Analytics view (profile).}
\item{selfLink}{Link for this view (profile).}
\item{accountId}{Account ID to which this view (profile) belongs.}
\item{webPropertyId}{Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.}
\item{internalWebPropertyId}{Internal ID for the web property to which this view (profile) belongs.}
\item{name}{Name of this view (profile).}
\item{currency}{The currency type associated with this view (profile).}
\item{timezone}{Time zone for which this view (profile) has been configured. Time zones are identified by strings from the TZ database.}
\item{websiteUrl}{Website URL for this view (profile).}
\item{siteSearchQueryParameters}{The site search query parameters for this view (profile).}
\item{stripSiteSearchQueryParameters}{Whether or not Analytics will strip search query parameters from the URLs in your reports.}
\item{type}{View (Profile) type. Supported types: WEB or APP.}
\item{permissions}{Permissions the user has for this view (profile).}
\item{created}{Time this view (profile) was created.}
\item{updated}{Time this view (profile) was last modified.}
\item{eCommerceTracking}{Indicates whether ecommerce tracking is enabled for this view (profile).}
\item{parentLink}{Parent link for this view (profile). Points to the web property to which this view (profile) belongs.}
\item{childLink}{Child link for this view (profile). Points to the list of goals for this view (profile).}#'
}
\description{
Gets a view (profile) to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/profiles}{Google Management API - Unsampled Reports}
}
\seealso{
\code{\link{authorize}}

Other The Google Analytics Management API: \code{\link{get_accounts}},
  \code{\link{list_accounts}}; \code{\link{get_goals}},
  \code{\link{list_goals}}; \code{\link{get_goal}};
  \code{\link{get_profiles}}, \code{\link{list_profiles}};
  \code{\link{get_segments}}, \code{\link{list_segments}};
  \code{\link{get_webproperties}},
  \code{\link{list_webproperties}};
  \code{\link{get_webproperty}}
}

