% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_prcomp.R
\name{m_prcomp}
\alias{m_prcomp}
\title{Multiway Principal Component Analysis}
\usage{
m_prcomp(chrom, center = FALSE, scale = FALSE, npcs = 3, ...)
}
\arguments{
\item{chrom}{Multiple chromatograms readed or batch aligned}

\item{center}{A logical value indicating whether the variables should be
shifted to be zero centered. FALSE is set by default.}

\item{scale}{a logical value indicating whether the variables should
be scaled to have unit variance before the analysis takes place. The
default is FALSE.}

\item{npcs}{an integer indicating how many principals components are
desired to mantain. The default is 3 principal components.}

\item{...}{Other argments passed to \code{\link[stats]{prcomp}}
function.}
}
\value{
MPCA returns a list whit class "MPCA" containing the summary of the
  analysis, the scores matrix, unfolded loadings, and the metadata if it
  was provided when chromatograms were joined.
}
\description{
`m_prcomp` Performs a multiway principal components analysis on a given
two-dimensional chromatograms and returns the rusults as object of class
MPCA.
Before to perform the calculation, each given chromatogramas are unfolded
to a single dimension. All chromatograms are merged and principal component 
analysis is performed with the built-in \code{\link[stats]{prcomp}} function.
The print method for these objects prints the summary of the analysis.
This algorithm was first presented by \insertCite{Wold1987}{RGCxGC}.
}
\examples{

data(MTBLS579)
\donttest{
# Perform multiway principal component analysis
MTBLS579_mpca <- m_prcomp(MTBLS579, center = TRUE)
# Print MPCA summary
print(MTBLS579_mpca)
# Retrieve MPCA scores
scores(MTBLS579_mpca)
# Plot bidimensional scores
plot_loading(MTBLS579_mpca)
}

}
\references{
\insertAllCited{}
}
