% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox.R
\name{test_ushape_cox}
\alias{test_ushape_cox}
\title{Test U-shape relationship
This function checks for a U-shaped relationship between survival time and a set of variables.
Users are required to create and set the datadist option globally before using this function.}
\usage{
test_ushape_cox(my_data, variables)
}
\arguments{
\item{my_data}{A dataframe containing the data with survival times and event indicators.}

\item{variables}{A character vector specifying the names of the variables to be tested.}
}
\value{
No return value, produces a plot as a side effect.
}
\description{
Test U-shape relationship
This function checks for a U-shaped relationship between survival time and a set of variables.
Users are required to create and set the datadist option globally before using this function.
}
\examples{
\donttest{
library(rms)

data_path <- system.file("extdata", "cox_data.csv", package = "RGS")
my_data <- read.csv(data_path)

# create and set the datadist option globally
dd <- datadist(my_data)
options(datadist = "dd")

test_ushape_cox(my_data, c("u1", "u2"))
}

}
