% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{test_ushape_logistic}
\alias{test_ushape_logistic}
\title{Test U-shape relationship in logistic regression}
\usage{
test_ushape_logistic(my_data, variables)
}
\arguments{
\item{my_data}{A dataframe containing the data with response and predictor variables.}

\item{variables}{A character vector specifying the names of the predictor variables to be tested.}
}
\value{
No return value, produces a plot as a side effect.
}
\description{
This function plots the estimated relationship between the response variable and a set of predictor variables to identify potential U-shaped patterns.
Users are required to create and set the datadist option globally before using this function.
}
\examples{
\donttest{
library(rms)

data_path <- system.file("extdata", "logistic_data.csv", package = "RGS")
my_data <- read.csv(data_path)

# create and set the datadist option globally
dd <- datadist(my_data)
options(datadist = "dd")

test_ushape_logistic(my_data, c("u1", "u2"))
}

}
