/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.store.FileLister;
import org.h2.store.PageStore;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression expression) {
        this.fileNameExpr = expression;
    }

    @Override
    public int update() {
        String string = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string) {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            String string2 = database.getName();
            string2 = FileUtils.getName(string2);
            OutputStream outputStream = FileUtils.newOutputStream(string, false);
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            database.flush();
            String string3 = database.getName() + ".h2.db";
            this.backupPageStore(zipOutputStream, string3, database.getPageStore());
            String string4 = FileUtils.getParent(string3);
            Object object = database.getLobSyncObject();
            synchronized (object) {
                String string5 = database.getDatabasePath();
                String string6 = FileUtils.getParent(string5);
                string6 = FileLister.getDir(string6);
                ArrayList<String> arrayList = FileLister.getDatabaseFiles(string6, string2, true);
                for (String string7 : arrayList) {
                    if (!string7.endsWith(".lob.db")) continue;
                    BackupCommand.backupFile(zipOutputStream, string4, string7);
                }
            }
            zipOutputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupPageStore(ZipOutputStream zipOutputStream, String string, PageStore pageStore) throws IOException {
        Database database = this.session.getDatabase();
        string = FileUtils.getName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = 0;
        try {
            pageStore.setBackup(true);
            while ((n = pageStore.copyDirect(n, zipOutputStream)) >= 0) {
                int n2 = pageStore.getPageCount();
                database.setProgress(3, string, n, n2);
            }
        }
        finally {
            pageStore.setBackup(false);
        }
        zipOutputStream.closeEntry();
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        String string3 = FileUtils.toRealPath(string2);
        if (!string3.startsWith(string = FileUtils.toRealPath(string))) {
            DbException.throwInternalError(string3 + " does not start with " + string);
        }
        string3 = string3.substring(string.length());
        string3 = BackupCommand.correctFileName(string3);
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        InputStream inputStream = FileUtils.newInputStream(string2);
        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

