\name{reachRouting.default}
\alias{reachRouting.default}
\title{
default function for class of \code{reachRouting}
}
\description{
function for flood routing using 
parameteric Muskingum and muskingum-cunge techniques.
}
\usage{
\method{reachRouting}{default}(inflow,routingMethod="muskingum",
             routingParams=list(k=3,
                                x=0.2,
                                bedWith=NULL,
                                sideSlope=2,
                                channelSlope=NULL,
                                manningRoughness=0.025,
                                riverLength=NULL),
             simulation=c(interval=3600*1,period=NA))
}
\arguments{
  \item{inflow}{
a vector of runoff time series (cms) representing a runoff event generated by excess rainfall computed by \code{loss} methods or an object inherited from any of the following classes :{\code{transform} ; \code{reachRouting} ; \code{reservoirRouting}}.
}
  \item{routingMethod}{
a string: the type of channel routing method: \code{"muskingum"} or \code{"muskingumcunge"}
}
  \item{routingParams}{
a list : parameters associated to the \code{routingMethod}: \code{k} and \code{x} for \code{"muskingum"}, 
\code{bedWith} (m), \code{sideSlope} (m/m), \code{channelSlope} (m/m), 
 \code{manningRoughness}, \code{riverLength} (Km) for \code{"muskingumcunge"}
}
  \item{simulation}{
a vectors: number of simulation time steps and the simulation period in seconds.
}
}
\value{
a list: including inflow time series routing resaults and simulation details 
}
\references{
Chow, V. T., Maidment, D. R., & Mays, L. W. (1988). Applied hydrology.
}
\seealso{ \code{\link[RHMS]{reachRouting}} }
\author{
Rezgar Arabzadeh
}
\keyword{ list }