/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.tools;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.AdminOperationsProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MRAdmin
extends Configured
implements Tool {
    public MRAdmin() {
    }

    public MRAdmin(Configuration conf) {
        super(conf);
    }

    private static void printHelp(String cmd) {
        String summary = "hadoop mradmin is the command to execute Map-Reduce administrative commands.\nThe full syntax is: \n\nhadoop mradmin [-refreshServiceAcl] [-refreshQueueAcls] [-refreshNodes] [-refreshUserToGroupsMappings] [-refreshSuperUserGroupsConfiguration] [-help [cmd]]\n";
        String refreshServiceAcl = "-refreshServiceAcl: Reload the service-level authorization policy file\n\t\tJobtracker will reload the authorization policy file.\n";
        String refreshQueueAcls = "-refreshQueueAcls: Reload the queue acls\n\t\tJobTracker will reload the mapred-queue-acls.xml file.\n";
        String refreshUserToGroupsMappings = "-refreshUserToGroupsMappings: Refresh user-to-groups mappings\n";
        String refreshSuperUserGroupsConfiguration = "-refreshSuperUserGroupsConfiguration: Refresh superuser proxy groups mappings\n";
        String refreshNodes = "-refreshNodes: Refresh the hosts information at the jobtracker.\n";
        String help = "-help [cmd]: \tDisplays help for the given command or all commands if none\n\t\tis specified.\n";
        if ("refreshServiceAcl".equals(cmd)) {
            System.out.println(refreshServiceAcl);
        } else if ("refreshQueueAcls".equals(cmd)) {
            System.out.println(refreshQueueAcls);
        } else if ("refreshUserToGroupsMappings".equals(cmd)) {
            System.out.println(refreshUserToGroupsMappings);
        } else if ("refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.out.println(refreshSuperUserGroupsConfiguration);
        } else if ("refreshNodes".equals(cmd)) {
            System.out.println(refreshNodes);
        } else if ("help".equals(cmd)) {
            System.out.println(help);
        } else {
            System.out.println(summary);
            System.out.println(refreshServiceAcl);
            System.out.println(refreshQueueAcls);
            System.out.println(refreshUserToGroupsMappings);
            System.out.println(refreshSuperUserGroupsConfiguration);
            System.out.println(refreshNodes);
            System.out.println(help);
            System.out.println();
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    private static void printUsage(String cmd) {
        if ("-refreshServiceAcl".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshServiceAcl]");
        } else if ("-refreshQueueAcls".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshQueueAcls]");
        } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshUserToGroupsMappings]");
        } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
            System.err.println("Usage: java DFSAdmin [-refreshSuperUserGroupsConfiguration]");
        } else if ("-refreshNodes".equals(cmd)) {
            System.err.println("Usage: java MRAdmin [-refreshNodes]");
        } else {
            System.err.println("Usage: java MRAdmin");
            System.err.println("           [-refreshServiceAcl]");
            System.err.println("           [-refreshQueueAcls]");
            System.err.println("           [-refreshUserToGroupsMappings]");
            System.err.println("           [-refreshSuperUserGroupsConfiguration]");
            System.err.println("           [-refreshNodes]");
            System.err.println("           [-help [cmd]]");
            System.err.println();
            ToolRunner.printGenericCommandUsage(System.err);
        }
    }

    private static UserGroupInformation getUGI(Configuration conf) throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    private int refreshAuthorizationPolicy() throws IOException {
        Configuration conf = this.getConf();
        JobConf jConf = new JobConf(conf);
        conf.set("hadoop.security.service.user.name.key", jConf.get("mapreduce.jobtracker.kerberos.principal", ""));
        RefreshAuthorizationPolicyProtocol refreshProtocol = (RefreshAuthorizationPolicyProtocol)RPC.getProxy(RefreshAuthorizationPolicyProtocol.class, 1L, JobTracker.getAddress(conf), MRAdmin.getUGI(conf), conf, NetUtils.getSocketFactory(conf, RefreshAuthorizationPolicyProtocol.class));
        refreshProtocol.refreshServiceAcl();
        return 0;
    }

    private int refreshQueueAcls() throws IOException {
        Configuration conf = this.getConf();
        AdminOperationsProtocol adminOperationsProtocol = (AdminOperationsProtocol)RPC.getProxy(AdminOperationsProtocol.class, 2L, JobTracker.getAddress(conf), MRAdmin.getUGI(conf), conf, NetUtils.getSocketFactory(conf, AdminOperationsProtocol.class));
        adminOperationsProtocol.refreshQueueAcls();
        return 0;
    }

    private int refreshNodes() throws IOException {
        Configuration conf = this.getConf();
        AdminOperationsProtocol adminOperationsProtocol = (AdminOperationsProtocol)RPC.getProxy(AdminOperationsProtocol.class, 2L, JobTracker.getAddress(conf), MRAdmin.getUGI(conf), conf, NetUtils.getSocketFactory(conf, AdminOperationsProtocol.class));
        adminOperationsProtocol.refreshNodes();
        return 0;
    }

    public int refreshSuperUserGroupsConfiguration() throws IOException {
        Configuration conf = this.getConf();
        JobConf jConf = new JobConf(conf);
        conf.set("hadoop.security.service.user.name.key", jConf.get("mapreduce.jobtracker.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = (RefreshUserMappingsProtocol)RPC.getProxy(RefreshUserMappingsProtocol.class, 1L, JobTracker.getAddress(conf), MRAdmin.getUGI(conf), conf, NetUtils.getSocketFactory(conf, RefreshUserMappingsProtocol.class));
        refreshProtocol.refreshSuperUserGroupsConfiguration(conf);
        return 0;
    }

    private int refreshUserToGroupsMappings() throws IOException {
        Configuration conf = this.getConf();
        JobConf jConf = new JobConf(conf);
        conf.set("hadoop.security.service.user.name.key", jConf.get("mapreduce.jobtracker.kerberos.principal", ""));
        RefreshUserMappingsProtocol refreshProtocol = (RefreshUserMappingsProtocol)RPC.getProxy(RefreshUserMappingsProtocol.class, 1L, JobTracker.getAddress(conf), MRAdmin.getUGI(conf), conf, NetUtils.getSocketFactory(conf, RefreshUserMappingsProtocol.class));
        refreshProtocol.refreshUserToGroupsMappings(conf);
        return 0;
    }

    @Override
    public int run(String[] args) throws Exception {
        String cmd;
        if (args.length < 1) {
            MRAdmin.printUsage("");
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        if (("-refreshServiceAcl".equals(cmd = args[i++]) || "-refreshQueueAcls".equals(cmd) || "-refreshNodes".equals(cmd) || "-refreshUserToGroupsMappings".equals(cmd) || "-refreshSuperUserGroupsConfiguration".equals(cmd)) && args.length != 1) {
            MRAdmin.printUsage(cmd);
            return exitCode;
        }
        exitCode = 0;
        try {
            if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshAuthorizationPolicy();
            } else if ("-refreshQueueAcls".equals(cmd)) {
                exitCode = this.refreshQueueAcls();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-help".equals(cmd)) {
                if (i < args.length) {
                    MRAdmin.printUsage(args[i]);
                } else {
                    MRAdmin.printHelp("");
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                MRAdmin.printUsage("");
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            MRAdmin.printUsage(cmd);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        return exitCode;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run(new MRAdmin(), args);
        System.exit(result);
    }
}

