/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.LinuxMemoryCalculatorPlugin;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class MemoryCalculatorPlugin
extends Configured {
    public abstract long getVirtualMemorySize();

    public abstract long getPhysicalMemorySize();

    public static MemoryCalculatorPlugin getMemoryCalculatorPlugin(Class<? extends MemoryCalculatorPlugin> clazz, Configuration conf) {
        if (clazz != null) {
            return ReflectionUtils.newInstance(clazz, conf);
        }
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux")) {
                return new LinuxMemoryCalculatorPlugin();
            }
        }
        catch (SecurityException se) {
            return null;
        }
        return null;
    }
}

