/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.Command;
import ij.CommandListener;
import ij.CommandListenerPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.Menus;
import ij.WindowManager;
import ij.io.OpenDialog;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Menu;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class Executer
implements Runnable {
    private static String previousCommand;
    private static CommandListener listener;
    private static Vector listeners;
    private String command;
    private Thread thread;

    public Executer(String string) {
        this.command = string;
    }

    public Executer(String string, ImagePlus imagePlus) {
        if (string.startsWith("Repeat")) {
            this.command = previousCommand;
            IJ.setKeyUp(16);
        } else {
            this.command = string;
            if (!string.equals("Undo") && !string.equals("Close")) {
                previousCommand = string;
            }
        }
        IJ.resetEscape();
        this.thread = new Thread((Runnable)this, string);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCommandListeners(Command command, int n) {
        if (listeners.size() > 0) {
            Vector vector = listeners;
            synchronized (vector) {
                for (int i = 0; i < listeners.size(); ++i) {
                    CommandListener commandListener = (CommandListener)listeners.elementAt(i);
                    if (!(commandListener instanceof CommandListenerPlus)) continue;
                    ((CommandListenerPlus)commandListener).stateChanged(command, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        if (this.command == null) {
            return;
        }
        Command command = new Command(this.command);
        if (listeners.size() > 0) {
            Vector vector = listeners;
            synchronized (vector) {
                for (int i = 0; i < listeners.size(); ++i) {
                    object = (CommandListener)listeners.elementAt(i);
                    command.command = object.commandExecuting(command.command);
                    if (object instanceof CommandListenerPlus) {
                        ((CommandListenerPlus)object).stateChanged(command, 0);
                        if (command.isConsumed()) {
                            return;
                        }
                    }
                    if (command.command != null) continue;
                    return;
                }
            }
        }
        command.modifiers = (IJ.altKeyDown() ? 8 : 0) | (IJ.shiftKeyDown() ? 1 : 0);
        try {
            if (Recorder.record) {
                Recorder.setCommand(command.command);
                this.runCommand(command);
                Recorder.saveCommand();
            } else {
                this.runCommand(command);
            }
            int n = this.command.length();
            if (this.command.charAt(n - 1) != ']' && (n >= 4 || !this.command.equals("In") && !this.command.equals("Out"))) {
                IJ.setKeyUp(-1);
            }
        }
        catch (Throwable throwable) {
            IJ.showStatus("");
            IJ.showProgress(1, 1);
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                imagePlus.unlock();
            }
            object = throwable.getMessage();
            if (throwable instanceof OutOfMemoryError) {
                IJ.outOfMemory(this.command);
                this.notifyCommandListeners(command, 6);
            } else if (throwable instanceof RuntimeException && object != null && ((String)object).equals("Macro canceled")) {
                this.notifyCommandListeners(command, 5);
            } else {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                PrintWriter printWriter = new PrintWriter(charArrayWriter);
                throwable.printStackTrace(printWriter);
                String string = charArrayWriter.toString();
                if (IJ.isMacintosh()) {
                    if (string.indexOf("ThreadDeath") > 0) {
                        return;
                    }
                    string = Tools.fixNewLines(string);
                }
                int n = 350;
                int n2 = 250;
                if (string.indexOf("UnsupportedClassVersionError") != -1) {
                    if (string.indexOf("version 49.0") != -1) {
                        string = throwable + "\n \nThis plugin requires Java 1.5 or later.";
                        n = 700;
                        n2 = 150;
                    }
                    if (string.indexOf("version 50.0") != -1) {
                        string = throwable + "\n \nThis plugin requires Java 1.6 or later.";
                        n = 700;
                        n2 = 150;
                    }
                    if (string.indexOf("version 51.0") != -1) {
                        string = throwable + "\n \nThis plugin requires Java 1.7 or later.";
                        n = 700;
                        n2 = 150;
                    }
                }
                if (IJ.getInstance() != null) {
                    new TextWindow("Exception", string, n, n2);
                } else {
                    IJ.log(string);
                }
                this.notifyCommandListeners(command, 6);
            }
            IJ.abort();
        }
    }

    void runCommand(Command command) {
        Hashtable hashtable = Menus.getCommands();
        command.className = (String)hashtable.get(command.command);
        if (command.className != null) {
            int n;
            command.arg = "";
            if (command.className.endsWith("\")") && (n = command.className.lastIndexOf("(\"")) > 0) {
                command.arg = command.className.substring(n + 2, command.className.length() - 2);
                command.className = command.className.substring(0, n);
            }
            this.notifyCommandListeners(command, 1);
            if (command.isConsumed()) {
                return;
            }
            if (IJ.shiftKeyDown() && command.className.startsWith("ij.plugin.Macro_Runner") && !Menus.getShortcuts().contains("*" + command)) {
                IJ.open(IJ.getDirectory("plugins") + command.arg);
            } else {
                command.plugin = IJ.runPlugIn(command.command, command.className, command.arg);
            }
            this.notifyCommandListeners(command, 2);
        } else {
            this.notifyCommandListeners(command, 1);
            if (MacroInstaller.runMacroCommand(command.command)) {
                this.notifyCommandListeners(command, 3);
                return;
            }
            String string = IJ.getDirectory("luts") + command.command + ".lut";
            File file = new File(string);
            if (file.exists()) {
                String string2 = OpenDialog.getLastDirectory();
                IJ.open(string);
                this.notifyCommandListeners(command, 7);
                OpenDialog.setLastDirectory(string2);
            } else if (!this.openRecent(command.command)) {
                IJ.error("Unrecognized command: " + command.command);
            }
        }
        this.notifyCommandListeners(command, 4);
    }

    boolean openRecent(String string) {
        Menu menu = Menus.openRecentMenu;
        if (menu == null) {
            return false;
        }
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!menu.getItem(i).getLabel().equals(string)) continue;
            IJ.open(string);
            return true;
        }
        return false;
    }

    public static String getCommand() {
        return previousCommand;
    }

    public static void addCommandListener(CommandListener commandListener) {
        listeners.addElement(commandListener);
    }

    public static void removeCommandListener(CommandListener commandListener) {
        listeners.removeElement(commandListener);
    }

    static {
        listeners = new Vector();
    }
}

