/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GUI;
import ij.gui.MultiLineLabel;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.plugin.ScreenGrabber;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.Recorder;
import ij.util.Tools;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class GenericDialog
extends Dialog
implements ActionListener,
TextListener,
FocusListener,
ItemListener,
KeyListener,
AdjustmentListener,
WindowListener {
    public static final int MAX_SLIDERS = 25;
    protected Vector numberField;
    protected Vector stringField;
    protected Vector checkbox;
    protected Vector choice;
    protected Vector slider;
    protected TextArea textArea1;
    protected TextArea textArea2;
    protected Vector defaultValues;
    protected Vector defaultText;
    protected Component theLabel;
    private Button cancel;
    private Button okay;
    private Button no;
    private Button help;
    private String okLabel = "  OK  ";
    private String helpLabel = "Help";
    private boolean wasCanceled;
    private boolean wasOKed;
    private int y;
    private int nfIndex;
    private int sfIndex;
    private int cbIndex;
    private int choiceIndex;
    private int textAreaIndex;
    private GridBagLayout grid;
    private GridBagConstraints c;
    private boolean firstNumericField = true;
    private boolean firstSlider = true;
    private boolean invalidNumber;
    private String errorMessage;
    private boolean firstPaint = true;
    private Hashtable labels;
    private boolean macro;
    private String macroOptions;
    private int topInset;
    private int leftInset;
    private int bottomInset;
    private boolean customInsets;
    private int[] sliderIndexes;
    private double[] sliderScales;
    private Checkbox previewCheckbox;
    private Vector dialogListeners;
    private PlugInFilterRunner pfr;
    private String previewLabel = " Preview";
    private static final String previewRunning = "wait...";
    private boolean recorderOn;
    private boolean yesNoCancel;
    private char echoChar;
    private boolean hideCancelButton;
    private boolean centerDialog = true;
    private String helpURL;
    private String yesLabel;
    private String noLabel;

    public GenericDialog(String string) {
        this(string, WindowManager.getCurrentImage() != null ? WindowManager.getCurrentImage().getWindow() : (IJ.getInstance() != null ? IJ.getInstance() : new Frame()));
    }

    public GenericDialog(String string, Frame frame) {
        super(frame == null ? new Frame() : frame, string, true);
        if (Prefs.blackCanvas) {
            this.setForeground(SystemColor.controlText);
            this.setBackground(SystemColor.control);
        }
        this.grid = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.grid);
        this.macroOptions = Macro.getOptions();
        this.macro = this.macroOptions != null;
        this.addKeyListener(this);
        this.addWindowListener(this);
    }

    public void addNumericField(String string, double d, int n) {
        this.addNumericField(string, d, n, 6, null);
    }

    public void addNumericField(String string, double d, int n, int n2, String string2) {
        String string3 = string;
        if (string3.indexOf(95) != -1) {
            string3 = string3.replace('_', ' ');
        }
        Label label = this.makeLabel(string3);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = this.firstNumericField ? this.getInsets(5, 0, 3, 0) : this.getInsets(0, 0, 3, 0);
        this.grid.setConstraints(label, this.c);
        this.add(label);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            n2 -= 2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        TextField textField = new TextField(IJ.d2s(d, n), n2);
        if (IJ.isLinux()) {
            textField.setBackground(Color.white);
        }
        textField.addActionListener(this);
        textField.addTextListener(this);
        textField.addFocusListener(this);
        textField.addKeyListener(this);
        this.numberField.addElement(textField);
        this.defaultValues.addElement(new Double(d));
        this.defaultText.addElement(textField.getText());
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        textField.setEditable(true);
        this.firstNumericField = false;
        if (string2 == null || string2.equals("")) {
            this.grid.setConstraints(textField, this.c);
            this.add(textField);
        } else {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 0, 0));
            panel.add(textField);
            panel.add(new Label(" " + string2));
            this.grid.setConstraints(panel, this.c);
            this.add(panel);
        }
        if (Recorder.record || this.macro) {
            this.saveLabel(textField, string);
        }
        ++this.y;
    }

    private Label makeLabel(String string) {
        if (IJ.isMacintosh()) {
            string = string + " ";
        }
        return new Label(string);
    }

    private void saveLabel(Component component, String string) {
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        if (string.length() > 0) {
            if (string.charAt(0) == ' ') {
                string = string.trim();
            }
            this.labels.put(component, string);
        }
    }

    public void addStringField(String string, String string2) {
        this.addStringField(string, string2, 8);
    }

    public void addStringField(String string, String string2, int n) {
        String string3 = string;
        if (string3.indexOf(95) != -1) {
            string3 = string3.replace('_', ' ');
        }
        Label label = this.makeLabel(string3);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        boolean bl = this.customInsets;
        if (this.stringField == null) {
            this.stringField = new Vector(4);
            this.c.insets = this.getInsets(5, 0, 5, 0);
        } else {
            this.c.insets = this.getInsets(0, 0, 5, 0);
        }
        this.grid.setConstraints(label, this.c);
        this.add(label);
        if (bl) {
            this.c.insets = this.stringField.size() == 0 ? this.getInsets(5, 0, 5, 0) : this.getInsets(0, 0, 5, 0);
        }
        TextField textField = new TextField(string2, n);
        if (IJ.isLinux()) {
            textField.setBackground(Color.white);
        }
        textField.setEchoChar(this.echoChar);
        this.echoChar = '\u0000';
        textField.addActionListener(this);
        textField.addTextListener(this);
        textField.addFocusListener(this);
        textField.addKeyListener(this);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(textField, this.c);
        textField.setEditable(true);
        this.add(textField);
        this.stringField.addElement(textField);
        if (Recorder.record || this.macro) {
            this.saveLabel(textField, string);
        }
        ++this.y;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
    }

    public void addCheckbox(String string, boolean bl) {
        this.addCheckbox(string, bl, false);
    }

    private void addCheckbox(String string, boolean bl, boolean bl2) {
        String string2 = string;
        if (string2.indexOf(95) != -1) {
            string2 = string2.replace('_', ' ');
        }
        if (this.checkbox == null) {
            this.checkbox = new Vector(4);
            this.c.insets = this.getInsets(15, 20, 0, 0);
        } else {
            this.c.insets = this.getInsets(0, 20, 0, 0);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        Checkbox checkbox = new Checkbox(string2);
        this.grid.setConstraints(checkbox, this.c);
        checkbox.setState(bl);
        checkbox.addItemListener(this);
        checkbox.addKeyListener(this);
        this.add(checkbox);
        this.checkbox.addElement(checkbox);
        if (!bl2 && (Recorder.record || this.macro)) {
            this.saveLabel(checkbox, string);
        }
        if (bl2) {
            this.previewCheckbox = checkbox;
        }
        ++this.y;
    }

    public void addPreviewCheckbox(PlugInFilterRunner plugInFilterRunner) {
        if (this.previewCheckbox != null) {
            return;
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && imagePlus.isComposite() && ((CompositeImage)imagePlus).getMode() == 1) {
            return;
        }
        this.pfr = plugInFilterRunner;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addPreviewCheckbox(PlugInFilterRunner plugInFilterRunner, String string) {
        if (this.previewCheckbox != null) {
            return;
        }
        this.previewLabel = string;
        this.pfr = plugInFilterRunner;
        this.addCheckbox(this.previewLabel, false, true);
    }

    public void addCheckboxGroup(int n, int n2, String[] stringArray, boolean[] blArray) {
        this.addCheckboxGroup(n, n2, stringArray, blArray, null);
    }

    public void addCheckboxGroup(int n, int n2, String[] stringArray, boolean[] blArray, String[] stringArray2) {
        Panel panel = new Panel();
        int n3 = stringArray2 != null ? n + 1 : n;
        panel.setLayout(new GridLayout(n3, n2, 6, 0));
        int n4 = this.cbIndex;
        if (this.checkbox == null) {
            this.checkbox = new Vector(12);
        }
        if (stringArray2 != null) {
            Font font = new Font("SansSerif", 1, 12);
            for (int i = 0; i < n2; ++i) {
                if (i > stringArray2.length - 1 || stringArray2[i] == null) {
                    panel.add(new Label(""));
                    continue;
                }
                Label label = new Label(stringArray2[i]);
                label.setFont(font);
                panel.add(label);
            }
        }
        int n5 = 0;
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < n; ++i) {
            int n6;
            for (int j = 0; j < n2 && (n6 = j * n + i) < stringArray.length; ++j) {
                Component component;
                nArray[n5] = n6;
                String string = stringArray[n5];
                if (string == null || string.length() == 0) {
                    component = new Label("");
                    panel.add(component);
                    ++n5;
                    continue;
                }
                if (string.indexOf(95) != -1) {
                    string = string.replace('_', ' ');
                }
                component = new Checkbox(string);
                this.checkbox.addElement(component);
                ((Checkbox)component).setState(blArray[n5]);
                ((Checkbox)component).addItemListener(this);
                if (Recorder.record || this.macro) {
                    this.saveLabel(component, stringArray[n5]);
                }
                if (IJ.isLinux()) {
                    Panel panel2 = new Panel();
                    panel2.setLayout(new BorderLayout());
                    panel2.add("West", component);
                    panel.add(panel2);
                } else {
                    panel.add(component);
                }
                ++n5;
            }
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(10, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addChoice(String string, String[] stringArray, String string2) {
        String string3 = string;
        if (string3.indexOf(95) != -1) {
            string3 = string3.replace('_', ' ');
        }
        Label label = this.makeLabel(string3);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        if (this.choice == null) {
            this.choice = new Vector(4);
            this.c.insets = this.getInsets(5, 0, 5, 0);
        } else {
            this.c.insets = this.getInsets(0, 0, 5, 0);
        }
        this.grid.setConstraints(label, this.c);
        this.add(label);
        Choice choice = new Choice();
        choice.addKeyListener(this);
        choice.addItemListener(this);
        for (int i = 0; i < stringArray.length; ++i) {
            choice.addItem(stringArray[i]);
        }
        choice.select(string2);
        this.c.gridx = 1;
        this.c.gridy = this.y;
        this.c.anchor = 17;
        this.grid.setConstraints(choice, this.c);
        this.add(choice);
        this.choice.addElement(choice);
        if (Recorder.record || this.macro) {
            this.saveLabel(choice, string);
        }
        ++this.y;
    }

    public void addMessage(String string) {
        this.addMessage(string, null);
    }

    public void addMessage(String string, Font font) {
        this.theLabel = null;
        this.theLabel = string.indexOf(10) >= 0 ? new MultiLineLabel(string) : new Label(string);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(string.equals("") ? 0 : 10, 20, 0, 0);
        this.grid.setConstraints(this.theLabel, this.c);
        if (font != null) {
            this.theLabel.setFont(font);
        }
        this.add(this.theLabel);
        ++this.y;
    }

    public void addTextAreas(String string, String string2, int n, int n2) {
        if (this.textArea1 != null) {
            return;
        }
        Panel panel = new Panel();
        this.textArea1 = new TextArea(string, n, n2, 3);
        if (IJ.isLinux()) {
            this.textArea1.setBackground(Color.white);
        }
        this.textArea1.addTextListener(this);
        panel.add(this.textArea1);
        if (string2 != null) {
            this.textArea2 = new TextArea(string2, n, n2, 3);
            if (IJ.isLinux()) {
                this.textArea2.setBackground(Color.white);
            }
            panel.add(this.textArea2);
        }
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = 17;
        this.c.insets = this.getInsets(15, 20, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void addSlider(String string, double d, double d2, double d3) {
        String string2;
        int n = 4;
        int n2 = 0;
        double d4 = 1.0;
        if (d2 - d <= 5.0 && (d != (double)((int)d) || d2 != (double)((int)d2))) {
            d4 = 20.0;
            d *= d4;
            d2 *= d4;
            d3 *= d4;
            n2 = 2;
        }
        if ((string2 = string).indexOf(95) != -1) {
            string2 = string2.replace('_', ' ');
        }
        Label label = this.makeLabel(string2);
        this.c.gridx = 0;
        this.c.gridy = this.y;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.insets = new Insets(0, 0, 3, 0);
        this.grid.setConstraints(label, this.c);
        this.add(label);
        if (this.slider == null) {
            this.slider = new Vector(5);
            this.sliderIndexes = new int[25];
            this.sliderScales = new double[25];
        }
        Scrollbar scrollbar = new Scrollbar(0, (int)d3, 1, (int)d, (int)d2 + 1);
        this.slider.addElement(scrollbar);
        scrollbar.addAdjustmentListener(this);
        scrollbar.setUnitIncrement(1);
        if (this.numberField == null) {
            this.numberField = new Vector(5);
            this.defaultValues = new Vector(5);
            this.defaultText = new Vector(5);
        }
        if (IJ.isWindows()) {
            n -= 2;
        }
        if (n < 1) {
            n = 1;
        }
        TextField textField = new TextField(IJ.d2s(d3 / d4, n2), n);
        if (IJ.isLinux()) {
            textField.setBackground(Color.white);
        }
        textField.addActionListener(this);
        textField.addTextListener(this);
        textField.addFocusListener(this);
        textField.addKeyListener(this);
        this.numberField.addElement(textField);
        this.sliderIndexes[this.slider.size() - 1] = this.numberField.size() - 1;
        this.sliderScales[this.slider.size() - 1] = d4;
        this.defaultValues.addElement(new Double(d3 / d4));
        this.defaultText.addElement(textField.getText());
        textField.setEditable(true);
        this.firstSlider = false;
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 75;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(scrollbar, gridBagConstraints);
        panel.add(scrollbar);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(textField, gridBagConstraints);
        panel.add(textField);
        this.grid.setConstraints(panel, this.c);
        this.c.gridx = 1;
        this.c.gridy = this.y++;
        this.c.gridwidth = 1;
        this.c.anchor = 17;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
        if (Recorder.record || this.macro) {
            this.saveLabel(textField, string);
        }
    }

    public void addPanel(Panel panel) {
        this.addPanel(panel, 17, new Insets(5, 0, 0, 0));
    }

    public void addPanel(Panel panel, int n, Insets insets) {
        this.c.gridx = 0;
        this.c.gridy = this.y++;
        this.c.gridwidth = 2;
        this.c.anchor = n;
        this.c.insets = insets;
        this.grid.setConstraints(panel, this.c);
        this.add(panel);
    }

    public void setInsets(int n, int n2, int n3) {
        this.topInset = n;
        this.leftInset = n2;
        this.bottomInset = n3;
        this.customInsets = true;
    }

    public void setOKLabel(String string) {
        this.okLabel = string;
    }

    public void setHelpLabel(String string) {
        this.helpLabel = string;
    }

    public void enableYesNoCancel() {
        this.enableYesNoCancel(" Yes ", " No ");
    }

    public void enableYesNoCancel(String string, String string2) {
        this.yesLabel = string;
        this.noLabel = string2;
        this.yesNoCancel = true;
    }

    public void hideCancelButton() {
        this.hideCancelButton = true;
    }

    Insets getInsets(int n, int n2, int n3, int n4) {
        if (this.customInsets) {
            this.customInsets = false;
            return new Insets(this.topInset, this.leftInset, this.bottomInset, 0);
        }
        return new Insets(n, n2, n3, n4);
    }

    public void addDialogListener(DialogListener dialogListener) {
        if (this.dialogListeners == null) {
            this.dialogListeners = new Vector();
        }
        this.dialogListeners.addElement(dialogListener);
        if (IJ.debugMode) {
            IJ.log("GenericDialog: Listener added: " + dialogListener);
        }
    }

    public boolean wasCanceled() {
        if (this.wasCanceled) {
            Macro.abort();
        }
        return this.wasCanceled;
    }

    public boolean wasOKed() {
        return this.wasOKed || this.macro;
    }

    public double getNextNumber() {
        double d;
        if (this.numberField == null) {
            return -1.0;
        }
        TextField textField = (TextField)this.numberField.elementAt(this.nfIndex);
        String string = textField.getText();
        String string2 = null;
        if (this.macro) {
            string2 = (String)this.labels.get(textField);
            string = Macro.getValue(this.macroOptions, string2, string);
        }
        String string3 = (String)this.defaultText.elementAt(this.nfIndex);
        double d2 = (Double)this.defaultValues.elementAt(this.nfIndex);
        if (string.equals(string3)) {
            d = d2;
        } else {
            Double d3 = this.getValue(string);
            if (d3 != null) {
                d = d3;
            } else {
                Interpreter interpreter;
                if (string.startsWith("&")) {
                    string = string.substring(1);
                }
                double d4 = d = (interpreter = Interpreter.getInstance()) != null ? interpreter.getVariable(string) : Double.NaN;
                if (Double.isNaN(d)) {
                    this.invalidNumber = true;
                    this.errorMessage = "\"" + string + "\" is an invalid number";
                    d = 0.0;
                    if (this.macro) {
                        IJ.error("Macro Error", "Numeric value expected in run() function\n \n   Dialog box title: \"" + this.getTitle() + "\"\n" + "   Key: \"" + string2.toLowerCase(Locale.US) + "\"\n" + "   Value or variable name: \"" + string + "\"");
                    }
                }
            }
        }
        if (this.recorderOn) {
            this.recordOption(textField, this.trim(string));
        }
        ++this.nfIndex;
        return d;
    }

    private String trim(String string) {
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.endsWith(".00")) {
            string = string.substring(0, string.length() - 3);
        }
        return string;
    }

    private void recordOption(Component component, String string) {
        String string2 = (String)this.labels.get(component);
        if (string.equals("")) {
            string = "[]";
        }
        Recorder.recordOption(string2, string);
    }

    private void recordCheckboxOption(Checkbox checkbox) {
        String string = (String)this.labels.get(checkbox);
        if (string != null) {
            if (checkbox.getState()) {
                Recorder.recordOption(string);
            } else if (Recorder.getCommandOptions() == null) {
                Recorder.recordOption(" ");
            }
        }
    }

    protected Double getValue(String string) {
        Double d;
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        return d;
    }

    public boolean invalidNumber() {
        boolean bl = this.invalidNumber;
        this.invalidNumber = false;
        return bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getNextString() {
        String string;
        if (this.stringField == null) {
            return "";
        }
        TextField textField = (TextField)this.stringField.elementAt(this.sfIndex);
        String string2 = textField.getText();
        if (this.macro && (string2 = Macro.getValue(this.macroOptions, string = (String)this.labels.get(textField), string2)) != null && (string2.startsWith("&") || string.toLowerCase(Locale.US).startsWith(string2))) {
            Interpreter interpreter;
            String string3;
            if (string2.startsWith("&")) {
                string2 = string2.substring(1);
            }
            String string4 = string3 = (interpreter = Interpreter.getInstance()) != null ? interpreter.getVariableAsString(string2) : null;
            if (string3 != null) {
                string2 = string3;
            }
        }
        if (this.recorderOn) {
            this.recordOption(textField, string2);
        }
        ++this.sfIndex;
        return string2;
    }

    public boolean getNextBoolean() {
        if (this.checkbox == null) {
            return false;
        }
        Checkbox checkbox = (Checkbox)this.checkbox.elementAt(this.cbIndex);
        if (this.recorderOn) {
            this.recordCheckboxOption(checkbox);
        }
        boolean bl = checkbox.getState();
        if (this.macro) {
            String string = (String)this.labels.get(checkbox);
            String string2 = Macro.trimKey(string);
            bl = this.isMatch(this.macroOptions, string2 + " ");
        }
        ++this.cbIndex;
        return bl;
    }

    boolean isMatch(String string, String string2) {
        if (string.startsWith(string2)) {
            return true;
        }
        string2 = " " + string2;
        int n = string.length();
        int n2 = string2.length();
        boolean bl = false;
        for (int i = 0; i < n - n2 + 1; ++i) {
            char c = string.charAt(i);
            if (bl && c == ']') {
                bl = false;
            } else if (c == '[') {
                bl = true;
            }
            if (c != string2.charAt(0) || bl || i > 1 && string.charAt(i - 1) == '=') continue;
            boolean bl2 = true;
            for (int j = 0; j < n2; ++j) {
                if (string2.charAt(j) == string.charAt(i + j)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    public String getNextChoice() {
        String string;
        if (this.choice == null) {
            return "";
        }
        Choice choice = (Choice)this.choice.elementAt(this.choiceIndex);
        String string2 = choice.getSelectedItem();
        if (this.macro && (string2 = Macro.getValue(this.macroOptions, string = (String)this.labels.get(choice), string2)) != null && string2.startsWith("&")) {
            string2 = this.getChoiceVariable(string2);
        }
        if (this.recorderOn) {
            this.recordOption(choice, string2);
        }
        ++this.choiceIndex;
        return string2;
    }

    public int getNextChoiceIndex() {
        if (this.choice == null) {
            return -1;
        }
        Choice choice = (Choice)this.choice.elementAt(this.choiceIndex);
        int n = choice.getSelectedIndex();
        if (this.macro) {
            String string = (String)this.labels.get(choice);
            String string2 = choice.getSelectedItem();
            int n2 = choice.getSelectedIndex();
            String string3 = Macro.getValue(this.macroOptions, string, string2);
            if (string3 != null && string3.startsWith("&")) {
                string3 = this.getChoiceVariable(string3);
            }
            choice.select(string3);
            n = choice.getSelectedIndex();
            if (n == n2 && !string3.equals(string2)) {
                String string4;
                Interpreter interpreter = Interpreter.getInstance();
                String string5 = string4 = interpreter != null ? interpreter.getStringVariable(string3) : null;
                if (string4 == null) {
                    IJ.error(this.getTitle(), "\"" + string3 + "\" is not a valid choice for \"" + string + "\"");
                } else {
                    string3 = string4;
                }
            }
        }
        if (this.recorderOn) {
            this.recordOption(choice, choice.getSelectedItem());
        }
        ++this.choiceIndex;
        return n;
    }

    private String getChoiceVariable(String string) {
        String string2;
        string = string.substring(1);
        Interpreter interpreter = Interpreter.getInstance();
        String string3 = string2 = interpreter != null ? interpreter.getStringVariable(string) : null;
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    public String getNextText() {
        String string;
        if (this.textAreaIndex == 0 && this.textArea1 != null) {
            string = this.textArea1.getText();
            ++this.textAreaIndex;
            if (this.macro) {
                string = Macro.getValue(this.macroOptions, "text1", string);
            }
            if (this.recorderOn) {
                String string2 = string;
                String string3 = Recorder.getCommand();
                if (string3 != null && string3.equals("Convolve...")) {
                    string2 = string.replaceAll("\n", "\\\\n");
                    if (!string.endsWith("\n")) {
                        string2 = string2 + "\\n";
                    }
                } else {
                    string2 = string.replace('\n', ' ');
                }
                Recorder.recordOption("text1", string2);
            }
        } else if (this.textAreaIndex == 1 && this.textArea2 != null) {
            this.textArea2.selectAll();
            string = this.textArea2.getText();
            ++this.textAreaIndex;
            if (this.macro) {
                string = Macro.getValue(this.macroOptions, "text2", string);
            }
            if (this.recorderOn) {
                Recorder.recordOption("text2", string.replace('\n', ' '));
            }
        } else {
            string = null;
        }
        return string;
    }

    public void showDialog() {
        if (this.macro) {
            this.recorderOn = Recorder.record && Recorder.recordInMacros;
        } else {
            boolean bl;
            if (this.pfr != null) {
                this.pfr.setDialog(this);
            }
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(1, 5, 0));
            this.cancel = new Button("Cancel");
            this.cancel.addActionListener(this);
            this.cancel.addKeyListener(this);
            if (this.yesNoCancel) {
                this.okLabel = this.yesLabel;
                this.no = new Button(this.noLabel);
                this.no.addActionListener(this);
                this.no.addKeyListener(this);
            }
            this.okay = new Button(this.okLabel);
            this.okay.addActionListener(this);
            this.okay.addKeyListener(this);
            boolean bl2 = bl = this.helpURL != null;
            if (bl) {
                this.help = new Button(this.helpLabel);
                this.help.addActionListener(this);
                this.help.addKeyListener(this);
            }
            if (IJ.isMacintosh()) {
                if (bl) {
                    panel.add(this.help);
                }
                if (this.yesNoCancel) {
                    panel.add(this.no);
                }
                if (!this.hideCancelButton) {
                    panel.add(this.cancel);
                }
                panel.add(this.okay);
            } else {
                panel.add(this.okay);
                if (this.yesNoCancel) {
                    panel.add(this.no);
                }
                if (!this.hideCancelButton) {
                    panel.add(this.cancel);
                }
                if (bl) {
                    panel.add(this.help);
                }
            }
            this.c.gridx = 0;
            this.c.gridy = this.y;
            this.c.anchor = 13;
            this.c.gridwidth = 2;
            this.c.insets = new Insets(15, 0, 0, 0);
            this.grid.setConstraints(panel, this.c);
            this.add(panel);
            if (IJ.isMacintosh()) {
                this.setResizable(false);
            }
            this.pack();
            this.setup();
            if (this.centerDialog) {
                GUI.center(this);
            }
            this.setVisible(true);
            this.recorderOn = Recorder.record;
            IJ.wait(50);
        }
        if (!this.wasCanceled && this.dialogListeners != null && this.dialogListeners.size() > 0) {
            this.resetCounters();
            ((DialogListener)this.dialogListeners.elementAt(0)).dialogItemChanged(this, null);
            this.recorderOn = false;
        }
        this.resetCounters();
    }

    private void resetCounters() {
        this.nfIndex = 0;
        this.sfIndex = 0;
        this.cbIndex = 0;
        this.choiceIndex = 0;
        this.textAreaIndex = 0;
        this.invalidNumber = false;
    }

    public Vector getNumericFields() {
        return this.numberField;
    }

    public Vector getStringFields() {
        return this.stringField;
    }

    public Vector getCheckboxes() {
        return this.checkbox;
    }

    public Vector getChoices() {
        return this.choice;
    }

    public Vector getSliders() {
        return this.slider;
    }

    public TextArea getTextArea1() {
        return this.textArea1;
    }

    public TextArea getTextArea2() {
        return this.textArea2;
    }

    public Component getMessage() {
        return this.theLabel;
    }

    public Checkbox getPreviewCheckbox() {
        return this.previewCheckbox;
    }

    public Button[] getButtons() {
        Button[] buttonArray = new Button[]{this.okay, this.cancel, this.no};
        return buttonArray;
    }

    public void previewRunning(boolean bl) {
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setLabel(bl ? previewRunning : this.previewLabel);
            if (IJ.isMacOSX()) {
                this.repaint();
            }
        }
    }

    public void centerDialog(boolean bl) {
        this.centerDialog = bl;
    }

    protected void setup() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okay || object == this.cancel | object == this.no) {
            this.wasCanceled = object == this.cancel;
            this.wasOKed = object == this.okay;
            this.dispose();
        } else if (object == this.help) {
            if (this.hideCancelButton) {
                this.wasOKed = true;
                this.dispose();
            }
            this.showHelp();
        } else {
            this.notifyListeners(actionEvent);
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.notifyListeners(textEvent);
        if (this.slider == null) {
            return;
        }
        Object object = textEvent.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            TextField textField;
            double d;
            int n = this.sliderIndexes[i];
            if (object != this.numberField.elementAt(n) || Double.isNaN(d = Tools.parseDouble((textField = (TextField)this.numberField.elementAt(n)).getText()))) continue;
            Scrollbar scrollbar = (Scrollbar)this.slider.elementAt(i);
            scrollbar.setValue((int)(d * this.sliderScales[i]));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.notifyListeners(itemEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof TextField) {
            ((TextField)component).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof TextField) {
            ((TextField)component).select(0, 0);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        IJ.setKeyDown(n);
        if (n == 10 && this.textArea1 == null) {
            this.wasOKed = true;
            if (IJ.isMacOSX() && IJ.isJava15()) {
                this.accessTextFields();
            }
            this.dispose();
        } else if (n == 27) {
            this.wasCanceled = true;
            this.dispose();
            IJ.resetEscape();
        } else if (n == 87 && (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            this.wasCanceled = true;
            this.dispose();
        }
    }

    void accessTextFields() {
        int n;
        if (this.stringField != null) {
            for (n = 0; n < this.stringField.size(); ++n) {
                ((TextField)this.stringField.elementAt(n)).getText();
            }
        }
        if (this.numberField != null) {
            for (n = 0; n < this.numberField.size(); ++n) {
                ((TextField)this.numberField.elementAt(n)).getText();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        boolean bl;
        int n = keyEvent.getKeyCode();
        IJ.setKeyUp(n);
        int n2 = keyEvent.getModifiers();
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (n2 & 4) != 0;
        boolean bl4 = bl = (n2 & 1) != 0;
        if (n == 71 && bl && (bl2 || bl3)) {
            new ScreenGrabber().run("");
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + 10, insets.left + 10, insets.bottom + 10, insets.right + 10);
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        for (int i = 0; i < this.slider.size(); ++i) {
            if (object != this.slider.elementAt(i)) continue;
            Scrollbar scrollbar = (Scrollbar)object;
            TextField textField = (TextField)this.numberField.elementAt(this.sliderIndexes[i]);
            int n = this.sliderScales[i] == 1.0 ? 0 : 2;
            textField.setText("" + IJ.d2s((double)scrollbar.getValue() / this.sliderScales[i], n));
        }
    }

    private void notifyListeners(AWTEvent aWTEvent) {
        int n;
        if (this.dialogListeners == null) {
            return;
        }
        boolean bl = true;
        for (n = 0; bl && n < this.dialogListeners.size(); ++n) {
            try {
                this.resetCounters();
                if (((DialogListener)this.dialogListeners.elementAt(n)).dialogItemChanged(this, aWTEvent)) continue;
                bl = false;
                continue;
            }
            catch (Exception exception) {
                IJ.beep();
                IJ.log("ERROR: " + exception + "\nin DialogListener of " + this.dialogListeners.elementAt(n) + "\nat " + exception.getStackTrace()[0] + "\nfrom " + exception.getStackTrace()[1]);
            }
        }
        int n2 = n = IJ.isMacOSX() && !this.okay.isEnabled() && bl ? 1 : 0;
        if (this.previewCheckbox != null) {
            this.previewCheckbox.setEnabled(bl);
        }
        this.okay.setEnabled(bl);
        if (n != 0) {
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.firstPaint) {
            if (this.numberField != null && IJ.isMacOSX()) {
                TextField textField = (TextField)this.numberField.elementAt(0);
                textField.setEditable(false);
                textField.setEditable(true);
            }
            if (this.numberField == null && this.stringField == null) {
                this.okay.requestFocus();
            }
            this.firstPaint = false;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.wasCanceled = true;
        this.dispose();
    }

    public void addHelp(String string) {
        this.helpURL = string;
    }

    void showHelp() {
        String string = "run('URL...', 'url=" + this.helpURL + "');";
        new MacroRunner(string);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

