/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.Straightener;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public double x1d;
    public double y1d;
    public double x2d;
    public double y2d;
    protected double x1R;
    protected double y1R;
    protected double x2R;
    protected double y2R;
    private double xHandleOffset;
    private double yHandleOffset;
    private double startxd;
    private double startyd;
    static boolean widthChanged;

    public Line(int n, int n2, int n3, int n4) {
        this((double)n, (double)n2, (double)n3, (double)n4);
    }

    public Line(double d, double d2, double d3, double d4) {
        super((int)d, (int)d2, 0, 0);
        this.type = 5;
        this.x1d = d;
        this.y1d = d2;
        this.x2d = d3;
        this.y2d = d4;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        this.x = (int)Math.min(this.x1d, this.x2d);
        this.y = (int)Math.min(this.y1d, this.y2d);
        this.x1R = this.x1d - (double)this.x;
        this.y1R = this.y1d - (double)this.y;
        this.x2R = this.x2d - (double)this.x;
        this.y2R = this.y2d - (double)this.y;
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        if (!(this instanceof Arrow) && lineWidth > 1) {
            this.updateWideLine(lineWidth);
        }
        this.updateClipRect();
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.state = 3;
    }

    public Line(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        this.startxd = this.ic.offScreenXD(n);
        this.startyd = this.ic.offScreenYD(n2);
        this.x1R = this.x2R = this.startxd - (double)this.startX;
        this.y1R = this.y2R = this.startyd - (double)this.startY;
        this.type = 5;
        if (!(this instanceof Arrow) && lineWidth > 1) {
            this.updateWideLine(lineWidth);
        }
    }

    public Line(int n, int n2, int n3, int n4, ImagePlus imagePlus) {
        this(n, n2, n3, n4);
        this.setImage(imagePlus);
    }

    protected void grow(int n, int n2) {
        double d;
        double d2 = this.ic != null ? this.ic.offScreenXD(n) : (double)n;
        double d3 = d = this.ic != null ? this.ic.offScreenYD(n2) : (double)n2;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 > (double)this.xMax) {
            d2 = this.xMax;
        }
        if (d > (double)this.yMax) {
            d = this.yMax;
        }
        double d4 = (double)this.x + this.x1R;
        double d5 = (double)this.y + this.y1R;
        if (this.constrain) {
            double d6;
            double d7 = Math.abs(d2 - d4);
            if (d7 >= (d6 = Math.abs(d - d5))) {
                d = d5;
            } else {
                d2 = d4;
            }
        }
        this.x = (int)Math.min((double)this.x + this.x1R, d2);
        this.y = (int)Math.min((double)this.y + this.y1R, d);
        this.x1R = d4 - (double)this.x;
        this.y1R = d5 - (double)this.y;
        this.x2R = d2 - (double)this.x;
        this.y2R = d - (double)this.y;
        if (IJ.controlKeyDown()) {
            this.x1R = (int)Math.round(this.x1R);
            this.y1R = (int)Math.round(this.y1R);
            this.x2R = (int)Math.round(this.x2R);
            this.y2R = (int)Math.round(this.y2R);
        }
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int n, int n2) {
        int n3 = this.ic.offScreenX(n);
        int n4 = this.ic.offScreenY(n2);
        this.x = (int)((double)this.x + ((double)n3 - this.startxd));
        this.y = (int)((double)this.y + ((double)n4 - this.startyd));
        this.clipboard = null;
        this.startxd = n3;
        this.startyd = n4;
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = this.ic.offScreenXD(n);
        double d6 = this.ic.offScreenYD(n2);
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        double d7 = Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
        switch (this.activeHandle) {
            case 0: {
                d4 = d5 - this.x1d;
                d3 = d6 - this.y1d;
                this.x1d = d5;
                this.y1d = d6;
                if (this.center) {
                    this.x2d -= d4;
                    this.y2d -= d3;
                }
                if (!this.aspect) break;
                d2 = d7 / Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
                d = this.x1d + (this.x2d - this.x1d) / 2.0;
                double d8 = this.y1d + (this.y2d - this.y1d) / 2.0;
                if (this.center) {
                    this.x1d = d - d2 * (d - this.x1d);
                    this.x2d = d + d2 * (this.x2d - d);
                    this.y1d = d8 - d2 * (d8 - this.y1d);
                    this.y2d = d8 + d2 * (this.y2d - d8);
                    break;
                }
                this.x1d = this.x2d - d2 * (this.x2d - this.x1d);
                this.y1d = this.y2d - d2 * (this.y2d - this.y1d);
                break;
            }
            case 1: {
                d4 = d5 - this.x2d;
                d3 = d6 - this.y2d;
                this.x2d = d5;
                this.y2d = d6;
                if (this.center) {
                    this.x1d -= d4;
                    this.y1d -= d3;
                }
                if (!this.aspect) break;
                d2 = d7 / Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
                d = this.x1d + (this.x2d - this.x1d) / 2.0;
                double d9 = this.y1d + (this.y2d - this.y1d) / 2.0;
                if (this.center) {
                    this.x1d = d - d2 * (d - this.x1d);
                    this.x2d = d + d2 * (this.x2d - d);
                    this.y1d = d9 - d2 * (d9 - this.y1d);
                    this.y2d = d9 + d2 * (this.y2d - d9);
                    break;
                }
                this.x2d = this.x1d + d2 * (this.x2d - this.x1d);
                this.y2d = this.y1d + d2 * (this.y2d - this.y1d);
                break;
            }
            case 2: {
                d4 = d5 - (this.x1d + (this.x2d - this.x1d) / 2.0);
                d3 = d6 - (this.y1d + (this.y2d - this.y1d) / 2.0);
                this.x1d += d4;
                this.y1d += d3;
                this.x2d += d4;
                this.y2d += d3;
                if (!(this.getStrokeWidth() > 1.0f)) break;
                this.x1d += this.xHandleOffset;
                this.y1d += this.yHandleOffset;
                this.x2d += this.xHandleOffset;
                this.y2d += this.yHandleOffset;
            }
        }
        if (this.constrain) {
            d4 = Math.abs(this.x1d - this.x2d);
            d3 = Math.abs(this.y1d - this.y2d);
            d2 = Math.min(this.x1d, this.x2d) + d4 / 2.0;
            d = Math.min(this.y1d, this.y2d) + d3 / 2.0;
            if (this.activeHandle == 0) {
                if (d4 >= d3) {
                    if (this.aspect) {
                        this.x1d = this.x2d > this.x1d ? this.x2d - d7 : this.x2d + d7;
                    }
                    this.y1d = this.y2d;
                    if (this.center) {
                        this.y1d = this.y2d = d;
                        if (this.aspect) {
                            if (d2 > this.x1d) {
                                this.x1d = d2 - d7 / 2.0;
                                this.x2d = d2 + d7 / 2.0;
                            } else {
                                this.x1d = d2 + d7 / 2.0;
                                this.x2d = d2 - d7 / 2.0;
                            }
                        }
                    }
                } else {
                    if (this.aspect) {
                        this.y1d = this.y2d > this.y1d ? this.y2d - d7 : this.y2d + d7;
                    }
                    this.x1d = this.x2d;
                    if (this.center) {
                        this.x1d = this.x2d = d2;
                        if (this.aspect) {
                            if (d > this.y1d) {
                                this.y1d = d - d7 / 2.0;
                                this.y2d = d + d7 / 2.0;
                            } else {
                                this.y1d = d + d7 / 2.0;
                                this.y2d = d - d7 / 2.0;
                            }
                        }
                    }
                }
            } else if (this.activeHandle == 1) {
                if (d4 >= d3) {
                    if (this.aspect) {
                        this.x2d = this.x1d > this.x2d ? this.x1d - d7 : this.x1d + d7;
                    }
                    this.y2d = this.y1d;
                    if (this.center) {
                        this.y1d = this.y2d = d;
                        if (this.aspect) {
                            if (d2 > this.x1d) {
                                this.x1d = d2 - d7 / 2.0;
                                this.x2d = d2 + d7 / 2.0;
                            } else {
                                this.x1d = d2 + d7 / 2.0;
                                this.x2d = d2 - d7 / 2.0;
                            }
                        }
                    }
                } else {
                    if (this.aspect) {
                        this.y2d = this.y1d > this.y2d ? this.y1d - d7 : this.y1d + d7;
                    }
                    this.x2d = this.x1d;
                    if (this.center) {
                        this.x1d = this.x2d = d2;
                        if (this.aspect) {
                            if (d > this.y1d) {
                                this.y1d = d - d7 / 2.0;
                                this.y2d = d + d7 / 2.0;
                            } else {
                                this.y1d = d + d7 / 2.0;
                                this.y2d = d - d7 / 2.0;
                            }
                        }
                    }
                }
            }
        }
        this.x = (int)Math.min(this.x1d, this.x2d);
        this.y = (int)Math.min(this.y1d, this.y2d);
        this.x1R = this.x1d - (double)this.x;
        this.y1R = this.y1d - (double)this.y;
        this.x2R = this.x2d - (double)this.x;
        this.y2R = this.y2d - (double)this.y;
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void mouseDownInHandle(int n, int n2, int n3) {
        this.state = 4;
        this.activeHandle = n;
        if (this.getStrokeWidth() <= 3.0f) {
            this.ic.setCursor(new Cursor(1));
        }
    }

    public void draw(Graphics graphics) {
        if (this.ic == null) {
            return;
        }
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        graphics.setColor(color);
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        int n = this.ic.screenXD(this.x1d);
        int n2 = this.ic.screenYD(this.y1d);
        int n3 = this.ic.screenXD(this.x2d);
        int n4 = this.ic.screenYD(this.y2d);
        int n5 = n + (n3 - n) / 2;
        int n6 = n2 + (n4 - n2) / 2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.stroke != null) {
            graphics2D.setStroke(this.getScaledStroke());
        }
        graphics.drawLine(n, n2, n3, n4);
        if (this.wideLine && !this.overlay) {
            graphics2D.setStroke(onePixelWide);
            graphics.setColor(Line.getColor());
            graphics.drawLine(n, n2, n3, n4);
        }
        if (this.state != 0 && !this.overlay) {
            int n7 = 2;
            this.handleColor = this.strokeColor != null ? this.strokeColor : ROIColor;
            this.drawHandle(graphics, n - n7, n2 - n7);
            this.handleColor = Color.white;
            this.drawHandle(graphics, n3 - n7, n4 - n7);
            this.drawHandle(graphics, n5 - n7, n6 - n7);
        }
        if (this.state != 3) {
            IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle(this.x1, this.y1, this.x2, this.y2)) + ", length=" + IJ.d2s(this.getLength()));
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getLength() {
        if (this.imp == null || IJ.altKeyDown()) {
            return this.getRawLength();
        }
        Calibration calibration = this.imp.getCalibration();
        return Math.sqrt((this.x2d - this.x1d) * calibration.pixelWidth * (this.x2d - this.x1d) * calibration.pixelWidth + (this.y2d - this.y1d) * calibration.pixelHeight * (this.y2d - this.y1d) * calibration.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
    }

    public double[] getPixels() {
        double[] dArray;
        if (this.getStrokeWidth() == 1.0f) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            dArray = imageProcessor.getLine(this.x1d, this.y1d, this.x2d, this.y2d);
        } else {
            int n;
            ImageProcessor imageProcessor = new Straightener().rotateLine(this.imp, (int)this.getStrokeWidth());
            if (imageProcessor == null) {
                return null;
            }
            int n2 = imageProcessor.getWidth();
            int n3 = imageProcessor.getHeight();
            dArray = new double[n2];
            imageProcessor.setInterpolate(false);
            for (n = 0; n < n3; ++n) {
                double[] dArray2 = imageProcessor.getLine(0.0, n, n2 - 1, n);
                for (int i = 0; i < n2; ++i) {
                    int n4 = i;
                    dArray[n4] = dArray[n4] + dArray2[i];
                }
            }
            n = 0;
            while (n < n2) {
                int n5 = n++;
                dArray[n5] = dArray[n5] / (double)n3;
            }
        }
        return dArray;
    }

    public Polygon getPolygon() {
        Polygon polygon = new Polygon();
        if (this.getStrokeWidth() == 1.0f) {
            polygon.addPoint(this.x1, this.y1);
            polygon.addPoint(this.x2, this.y2);
        } else {
            double d = Math.atan2(this.y1 - this.y2, this.x2 - this.x1);
            double d2 = (double)this.getStrokeWidth() / 2.0;
            double d3 = (double)this.x1 + Math.cos(d + 1.5707963267948966) * d2;
            double d4 = (double)this.y1 - Math.sin(d + 1.5707963267948966) * d2;
            double d5 = (double)this.x1 + Math.cos(d - 1.5707963267948966) * d2;
            double d6 = (double)this.y1 - Math.sin(d - 1.5707963267948966) * d2;
            double d7 = (double)this.x2 + Math.cos(d - 1.5707963267948966) * d2;
            double d8 = (double)this.y2 - Math.sin(d - 1.5707963267948966) * d2;
            double d9 = (double)this.x2 + Math.cos(d + 1.5707963267948966) * d2;
            double d10 = (double)this.y2 - Math.sin(d + 1.5707963267948966) * d2;
            polygon.addPoint((int)Math.round(d3), (int)Math.round(d4));
            polygon.addPoint((int)Math.round(d5), (int)Math.round(d6));
            polygon.addPoint((int)Math.round(d7), (int)Math.round(d8));
            polygon.addPoint((int)Math.round(d9), (int)Math.round(d10));
        }
        return polygon;
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        imageProcessor.setLineWidth(1);
        if (this.getStrokeWidth() == 1.0f) {
            imageProcessor.moveTo(this.x1, this.y1);
            imageProcessor.lineTo(this.x2, this.y2);
        } else {
            imageProcessor.drawPolygon(this.getPolygon());
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int n, int n2) {
        if (this.getStrokeWidth() > 1.0f) {
            if (n == this.x1 && n2 == this.y1 || n == this.x2 && n2 == this.y2) {
                return true;
            }
            return this.getPolygon().contains(n, n2);
        }
        return false;
    }

    public int isHandle(int n, int n2) {
        int n3 = 10;
        if (this.getStrokeWidth() > 1.0f) {
            n3 += (int)Math.log(this.getStrokeWidth());
        }
        int n4 = n3 / 2;
        int n5 = this.ic.screenXD((double)this.x + this.x1R) - n4;
        int n6 = this.ic.screenYD((double)this.y + this.y1R) - n4;
        int n7 = this.ic.screenXD((double)this.x + this.x2R) - n4;
        int n8 = this.ic.screenYD((double)this.y + this.y2R) - n4;
        int n9 = n5 + (n7 - n5) / 2 - 1;
        int n10 = n6 + (n8 - n6) / 2 - 1;
        if (n >= n5 && n <= n5 + n3 && n2 >= n6 && n2 <= n6 + n3) {
            return 0;
        }
        if (n >= n7 && n <= n7 + n3 && n2 >= n8 && n2 <= n8 + n3) {
            return 1;
        }
        if (n >= n9 && n <= n9 + n3 + 2 && n2 >= n10 && n2 <= n10 + n3 + 2) {
            return 2;
        }
        return -1;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int n) {
        int n2;
        if (n < 1) {
            n = 1;
        }
        if (n > (n2 = 500)) {
            ImagePlus imagePlus = WindowManager.getCurrentImage();
            if (imagePlus != null) {
                n2 = Math.max(n2, imagePlus.getWidth());
                n2 = Math.max(n2, imagePlus.getHeight());
            }
            if (n > n2) {
                n = n2;
            }
        }
        lineWidth = n;
        widthChanged = true;
    }

    public void setStrokeWidth(float f) {
        super.setStrokeWidth(f);
        if (this.getStrokeColor() == Roi.getColor()) {
            this.wideLine = true;
        }
    }

    public Rectangle getBounds() {
        int n = (int)Math.round(Math.min(this.x1d, this.x2d));
        int n2 = (int)Math.round(Math.min(this.y1d, this.y2d));
        int n3 = (int)Math.round(Math.abs(this.x2d - this.x1d));
        int n4 = (int)Math.round(Math.abs(this.y2d - this.y1d));
        return new Rectangle(n, n2, n3, n4);
    }

    protected int clipRectMargin() {
        return 4;
    }

    public void nudgeCorner(int n) {
        if (this.ic == null) {
            return;
        }
        double d = 1.0 / this.ic.getMagnification();
        switch (n) {
            case 38: {
                this.y2R -= d;
                break;
            }
            case 40: {
                this.y2R += d;
                break;
            }
            case 37: {
                this.x2R -= d;
                break;
            }
            case 39: {
                this.x2R += d;
            }
        }
        this.grow(this.ic.screenXD((double)this.x + this.x2R), this.ic.screenYD((double)this.y + this.y2R));
    }
}

