/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Menus;
import ij.io.SaveDialog;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class PluginInstaller {
    PluginInstaller() {
    }

    boolean install(String string) {
        Object object;
        boolean bl = string.startsWith("http://") || string.startsWith("https://");
        byte[] byArray = null;
        String string2 = string;
        if (bl) {
            object = null;
            try {
                object = new URL(string);
            }
            catch (Exception exception) {
                IJ.error("" + exception);
                return false;
            }
            int n = string.lastIndexOf("/");
            if (n != -1 && n <= string.length() - 1) {
                string2 = string.substring(n + 1);
            }
            byArray = this.download((URL)object);
        } else {
            object = new File(string);
            string2 = ((File)object).getName();
            byArray = this.download((File)object);
        }
        if (byArray == null) {
            return false;
        }
        object = new SaveDialog("Save Plugin...", Menus.getPlugInsPath(), string2, null);
        String string3 = ((SaveDialog)object).getFileName();
        if (string3 == null) {
            return false;
        }
        String string4 = ((SaveDialog)object).getDirectory();
        if (!this.savePlugin(new File(string4, string2), byArray)) {
            return false;
        }
        Menus.updateImageJMenus();
        return true;
    }

    boolean savePlugin(File file, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            IJ.error("Plugin Installer", "" + iOException);
            return false;
        }
        return true;
    }

    byte[] download(URL uRL) {
        byte[] byArray;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            int n = uRLConnection.getContentLength();
            IJ.showStatus("Downloading " + uRL.getFile());
            InputStream inputStream = uRLConnection.getInputStream();
            byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = inputStream.read(byArray, n2, n - n2);
                if (n3 < 0) {
                    throw new EOFException();
                }
                IJ.showProgress(n2 += n3, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return byArray;
    }

    byte[] download(File file) {
        if (!file.exists()) {
            IJ.error("Plugin Installer", "File not found: " + file);
            return null;
        }
        byte[] byArray = null;
        try {
            int n = (int)file.length();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            byArray = new byte[n];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
        }
        catch (Exception exception) {
            IJ.error("Plugin Installer", "" + exception);
            byArray = null;
        }
        return byArray;
    }
}

