/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.macro.Functions;
import ij.macro.Interpreter;
import ij.macro.MacroExtension;
import ij.macro.Variable;

public class ExtensionDescriptor {
    public String name;
    public int[] argTypes;
    public MacroExtension handler;

    public ExtensionDescriptor(String string, int[] nArray, MacroExtension macroExtension) {
        this.name = string;
        this.argTypes = nArray;
        this.handler = macroExtension;
    }

    public static ExtensionDescriptor newDescriptor(String string, MacroExtension macroExtension, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return new ExtensionDescriptor(string, nArray2, macroExtension);
    }

    public static ExtensionDescriptor newDescriptor(String string, MacroExtension macroExtension) {
        return ExtensionDescriptor.newDescriptor(string, macroExtension, new int[0]);
    }

    public static ExtensionDescriptor newDescriptor(String string, MacroExtension macroExtension, int n) {
        return ExtensionDescriptor.newDescriptor(string, macroExtension, new int[]{n});
    }

    public static ExtensionDescriptor newDescriptor(String string, MacroExtension macroExtension, int n, int n2) {
        return ExtensionDescriptor.newDescriptor(string, macroExtension, new int[]{n, n2});
    }

    public static ExtensionDescriptor newDescriptor(String string, MacroExtension macroExtension, int n, int n2, int n3) {
        return ExtensionDescriptor.newDescriptor(string, macroExtension, new int[]{n, n2, n3});
    }

    public static ExtensionDescriptor newDescriptor(String string, MacroExtension macroExtension, int n, int n2, int n3, int n4) {
        return ExtensionDescriptor.newDescriptor(string, macroExtension, new int[]{n, n2, n3, n4});
    }

    public static ExtensionDescriptor newDescriptor(String string, MacroExtension macroExtension, Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return new ExtensionDescriptor(string, nArray, macroExtension);
    }

    public static boolean isOptionalArg(int n) {
        return (n & 0x20) == 32;
    }

    public static boolean isOutputArg(int n) {
        return (n & 0x10) == 16;
    }

    public static int getRawType(int n) {
        return n & 0xFFFFFFCF;
    }

    public boolean checkArguments(Object[] objectArray) {
        block5: for (int i = 0; i < this.argTypes.length; ++i) {
            boolean bl = ExtensionDescriptor.isOptionalArg(this.argTypes[i]);
            boolean bl2 = ExtensionDescriptor.isOutputArg(this.argTypes[i]);
            int n = ExtensionDescriptor.getRawType(this.argTypes[i]);
            if (objectArray.length < i) {
                return bl;
            }
            switch (n) {
                case 1: {
                    if (bl2 ? !(objectArray[i] instanceof String[]) : !(objectArray[i] instanceof String)) {
                        return false;
                    }
                }
                case 2: {
                    if (bl2 ? !(objectArray[i] instanceof Double[]) : !(objectArray[i] instanceof Double)) {
                        return false;
                    }
                }
                case 4: {
                    if (objectArray[i] instanceof Object[]) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    public static String getTypeName(int n) {
        switch (ExtensionDescriptor.getRawType(n)) {
            case 1: {
                return "string";
            }
            case 2: {
                return "number";
            }
            case 4: {
                return "array";
            }
        }
        return "unknown";
    }

    private static String getVariableTypename(int n) {
        switch (n) {
            case 2: {
                return "string";
            }
            case 130: {
                return "number";
            }
            case 1: {
                return "array";
            }
        }
        return "unknown";
    }

    private static Object[] convertArray(Variable[] variableArray) {
        Object[] objectArray = new Object[variableArray.length];
        block5: for (int i = 0; i < variableArray.length; ++i) {
            switch (variableArray[i].getType()) {
                case 2: {
                    objectArray[i] = variableArray[i].getString();
                    continue block5;
                }
                case 0: {
                    objectArray[i] = new Double(variableArray[i].getValue());
                    continue block5;
                }
                case 1: {
                    objectArray[i] = ExtensionDescriptor.convertArray(variableArray[i].getArray());
                    continue block5;
                }
                default: {
                    objectArray[i] = null;
                }
            }
        }
        return objectArray;
    }

    Variable[] parseArgumentList(Functions functions) {
        Interpreter interpreter = functions.interp;
        Variable[] variableArray = new Variable[this.argTypes.length];
        int n = 0;
        do {
            Variable variable;
            if (n >= this.argTypes.length) {
                interpreter.error("too many arguments (expected " + this.argTypes.length + ")");
                return null;
            }
            boolean bl = ExtensionDescriptor.isOutputArg(this.argTypes[n]);
            if (bl) {
                variable = functions.getVariable();
            } else {
                variable = new Variable();
                switch (ExtensionDescriptor.getRawType(this.argTypes[n])) {
                    case 1: {
                        variable.setString(functions.getString());
                        break;
                    }
                    case 2: {
                        variable.setValue(interpreter.getExpression());
                        break;
                    }
                    case 4: {
                        variable.setArray(functions.getArray());
                    }
                }
            }
            variableArray[n] = variable;
            ++n;
            interpreter.getToken();
        } while (interpreter.token == 44);
        if (interpreter.token != 41) {
            interpreter.error("')' expected");
        }
        if (n < this.argTypes.length && !ExtensionDescriptor.isOptionalArg(this.argTypes[n])) {
            interpreter.error("too few arguments, expected " + this.argTypes.length + " but found " + n);
        }
        return variableArray;
    }

    public static Object convertVariable(Interpreter interpreter, int n, Variable variable) {
        int n2 = ExtensionDescriptor.getRawType(n);
        boolean bl = ExtensionDescriptor.isOutputArg(n);
        if (variable == null) {
            return null;
        }
        switch (n2) {
            case 1: {
                if (!bl && variable.getType() != 2) {
                    interpreter.error("Expected string, but variable type is " + ExtensionDescriptor.getVariableTypename(variable.getType()));
                    return null;
                }
                if (bl) {
                    String string = variable.getString();
                    if (string == null) {
                        string = "";
                    }
                    return new String[]{string};
                }
                return variable.getString();
            }
            case 2: {
                if (variable.getType() != 0) {
                    interpreter.error("Expected number, but variable type is " + ExtensionDescriptor.getVariableTypename(variable.getType()));
                    return null;
                }
                if (bl) {
                    return new Double[]{new Double(variable.getValue())};
                }
                return new Double(variable.getValue());
            }
            case 4: {
                if (variable.getType() != 1) {
                    interpreter.error("Expected array, but variable type is " + ExtensionDescriptor.getVariableTypename(variable.getType()));
                    return null;
                }
                return ExtensionDescriptor.convertArray(variable.getArray());
            }
        }
        interpreter.error("Unknown descriptor type " + n2 + " (" + n + ")");
        return null;
    }

    public static void convertOutputType(Variable variable, Object object) {
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            variable.setString(stringArray[0]);
        } else if (object instanceof Double[]) {
            Double[] doubleArray = (Double[])object;
            variable.setValue(doubleArray[0]);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Variable[] variableArray = new Variable[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                variableArray[i] = new Variable();
                ExtensionDescriptor.convertOutputType(variableArray[i], objectArray[i]);
            }
            variable.setArray(variableArray);
        }
    }

    public String dispatch(Functions functions) {
        Interpreter interpreter = functions.interp;
        if (this.argTypes.length == 0) {
            interpreter.getParens();
            return this.handler.handleExtension(this.name, null);
        }
        interpreter.getLeftParen();
        Variable[] variableArray = null;
        int n = interpreter.nextToken();
        if (n != 41) {
            variableArray = this.parseArgumentList(functions);
        }
        Object[] objectArray = new Object[this.argTypes.length];
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (i >= variableArray.length) {
                if (ExtensionDescriptor.isOptionalArg(this.argTypes[i])) break;
                interpreter.error("expected argument " + (i + 1) + " of type " + ExtensionDescriptor.getTypeName(this.argTypes[i]));
                return null;
            }
            objectArray[i] = ExtensionDescriptor.convertVariable(interpreter, this.argTypes[i], variableArray[i]);
        }
        String string = this.handler.handleExtension(this.name, objectArray);
        for (int i = 0; i < this.argTypes.length && i < variableArray.length; ++i) {
            if (!ExtensionDescriptor.isOutputArg(this.argTypes[i])) continue;
            ExtensionDescriptor.convertOutputType(variableArray[i], objectArray[i]);
        }
        return string;
    }
}

