/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackConverter;
import ij.process.ImageConverter;
import ij.process.StackConverter;

public class Converter
implements PlugIn {
    public static boolean newWindowCreated;
    private ImagePlus imp;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp != null) {
            if (this.imp.isComposite() && string.equals("RGB Color")) {
                new RGBStackConverter().run("");
            } else if (this.imp.lock()) {
                this.convert(string);
                this.imp.unlock();
            }
        } else {
            IJ.noImage();
        }
    }

    public void convert(String string) {
        int n = this.imp.getType();
        ImageStack imageStack = null;
        if (this.imp.getStackSize() > 1) {
            imageStack = this.imp.getStack();
        }
        String string2 = "Converting to " + string;
        IJ.showStatus(string2 + "...");
        long l = System.currentTimeMillis();
        Roi roi = this.imp.getRoi();
        this.imp.killRoi();
        boolean bl = this.imp.changes;
        this.imp.changes = IJ.getApplet() == null;
        ImageWindow imageWindow = this.imp.getWindow();
        try {
            if (imageStack != null) {
                boolean bl2 = imageStack.isVirtual();
                if (imageStack.isRGB() && string.equals("RGB Color")) {
                    new ImageConverter(this.imp).convertRGBStackToRGB();
                    if (imageWindow != null) {
                        new ImageWindow(this.imp, this.imp.getCanvas());
                    }
                } else if (imageStack.isHSB() && string.equals("RGB Color")) {
                    new ImageConverter(this.imp).convertHSBToRGB();
                    if (imageWindow != null) {
                        new ImageWindow(this.imp, this.imp.getCanvas());
                    }
                } else if (string.equals("8-bit")) {
                    new StackConverter(this.imp).convertToGray8();
                } else if (string.equals("16-bit")) {
                    new StackConverter(this.imp).convertToGray16();
                } else if (string.equals("32-bit")) {
                    new StackConverter(this.imp).convertToGray32();
                } else if (string.equals("RGB Color")) {
                    new StackConverter(this.imp).convertToRGB();
                } else if (string.equals("RGB Stack")) {
                    new StackConverter(this.imp).convertToRGBHyperstack();
                } else if (string.equals("HSB Stack")) {
                    new StackConverter(this.imp).convertToHSBHyperstack();
                } else if (string.equals("8-bit Color")) {
                    int n2 = this.getNumber();
                    if (n2 != 0) {
                        new StackConverter(this.imp).convertToIndexedColor(n2);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                if (bl2) {
                    this.imp.setTitle(this.imp.getTitle());
                }
            } else {
                Undo.setup(2, this.imp);
                ImageConverter imageConverter = new ImageConverter(this.imp);
                if (string.equals("8-bit")) {
                    imageConverter.convertToGray8();
                } else if (string.equals("16-bit")) {
                    imageConverter.convertToGray16();
                } else if (string.equals("32-bit")) {
                    imageConverter.convertToGray32();
                } else if (string.equals("RGB Stack")) {
                    Undo.reset();
                    imageConverter.convertToRGBStack();
                } else if (string.equals("HSB Stack")) {
                    Undo.reset();
                    imageConverter.convertToHSB();
                } else if (string.equals("RGB Color")) {
                    imageConverter.convertToRGB();
                } else if (string.equals("8-bit Color")) {
                    int n3 = this.getNumber();
                    l = System.currentTimeMillis();
                    if (n3 != 0) {
                        imageConverter.convertRGBtoIndexedColor(n3);
                    }
                } else {
                    this.imp.changes = bl;
                    return;
                }
                IJ.showProgress(1.0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.unsupportedConversion(this.imp);
            IJ.showStatus("");
            Undo.reset();
            this.imp.changes = bl;
            Menus.updateMenus();
            Macro.abort();
            return;
        }
        if (roi != null) {
            this.imp.setRoi(roi);
        }
        IJ.showTime(this.imp, l, "");
        this.imp.repaintWindow();
        Menus.updateMenus();
    }

    void unsupportedConversion(ImagePlus imagePlus) {
        IJ.error("Converter", "Supported Conversions:\n \n8-bit -> 16-bit*\n8-bit -> 32-bit*\n8-bit -> RGB Color*\n16-bit -> 8-bit*\n16-bit -> 32-bit*\n16-bit -> RGB Color*\n32-bit -> 8-bit*\n32-bit -> 16-bit\n32-bit -> RGB Color*\n8-bit Color -> 8-bit (grayscale)*\n8-bit Color -> RGB Color\nRGB Color -> 8-bit (grayscale)*\nRGB Color -> 8-bit Color*\nRGB Color -> RGB Stack*\nRGB Color -> HSB Stack*\nRGB Stack -> RGB Color\nHSB Stack -> RGB Color\n \n* works with stacks\n");
    }

    int getNumber() {
        if (this.imp.getType() != 4) {
            return 256;
        }
        GenericDialog genericDialog = new GenericDialog("MedianCut");
        genericDialog.addNumericField("Number of Colors (2-256):", 256.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return 0;
        }
        int n = (int)genericDialog.getNextNumber();
        if (n < 2) {
            n = 2;
        }
        if (n > 256) {
            n = 256;
        }
        return n;
    }
}

