/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Histogram
implements PlugIn,
TextListener {
    private static int nBins = 256;
    private static boolean useImageMinAndMax = true;
    private static double xMin;
    private static double xMax;
    private static String yMax;
    private static boolean stackHistogram;
    private static int imageID;
    private Checkbox checkbox;
    private TextField minField;
    private TextField maxField;
    private String defaultMin;
    private String defaultMax;

    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        int n = imagePlus.getBitDepth();
        if (n == 32 || IJ.altKeyDown()) {
            IJ.setKeyUp(18);
            if (!this.showDialog(imagePlus)) {
                return;
            }
        } else {
            int n2 = this.setupDialog(imagePlus, 0);
            if (n2 == 4096) {
                return;
            }
            stackHistogram = n2 == 32;
            Calibration calibration = imagePlus.getCalibration();
            nBins = 256;
            if (stackHistogram && (n == 8 && !calibration.calibrated() || n == 24)) {
                xMin = 0.0;
                xMax = 256.0;
                useImageMinAndMax = false;
            } else {
                useImageMinAndMax = true;
            }
            yMax = "Auto";
        }
        StackStatistics stackStatistics = null;
        if (useImageMinAndMax) {
            xMin = 0.0;
            xMax = 0.0;
        }
        int n3 = (int)Tools.parseDouble(yMax, 0.0);
        boolean bl = !(n != 8 && n != 24 || xMin == 0.0 && xMax == 0.0 && nBins == 256 && n3 <= 0);
        ImageWindow.centerNextImage();
        if (stackHistogram || bl) {
            ImagePlus imagePlus2 = imagePlus;
            if (bl && !stackHistogram && imagePlus.getStackSize() > 1) {
                imagePlus2 = new ImagePlus("Temp", imagePlus.getProcessor());
            }
            stackStatistics = new StackStatistics(imagePlus2, nBins, xMin, xMax);
            stackStatistics.histYMax = n3;
            new HistogramWindow("Histogram of " + imagePlus.getShortTitle(), imagePlus, stackStatistics);
        } else {
            new HistogramWindow("Histogram of " + imagePlus.getShortTitle(), imagePlus, nBins, xMin, xMax, n3);
        }
    }

    boolean showDialog(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        if (imagePlus.getID() != imageID || d == xMin && d == xMax) {
            useImageMinAndMax = true;
        }
        if (imagePlus.getID() != imageID || useImageMinAndMax) {
            xMin = d;
            xMax = d2;
            Calibration calibration = imagePlus.getCalibration();
            xMin = calibration.getCValue(xMin);
            xMax = calibration.getCValue(xMax);
        }
        this.defaultMin = IJ.d2s(xMin, 2);
        this.defaultMax = IJ.d2s(xMax, 2);
        imageID = imagePlus.getID();
        int n = imagePlus.getStackSize();
        GenericDialog genericDialog = new GenericDialog("Histogram");
        genericDialog.addNumericField("Bins:", HistogramWindow.nBins, 0);
        genericDialog.addCheckbox("Use min/max or:", useImageMinAndMax);
        genericDialog.addMessage("");
        int n2 = 6;
        int n3 = Math.max(IJ.d2s(xMin, 2).length(), IJ.d2s(xMax, 2).length());
        if (n3 > n2) {
            n2 = n3;
        }
        genericDialog.addNumericField("X_Min:", xMin, 2, n2, null);
        genericDialog.addNumericField("X_Max:", xMax, 2, n2, null);
        genericDialog.addMessage(" ");
        genericDialog.addStringField("Y_Max:", yMax, 6);
        if (n > 1) {
            genericDialog.addCheckbox("Stack Histogram", stackHistogram);
        }
        Vector vector = genericDialog.getNumericFields();
        this.minField = (TextField)vector.elementAt(1);
        this.minField.addTextListener(this);
        this.maxField = (TextField)vector.elementAt(2);
        this.maxField.addTextListener(this);
        this.checkbox = (Checkbox)genericDialog.getCheckboxes().elementAt(0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        nBins = (int)genericDialog.getNextNumber();
        if (nBins >= 2 && nBins <= 1000) {
            HistogramWindow.nBins = nBins;
        }
        useImageMinAndMax = genericDialog.getNextBoolean();
        xMin = genericDialog.getNextNumber();
        xMax = genericDialog.getNextNumber();
        yMax = genericDialog.getNextString();
        stackHistogram = n > 1 ? genericDialog.getNextBoolean() : false;
        IJ.register(Histogram.class);
        return true;
    }

    public void textValueChanged(TextEvent textEvent) {
        boolean bl;
        boolean bl2 = bl = !this.defaultMin.equals(this.minField.getText()) || !this.defaultMax.equals(this.maxField.getText());
        if (bl) {
            this.checkbox.setState(false);
        }
    }

    int setupDialog(ImagePlus imagePlus, int n) {
        int n2 = imagePlus.getStackSize();
        if (n2 > 1) {
            String string = Macro.getOptions();
            if (string != null) {
                if (string.indexOf("stack ") >= 0) {
                    return n + 32;
                }
                return n;
            }
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)IJ.getInstance(), "Histogram", "Include all " + n2 + " images?");
            if (yesNoCancelDialog.cancelPressed()) {
                return 4096;
            }
            if (yesNoCancelDialog.yesPressed()) {
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return n + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return n;
    }

    static {
        yMax = "Auto";
    }
}

