/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Resizer
implements PlugIn,
TextListener,
ItemListener {
    public static final int IN_PLACE = 16;
    public static final int SCALE_T = 32;
    private static int newWidth;
    private static int newHeight;
    private static boolean constrain;
    private static boolean averageWhenDownsizing;
    private static int interpolationMethod;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private Vector fields;
    private Vector checkboxes;
    private double origWidth;
    private double origHeight;
    private boolean sizeToHeight;

    public void run(String string) {
        Object object;
        int n;
        int n2;
        boolean bl;
        boolean bl2 = string.equals("crop");
        ImagePlus imagePlus = IJ.getImage();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Roi roi = imagePlus.getRoi();
        if (roi == null && bl2) {
            IJ.error("Crop", "Area selection required");
            return;
        }
        if (roi != null && roi.isLine()) {
            IJ.error("The Crop and Adjust>Size commands\ndo not work with line selections.");
            return;
        }
        Rectangle rectangle = imageProcessor.getRoi();
        this.origWidth = rectangle.width;
        this.origHeight = rectangle.height;
        this.sizeToHeight = false;
        boolean bl3 = bl = bl2 && roi != null && roi.getType() != 0;
        if (roi != null) {
            Rectangle rectangle2 = roi.getBounds();
            n2 = imageProcessor.getWidth();
            n = imageProcessor.getHeight();
            if (rectangle2.x < 0 || rectangle2.y < 0 || rectangle2.x + rectangle2.width > n2 || rectangle2.y + rectangle2.height > n) {
                ShapeRoi shapeRoi = new ShapeRoi(roi);
                ShapeRoi shapeRoi2 = new ShapeRoi(new Roi(0, 0, n2, n));
                roi = shapeRoi2.and(shapeRoi);
                if (bl) {
                    imagePlus.setRoi(roi);
                }
            }
        }
        int n3 = imagePlus.getStackSize();
        n2 = imagePlus.getStackSize();
        n = 0;
        int n4 = 0;
        int n5 = 0;
        if (bl2) {
            object = roi.getBounds();
            newWidth = ((Rectangle)object).width;
            newHeight = ((Rectangle)object).height;
            interpolationMethod = 0;
        } else {
            if (newWidth == 0 || newHeight == 0) {
                newWidth = (int)this.origWidth / 2;
                newHeight = (int)this.origHeight / 2;
            }
            if (constrain) {
                newHeight = (int)((double)newWidth * (this.origHeight / this.origWidth));
            }
            if (n3 > 1) {
                newWidth = (int)this.origWidth;
                newHeight = (int)this.origHeight;
            }
            object = new GenericDialog("Resize", IJ.getInstance());
            ((GenericDialog)object).addNumericField("Width (pixels):", newWidth, 0);
            ((GenericDialog)object).addNumericField("Height (pixels):", newHeight, 0);
            if (imagePlus.isHyperStack()) {
                n2 = imagePlus.getNSlices();
                n = imagePlus.getNFrames();
            }
            if (n2 > 1 && n2 == n3) {
                ((GenericDialog)object).addNumericField("Depth (images):", n2, 0);
            } else if (n2 > 1 && n2 < n3) {
                ((GenericDialog)object).addNumericField("Depth (slices):", n2, 0);
            }
            if (n > 1) {
                ((GenericDialog)object).addNumericField("Time (frames):", n, 0);
            }
            ((GenericDialog)object).addCheckbox("Constrain aspect ratio", constrain);
            ((GenericDialog)object).addCheckbox("Average when downsizing", averageWhenDownsizing);
            ((GenericDialog)object).addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
            this.fields = ((GenericDialog)object).getNumericFields();
            for (int i = 0; i < 2; ++i) {
                ((TextField)this.fields.elementAt(i)).addTextListener(this);
            }
            this.checkboxes = ((GenericDialog)object).getCheckboxes();
            ((Checkbox)this.checkboxes.elementAt(0)).addItemListener(this);
            ((GenericDialog)object).showDialog();
            if (((GenericDialog)object).wasCanceled()) {
                return;
            }
            newWidth = (int)((GenericDialog)object).getNextNumber();
            newHeight = (int)((GenericDialog)object).getNextNumber();
            if (n2 > 1) {
                n4 = (int)((GenericDialog)object).getNextNumber();
            }
            if (n > 1) {
                n5 = (int)((GenericDialog)object).getNextNumber();
            }
            if (((GenericDialog)object).invalidNumber()) {
                IJ.error("Width or height are invalid.");
                return;
            }
            constrain = ((GenericDialog)object).getNextBoolean();
            averageWhenDownsizing = ((GenericDialog)object).getNextBoolean();
            interpolationMethod = ((GenericDialog)object).getNextChoiceIndex();
            if (constrain && newWidth == 0) {
                this.sizeToHeight = true;
            }
            if ((double)newWidth <= 0.0 && !constrain) {
                newWidth = 50;
            }
            if ((double)newHeight <= 0.0) {
                newHeight = 50;
            }
        }
        if (!bl2 && constrain) {
            if (this.sizeToHeight) {
                newWidth = (int)Math.round((double)newHeight * (this.origWidth / this.origHeight));
            } else {
                newHeight = (int)Math.round((double)newWidth * (this.origHeight / this.origWidth));
            }
        }
        if (imageProcessor.getWidth() == 1 || imageProcessor.getHeight() == 1) {
            imageProcessor.setInterpolationMethod(0);
        } else {
            imageProcessor.setInterpolationMethod(interpolationMethod);
        }
        if (!bl2 && n3 == 1) {
            Undo.setup(2, imagePlus);
        }
        if (roi != null || (double)newWidth != this.origWidth || (double)newHeight != this.origHeight) {
            try {
                object = new StackProcessor(imagePlus.getStack(), imageProcessor);
                ImageStack imageStack = ((StackProcessor)object).resize(newWidth, newHeight, averageWhenDownsizing);
                int n6 = imageStack.getSize();
                if (imageStack.getWidth() > 0 && n6 > 0) {
                    Calibration calibration;
                    if (bl) {
                        imagePlus.killRoi();
                    }
                    if ((calibration = imagePlus.getCalibration()).scaled()) {
                        calibration.pixelWidth *= this.origWidth / (double)newWidth;
                        calibration.pixelHeight *= this.origHeight / (double)newHeight;
                        imagePlus.setCalibration(calibration);
                    }
                    imagePlus.setStack(null, imageStack);
                    if (bl && roi != null) {
                        roi.setLocation(0, 0);
                        imagePlus.setRoi(roi);
                        imagePlus.draw();
                    }
                }
                if (n3 > 1 && n6 < n3) {
                    IJ.error("ImageJ ran out of memory causing \nthe last " + (n3 - n6) + " slices to be lost.");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IJ.outOfMemory("Resize");
            }
            imagePlus.changes = true;
        }
        object = null;
        if (n4 > 0 && n4 != n2) {
            object = this.zScale(imagePlus, n4, interpolationMethod + 16);
        }
        if (n5 > 0 && n5 != n) {
            object = this.zScale((ImagePlus)(object != null ? object : imagePlus), n5, interpolationMethod + 16 + 32);
        }
        if (object != null && object != imagePlus) {
            ((ImagePlus)object).show();
            imagePlus.changes = false;
            imagePlus.close();
        }
    }

    public ImagePlus zScale(ImagePlus imagePlus, int n, int n2) {
        Object object;
        ImagePlus imagePlus2 = null;
        if (imagePlus.isHyperStack()) {
            imagePlus2 = this.zScaleHyperstack(imagePlus, n, n2);
        } else {
            boolean bl = (n2 & 0x10) != 0;
            int n3 = imagePlus.getStackSize();
            int n4 = imagePlus.getBitDepth();
            imagePlus2 = n <= n3 / 2 && n2 == 0 ? this.shrinkZ(imagePlus, n, bl) : this.resizeZ(imagePlus, n, n2 &= 0xF);
            if (imagePlus2 == null) {
                return null;
            }
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            double d = imageProcessor.getMin();
            double d2 = imageProcessor.getMax();
            if (n4 == 16 || n4 == 32) {
                imagePlus2.getProcessor().setMinAndMax(d, d2);
            }
        }
        if (imagePlus2 == null) {
            return null;
        }
        if (imagePlus2 != imagePlus && imagePlus.isComposite()) {
            imagePlus2 = new CompositeImage(imagePlus2, ((CompositeImage)imagePlus).getMode());
            ((CompositeImage)imagePlus2).copyLuts(imagePlus);
        }
        imagePlus2.setCalibration(imagePlus.getCalibration());
        Calibration calibration = imagePlus2.getCalibration();
        if (calibration.scaled()) {
            calibration.pixelDepth *= (double)imagePlus.getNSlices() / (double)imagePlus2.getNSlices();
        }
        if ((object = imagePlus.getProperty("Info")) != null) {
            imagePlus2.setProperty("Info", object);
        }
        if (imagePlus.isHyperStack()) {
            imagePlus2.setOpenAsHyperStack(imagePlus.isHyperStack());
        }
        return imagePlus2;
    }

    private ImagePlus zScaleHyperstack(ImagePlus imagePlus, int n, int n2) {
        boolean bl = (n2 & 0x10) != 0;
        boolean bl2 = (n2 & 0x20) != 0;
        n2 &= 0xF;
        int n3 = imagePlus.getNChannels();
        int n4 = imagePlus.getNSlices();
        int n5 = imagePlus.getNFrames();
        int n6 = n4;
        int n7 = n5;
        int n8 = imagePlus.getBitDepth();
        if (n4 == 1 && n5 > 1) {
            bl2 = true;
        }
        if (bl2) {
            n7 = n;
        } else {
            n6 = n;
        }
        double d = (double)(n - 1) / (double)n4;
        if (bl2) {
            d = (double)(n - 1) / (double)n5;
        }
        if (d <= 0.5 && n2 == 0) {
            return this.shrinkHyperstack(imagePlus, n, bl, bl2);
        }
        ImageStack imageStack = imagePlus.getStack();
        int n9 = imageStack.getWidth();
        int n10 = imageStack.getHeight();
        ImagePlus imagePlus2 = IJ.createImage(imagePlus.getTitle(), n8 + "-bit", n9, n10, n3 * n6 * n7);
        if (imagePlus2 == null) {
            return null;
        }
        imagePlus2.setDimensions(n3, n6, n7);
        ImageStack imageStack2 = imagePlus2.getStack();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n11 = 0;
        if (bl2) {
            IJ.showStatus("T Scaling...");
            ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n9, n5);
            imageProcessor2.setInterpolationMethod(n2);
            Object object = imageProcessor2.getPixels();
            int n12 = n4 * n3 * n10 - 1;
            for (int i = 1; i <= n4; ++i) {
                for (int j = 1; j <= n3; ++j) {
                    for (int k = 0; k < n10; ++k) {
                        int n13;
                        IJ.showProgress(n11++, n12);
                        for (int i2 = 1; i2 <= n5; ++i2) {
                            n13 = imagePlus.getStackIndex(j, i, i2);
                            Object object2 = imageStack.getPixels(n13);
                            System.arraycopy(object2, k * n9, object, (i2 - 1) * n9, n9);
                        }
                        ImageProcessor imageProcessor3 = imageProcessor2.resize(n9, n, averageWhenDownsizing);
                        Object object3 = imageProcessor3.getPixels();
                        for (n13 = 1; n13 <= n7; ++n13) {
                            int n14 = imagePlus2.getStackIndex(j, i, n13);
                            Object object4 = imageStack2.getPixels(n14);
                            System.arraycopy(object3, (n13 - 1) * n9, object4, k * n9, n9);
                        }
                    }
                }
            }
        } else {
            IJ.showStatus("Z Scaling...");
            ImageProcessor imageProcessor4 = imageProcessor.createProcessor(n9, n4);
            imageProcessor4.setInterpolationMethod(n2);
            Object object = imageProcessor4.getPixels();
            int n15 = n5 * n3 * n10 - 1;
            for (int i = 1; i <= n5; ++i) {
                for (int j = 1; j <= n3; ++j) {
                    for (int k = 0; k < n10; ++k) {
                        int n16;
                        IJ.showProgress(n11++, n15);
                        for (int i3 = 1; i3 <= n4; ++i3) {
                            n16 = imagePlus.getStackIndex(j, i3, i);
                            Object object5 = imageStack.getPixels(n16);
                            System.arraycopy(object5, k * n9, object, (i3 - 1) * n9, n9);
                        }
                        ImageProcessor imageProcessor5 = imageProcessor4.resize(n9, n, averageWhenDownsizing);
                        Object object6 = imageProcessor5.getPixels();
                        for (n16 = 1; n16 <= n6; ++n16) {
                            int n17 = imagePlus2.getStackIndex(j, n16, i);
                            Object object7 = imageStack2.getPixels(n17);
                            System.arraycopy(object6, (n16 - 1) * n9, object7, k * n9, n9);
                        }
                    }
                }
            }
        }
        imagePlus2.setDimensions(n3, n6, n7);
        return imagePlus2;
    }

    private ImagePlus shrinkHyperstack(ImagePlus imagePlus, int n, boolean bl, boolean bl2) {
        int n2 = imagePlus.getNChannels();
        int n3 = imagePlus.getNSlices();
        int n4 = imagePlus.getNFrames();
        int n5 = (int)Math.round((double)n3 / (double)n);
        if (bl2) {
            n5 = n4 / n;
        }
        int n6 = bl2 ? 1 : n5;
        int n7 = bl2 ? n5 : 1;
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(imagePlus.getWidth(), imagePlus.getHeight());
        boolean bl3 = imageStack.isVirtual();
        int n8 = n3 / n6 + (n3 % n6 != 0 ? 1 : 0);
        int n9 = n4 / n7 + (n4 % n7 != 0 ? 1 : 0);
        int n10 = n2 * n8 * n9;
        boolean bl4 = true;
        for (int i = 1; i <= n4; i += n7) {
            for (int j = 1; j <= n3; j += n6) {
                for (int k = 1; k <= n2; ++k) {
                    int n11 = imagePlus.getStackIndex(k, j, i);
                    IJ.showProgress(n11, n10);
                    ImageProcessor imageProcessor = imageStack.getProcessor(imagePlus.getStackIndex(k, j, i));
                    if (!bl) {
                        imageProcessor = imageProcessor.duplicate();
                    }
                    imageStack2.addSlice(imageStack.getSliceLabel(n11), imageProcessor);
                }
            }
        }
        ImagePlus imagePlus2 = new ImagePlus(imagePlus.getTitle(), imageStack2);
        imagePlus2.setDimensions(n2, n8, n9);
        IJ.showProgress(1.0);
        return imagePlus2;
    }

    private ImagePlus shrinkZ(ImagePlus imagePlus, int n, boolean bl) {
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imagePlus.getStackSize() / n;
        boolean bl2 = imageStack.isVirtual();
        int n3 = imageStack.getSize();
        ImageStack imageStack2 = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        for (int i = 1; i <= n3; i += n2) {
            if (bl2) {
                IJ.showProgress(i, n3);
            }
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            if (!bl) {
                imageProcessor = imageProcessor.duplicate();
            }
            imageStack2.addSlice(imageStack.getSliceLabel(i), imageProcessor);
        }
        return new ImagePlus(imagePlus.getTitle(), imageStack2);
    }

    private ImagePlus resizeZ(ImagePlus imagePlus, int n, int n2) {
        ImageStack imageStack = imagePlus.getStack();
        int n3 = imageStack.getWidth();
        int n4 = imageStack.getHeight();
        int n5 = imageStack.getSize();
        int n6 = imagePlus.getBitDepth();
        ImagePlus imagePlus2 = IJ.createImage(imagePlus.getTitle(), n6 + "-bit", n3, n4, n);
        if (imagePlus2 == null) {
            return null;
        }
        ImageStack imageStack2 = imagePlus2.getStack();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n3, n5);
        imageProcessor2.setInterpolationMethod(n2);
        Object object = imageProcessor2.getPixels();
        IJ.showStatus("Z Scaling...");
        for (int i = 0; i < n4; ++i) {
            IJ.showProgress(i, n4 - 1);
            for (int j = 0; j < n5; ++j) {
                Object object2 = imageStack.getPixels(j + 1);
                System.arraycopy(object2, i * n3, object, j * n3, n3);
            }
            ImageProcessor imageProcessor3 = imageProcessor2.resize(n3, n, averageWhenDownsizing);
            Object object3 = imageProcessor3.getPixels();
            for (int j = 0; j < n; ++j) {
                Object object4 = imageStack2.getPixels(j + 1);
                System.arraycopy(object3, j * n3, object4, i * n3, n3);
            }
        }
        return imagePlus2;
    }

    public void textValueChanged(TextEvent textEvent) {
        TextField textField = (TextField)this.fields.elementAt(0);
        TextField textField2 = (TextField)this.fields.elementAt(1);
        int n = (int)Tools.parseDouble(textField.getText(), -99.0);
        int n2 = (int)Tools.parseDouble(textField2.getText(), -99.0);
        if (n == -99 || n2 == -99) {
            return;
        }
        if (constrain) {
            if (n != newWidth) {
                this.sizeToHeight = false;
                newWidth = n;
                this.updateFields();
            } else if (n2 != newHeight) {
                this.sizeToHeight = true;
                newHeight = n2;
                this.updateFields();
            }
        }
    }

    void updateFields() {
        if (this.sizeToHeight) {
            newWidth = (int)((double)newHeight * (this.origWidth / this.origHeight));
            TextField textField = (TextField)this.fields.elementAt(0);
            textField.setText("" + newWidth);
        } else {
            newHeight = (int)((double)newWidth * (this.origHeight / this.origWidth));
            TextField textField = (TextField)this.fields.elementAt(1);
            textField.setText("" + newHeight);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Checkbox checkbox = (Checkbox)this.checkboxes.elementAt(0);
        boolean bl = checkbox.getState();
        if (bl && bl != constrain) {
            this.updateFields();
        }
        constrain = bl;
    }

    static {
        constrain = true;
        averageWhenDownsizing = true;
        interpolationMethod = 1;
    }
}

