/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class ScaleBar
implements PlugIn {
    static final String[] locations = new String[]{"Upper Right", "Lower Right", "Lower Left", "Upper Left", "At Selection"};
    static final int UPPER_RIGHT = 0;
    static final int LOWER_RIGHT = 1;
    static final int LOWER_LEFT = 2;
    static final int UPPER_LEFT = 3;
    static final int AT_SELECTION = 4;
    static final String[] colors = new String[]{"White", "Black", "Light Gray", "Gray", "Dark Gray", "Red", "Green", "Blue", "Yellow"};
    static final String[] bcolors = new String[]{"None", "Black", "White", "Dark Gray", "Gray", "Light Gray", "Yellow", "Blue", "Green", "Red"};
    static final String[] checkboxLabels = new String[]{"Bold Text", "Hide Text", "Serif Font"};
    static double barWidth;
    static int defaultBarHeight;
    static int barHeightInPixels;
    static String location;
    static String color;
    static String bcolor;
    static boolean boldText;
    static boolean hideText;
    static int defaultFontSize;
    static int fontSize;
    static boolean labelAll;
    ImagePlus imp;
    double imageWidth;
    double mag;
    int xloc;
    int yloc;
    int barWidthInPixels;
    int roiX = -1;
    int roiY;
    int roiWidth;
    int roiHeight;
    boolean serifFont;
    boolean[] checkboxStates = new boolean[3];

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp != null) {
            if (this.showDialog(this.imp) && this.imp.getStackSize() > 1 && labelAll) {
                this.labelSlices(this.imp);
            }
        } else {
            IJ.noImage();
        }
    }

    void labelSlices(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        String string = this.getUnits(imagePlus);
        for (int i = 1; i <= imageStack.getSize(); ++i) {
            this.drawScaleBar(imageStack.getProcessor(i), string);
        }
        imagePlus.setStack(imageStack);
    }

    boolean showDialog(ImagePlus imagePlus) {
        int n;
        double d;
        String string;
        Cloneable cloneable;
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            cloneable = roi.getBounds();
            this.roiX = ((Rectangle)cloneable).x;
            this.roiY = ((Rectangle)cloneable).y;
            this.roiWidth = ((Rectangle)cloneable).width;
            this.roiHeight = ((Rectangle)cloneable).height;
            location = locations[4];
        } else if (location.equals(locations[4])) {
            location = locations[0];
        }
        cloneable = imagePlus.getCalibration();
        ImageWindow imageWindow = imagePlus.getWindow();
        double d2 = this.mag = imageWindow != null ? imageWindow.getCanvas().getMagnification() : 1.0;
        if (this.mag > 1.0) {
            this.mag = 1.0;
        }
        if ((double)fontSize < (double)defaultFontSize / this.mag) {
            fontSize = (int)((double)defaultFontSize / this.mag);
        }
        if ((string = ((Calibration)cloneable).getUnits()).equals("micron")) {
            string = "\u00b5m";
        }
        if ((d = ((Calibration)cloneable).pixelWidth) == 0.0) {
            d = 1.0;
        }
        double d3 = 1.0 / d;
        this.imageWidth = (double)imagePlus.getWidth() * d;
        if (this.roiX > 0 && this.roiWidth > 10) {
            barWidth = (double)this.roiWidth * d;
        } else if (barWidth == 0.0 || barWidth > 0.67 * this.imageWidth) {
            barWidth = 80.0 * d / this.mag;
            if (barWidth > 0.67 * this.imageWidth) {
                barWidth = 0.67 * this.imageWidth;
            }
            if (barWidth > 5.0) {
                barWidth = (int)barWidth;
            }
        }
        int n2 = imagePlus.getStackSize();
        int n3 = n = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            n = 2;
        }
        int n4 = (int)(barWidth * 100.0 / this.imageWidth);
        if (this.mag < 1.0 && (double)barHeightInPixels < (double)defaultBarHeight / this.mag) {
            barHeightInPixels = (int)((double)defaultBarHeight / this.mag);
        }
        imagePlus.getProcessor().snapshot();
        if (!IJ.macroRunning()) {
            this.updateScalebar();
        }
        BarDialog barDialog = new BarDialog("ScaleBar Plus");
        barDialog.addNumericField("Width in " + string + ": ", barWidth, n);
        barDialog.addNumericField("Height in pixels: ", barHeightInPixels, 0);
        barDialog.addNumericField("Font Size: ", fontSize, 0);
        barDialog.addChoice("Color: ", colors, color);
        barDialog.addChoice("Background: ", bcolors, bcolor);
        barDialog.addChoice("Location: ", locations, location);
        this.checkboxStates[0] = boldText;
        this.checkboxStates[1] = hideText;
        this.checkboxStates[2] = this.serifFont;
        barDialog.addCheckboxGroup(2, 2, checkboxLabels, this.checkboxStates);
        if (n2 > 1) {
            barDialog.addCheckbox("Label all Slices", labelAll);
        }
        barDialog.showDialog();
        if (barDialog.wasCanceled()) {
            imagePlus.getProcessor().reset();
            imagePlus.updateAndDraw();
            return false;
        }
        barWidth = barDialog.getNextNumber();
        barHeightInPixels = (int)barDialog.getNextNumber();
        fontSize = (int)barDialog.getNextNumber();
        color = barDialog.getNextChoice();
        bcolor = barDialog.getNextChoice();
        location = barDialog.getNextChoice();
        boldText = barDialog.getNextBoolean();
        hideText = barDialog.getNextBoolean();
        this.serifFont = barDialog.getNextBoolean();
        if (n2 > 1) {
            labelAll = barDialog.getNextBoolean();
        }
        if (IJ.macroRunning()) {
            this.updateScalebar();
        }
        return true;
    }

    void drawScaleBar(ImagePlus imagePlus) {
        if (!this.updateLocation()) {
            return;
        }
        Undo.setup(1, imagePlus);
        this.drawScaleBar(imagePlus.getProcessor(), this.getUnits(imagePlus));
        imagePlus.updateAndDraw();
    }

    String getUnits(ImagePlus imagePlus) {
        String string = imagePlus.getCalibration().getUnits();
        if (string.equals("microns")) {
            string = "\u00b5m";
        }
        return string;
    }

    void drawScaleBar(ImageProcessor imageProcessor, String string) {
        int n;
        Color color = this.getColor();
        Color color2 = this.getBColor();
        int n2 = this.xloc;
        int n3 = this.yloc;
        int n4 = boldText ? 1 : 0;
        String string2 = this.serifFont ? "Serif" : "SanSerif";
        imageProcessor.setFont(new Font(string2, n4, fontSize));
        imageProcessor.setAntialiasedText(true);
        int n5 = n = (double)((int)barWidth) == barWidth ? 0 : 1;
        if (barWidth < 1.0) {
            n = 1;
        }
        String string3 = IJ.d2s(barWidth, n) + " " + string;
        int n6 = hideText ? 0 : imageProcessor.getStringWidth(string3);
        int n7 = (this.barWidthInPixels - n6) / 2;
        int n8 = barHeightInPixels + (hideText ? 0 : fontSize + fontSize / (this.serifFont ? 8 : 4));
        if (color2 != null) {
            int n9;
            int n10;
            int n11 = this.barWidthInPixels;
            int n12 = n8;
            if (n11 < n6) {
                n11 = n6;
            }
            if (n2 + n7 < (n10 = n2)) {
                n10 = n2 + n7;
            }
            if ((n9 = n11 / 20) < 2) {
                n9 = 2;
            }
            int n13 = n3 - n9;
            imageProcessor.setColor(color2);
            imageProcessor.setRoi(n10 -= n9, n13, n11 += n9 * 2, n12 += n9 * 2);
            imageProcessor.fill();
        }
        imageProcessor.resetRoi();
        imageProcessor.setColor(color);
        imageProcessor.setRoi(n2, n3, this.barWidthInPixels, barHeightInPixels);
        imageProcessor.fill();
        imageProcessor.resetRoi();
        if (!hideText) {
            imageProcessor.drawString(string3, n2 + n7, n3 + n8);
        }
    }

    boolean updateLocation() {
        Calibration calibration = this.imp.getCalibration();
        this.barWidthInPixels = (int)(barWidth / calibration.pixelWidth);
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        int n3 = 20;
        int n4 = n - n / n3 - this.barWidthInPixels;
        int n5 = 0;
        if (location.equals(locations[0])) {
            n5 = n2 / n3;
        } else if (location.equals(locations[1])) {
            n5 = n2 - n2 / n3 - barHeightInPixels - fontSize;
        } else if (location.equals(locations[3])) {
            n4 = n / n3;
            n5 = n2 / n3;
        } else if (location.equals(locations[2])) {
            n4 = n / n3;
            n5 = n2 - n2 / n3 - barHeightInPixels - fontSize;
        } else {
            if (this.roiX == -1) {
                return false;
            }
            n4 = this.roiX;
            n5 = this.roiY;
        }
        this.xloc = n4;
        this.yloc = n5;
        return true;
    }

    Color getColor() {
        Color color = Color.black;
        if (ScaleBar.color.equals(colors[0])) {
            color = Color.white;
        } else if (ScaleBar.color.equals(colors[2])) {
            color = Color.lightGray;
        } else if (ScaleBar.color.equals(colors[3])) {
            color = Color.gray;
        } else if (ScaleBar.color.equals(colors[4])) {
            color = Color.darkGray;
        } else if (ScaleBar.color.equals(colors[5])) {
            color = Color.red;
        } else if (ScaleBar.color.equals(colors[6])) {
            color = Color.green;
        } else if (ScaleBar.color.equals(colors[7])) {
            color = Color.blue;
        } else if (ScaleBar.color.equals(colors[8])) {
            color = Color.yellow;
        }
        return color;
    }

    Color getBColor() {
        if (bcolor == null || bcolor.equals(bcolors[0])) {
            return null;
        }
        Color color = Color.white;
        if (bcolor.equals(bcolors[1])) {
            color = Color.black;
        } else if (bcolor.equals(bcolors[3])) {
            color = Color.darkGray;
        } else if (bcolor.equals(bcolors[4])) {
            color = Color.gray;
        } else if (bcolor.equals(bcolors[5])) {
            color = Color.lightGray;
        } else if (bcolor.equals(bcolors[6])) {
            color = Color.yellow;
        } else if (bcolor.equals(bcolors[7])) {
            color = Color.blue;
        } else if (bcolor.equals(bcolors[8])) {
            color = Color.green;
        } else if (bcolor.equals(bcolors[9])) {
            color = Color.red;
        }
        return color;
    }

    void updateScalebar() {
        this.updateLocation();
        this.imp.getProcessor().reset();
        this.drawScaleBar(this.imp);
    }

    static {
        barHeightInPixels = defaultBarHeight = 4;
        location = locations[1];
        color = colors[0];
        bcolor = bcolors[0];
        boldText = true;
        defaultFontSize = 14;
    }

    class BarDialog
    extends GenericDialog {
        BarDialog(String string) {
            super(string);
        }

        public void textValueChanged(TextEvent textEvent) {
            TextField textField = (TextField)this.numberField.elementAt(0);
            Double d = this.getValue(textField.getText());
            if (d == null) {
                return;
            }
            barWidth = d;
            TextField textField2 = (TextField)this.numberField.elementAt(1);
            d = this.getValue(textField2.getText());
            if (d == null) {
                return;
            }
            barHeightInPixels = (int)d.doubleValue();
            TextField textField3 = (TextField)this.numberField.elementAt(2);
            d = this.getValue(textField3.getText());
            if (d == null) {
                return;
            }
            int n = (int)d.doubleValue();
            if (n > 5) {
                fontSize = n;
            }
            ScaleBar.this.updateScalebar();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Choice choice = (Choice)this.choice.elementAt(0);
            color = choice.getSelectedItem();
            Choice choice2 = (Choice)this.choice.elementAt(1);
            bcolor = choice2.getSelectedItem();
            Choice choice3 = (Choice)this.choice.elementAt(2);
            location = choice3.getSelectedItem();
            boldText = ((Checkbox)this.checkbox.elementAt(0)).getState();
            hideText = ((Checkbox)this.checkbox.elementAt(1)).getState();
            ScaleBar.this.serifFont = ((Checkbox)this.checkbox.elementAt(2)).getState();
            ScaleBar.this.updateScalebar();
        }
    }
}

