/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class URLOpener
implements PlugIn {
    private static String url = "http://imagej.nih.gov/ij/images/clown.gif";

    public void run(String string) {
        if (!string.equals("")) {
            if (string.endsWith("StartupMacros.txt")) {
                this.openTextFile(string, true);
            } else {
                String string2 = string.indexOf("://") > 0 ? string : Prefs.getImagesURL() + string;
                ImagePlus imagePlus = new ImagePlus(string2);
                if (Recorder.record) {
                    Recorder.recordCall("imp = IJ.openImage(\"" + string2 + "\");");
                }
                if (imagePlus.getType() == 4) {
                    Opener.convertGrayJpegTo8Bits(imagePlus);
                }
                WindowManager.checkForDuplicateName = true;
                FileInfo fileInfo = imagePlus.getOriginalFileInfo();
                if (fileInfo != null && fileInfo.fileType == 12) {
                    imagePlus = new CompositeImage(imagePlus, 1);
                } else if (imagePlus.getNChannels() > 1 && fileInfo != null && fileInfo.description != null && fileInfo.description.indexOf("mode=") != -1) {
                    int n = 2;
                    if (fileInfo.description.indexOf("mode=composite") != -1) {
                        n = 1;
                    } else if (fileInfo.description.indexOf("mode=gray") != -1) {
                        n = 3;
                    }
                    imagePlus = new CompositeImage(imagePlus, n);
                }
                if (fileInfo != null && (fileInfo.url == null || fileInfo.url.length() == 0)) {
                    fileInfo.url = string2;
                    imagePlus.setFileInfo(fileInfo);
                }
                imagePlus.show();
            }
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Enter a URL");
        genericDialog.addMessage("Enter URL of an image, macro or web page");
        genericDialog.addStringField("URL:", url, 45);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        url = genericDialog.getNextString();
        if ((url = url.trim()).indexOf("://") == -1) {
            url = "http://" + url;
        }
        if (url.endsWith("/")) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url.substring(0, url.length() - 1));
        } else if (url.endsWith(".html") || url.endsWith(".htm") || url.indexOf(".html#") > 0 || this.noExtension(url)) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url);
        } else if (url.endsWith(".txt") || url.endsWith(".ijm") || url.endsWith(".js") || url.endsWith(".java")) {
            this.openTextFile(url, false);
        } else if (url.endsWith(".jar") || url.endsWith(".class")) {
            IJ.open(url);
        } else {
            IJ.showStatus("Opening: " + url);
            ImagePlus imagePlus = new ImagePlus(url);
            WindowManager.checkForDuplicateName = true;
            FileInfo fileInfo = imagePlus.getOriginalFileInfo();
            if (fileInfo != null && fileInfo.fileType == 12) {
                imagePlus = new CompositeImage(imagePlus, 1);
            }
            imagePlus.show();
            IJ.showStatus("");
        }
        IJ.register(URLOpener.class);
    }

    boolean noExtension(String string) {
        int n;
        int n2 = string.lastIndexOf("/");
        if (n2 == -1) {
            n2 = 0;
        }
        return (n = string.lastIndexOf(".")) == -1 || n < n2 || string.length() - n > 6;
    }

    void openTextFile(String string, boolean bl) {
        StringBuffer stringBuffer = null;
        try {
            String string2;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            if (!bl || !string.endsWith("StartupMacros.txt")) {
                IJ.error("URL Opener", "" + iOException);
            }
            stringBuffer = null;
        }
        if (stringBuffer != null) {
            if (bl) {
                new MacroInstaller().install(new String(stringBuffer));
            } else {
                int n = string.lastIndexOf("/");
                if (n != -1 && n <= string.length() - 1) {
                    string = string.substring(n + 1);
                }
                new Editor().create(string, new String(stringBuffer));
            }
        }
    }
}

