/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.plugin.Animator;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;

public class AVI_Writer
implements PlugInFilter {
    public static final int NO_COMPRESSION = 0;
    public static final int JPEG_COMPRESSION = 1196444237;
    public static final int PNG_COMPRESSION = 543649392;
    private static final int FOURCC_00db = 1650733104;
    private static final int FOURCC_00dc = 1667510320;
    private static int compressionIndex = 2;
    private static int jpegQuality = 90;
    private static final String[] COMPRESSION_STRINGS = new String[]{"Uncompressed", "PNG", "JPEG"};
    private static final int[] COMPRESSION_TYPES = new int[]{0, 543649392, 1196444237};
    private ImagePlus imp;
    private RandomAccessFile raFile;
    private int xDim;
    private int yDim;
    private int zDim;
    private int bytesPerPixel;
    private int frameDataSize;
    private int biCompression;
    private int linePad;
    private byte[] bufferWrite;
    private BufferedImage bufferedImage;
    private RaOutputStream raOutputStream;
    private long[] sizePointers = new long[5];
    private int stackPointer;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        if (!this.showDialog(this.imp)) {
            return;
        }
        SaveDialog saveDialog = new SaveDialog("Save as AVI...", this.imp.getTitle(), ".avi");
        String string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        FileInfo fileInfo = this.imp.getOriginalFileInfo();
        if (this.imp.getStack().isVirtual() && string2.equals(fileInfo.directory) && string.equals(fileInfo.fileName)) {
            IJ.error("AVI Writer", "Virtual stacks cannot be saved in place.");
            return;
        }
        try {
            this.writeImage(this.imp, string2 + string, COMPRESSION_TYPES[compressionIndex], jpegQuality);
            IJ.showStatus("");
        }
        catch (IOException iOException) {
            IJ.error("AVI Writer", "An error occured writing the file.\n \n" + iOException);
        }
        IJ.showStatus("");
    }

    private boolean showDialog(ImagePlus imagePlus) {
        double d;
        String string = Macro.getOptions();
        if (string != null && string.indexOf("compression=") == -1) {
            Macro.setOptions("compression=Uncompressed " + string);
        }
        int n = (double)((int)(d = this.getFrameRate(imagePlus))) == d ? 0 : 1;
        GenericDialog genericDialog = new GenericDialog("Save as AVI...");
        genericDialog.addChoice("Compression:", COMPRESSION_STRINGS, COMPRESSION_STRINGS[compressionIndex]);
        genericDialog.addNumericField("Frame Rate:", d, n, 3, "fps");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        compressionIndex = genericDialog.getNextChoiceIndex();
        d = genericDialog.getNextNumber();
        if (d <= 0.5) {
            d = 0.5;
        }
        imagePlus.getCalibration().fps = d;
        return true;
    }

    public void writeImage(ImagePlus imagePlus, String string, int n, int n2) throws IOException {
        int n3;
        if (n != 0 && n != 1196444237 && n != 543649392) {
            throw new IllegalArgumentException("Unsupported Compression 0x" + Integer.toHexString(n));
        }
        this.biCompression = n;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        jpegQuality = n2;
        File file = new File(string);
        this.raFile = new RandomAccessFile(file, "rw");
        this.raFile.setLength(0L);
        imagePlus.startTiming();
        boolean bl = imagePlus.isComposite();
        boolean bl2 = imagePlus.isHyperStack();
        boolean bl3 = imagePlus.getOverlay() != null && !imagePlus.getHideOverlay();
        this.xDim = imagePlus.getWidth();
        this.yDim = imagePlus.getHeight();
        this.zDim = imagePlus.getStackSize();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n4 = imagePlus.getNChannels();
        int n5 = imagePlus.getNSlices();
        int n6 = imagePlus.getNFrames();
        int n7 = imagePlus.getChannel();
        int n8 = imagePlus.getSlice();
        int n9 = imagePlus.getFrame();
        if (bl2 || bl) {
            if (n6 > 1) {
                bl4 = true;
                this.zDim = n6;
            } else if (n5 > 1) {
                bl5 = true;
                this.zDim = n5;
            } else if (n4 > 1) {
                bl6 = true;
                this.zDim = n4;
            } else {
                bl2 = false;
            }
        }
        this.bytesPerPixel = imagePlus.getType() == 4 || bl || this.biCompression == 1196444237 || bl3 ? 3 : 1;
        boolean bl7 = this.bytesPerPixel == 1;
        this.linePad = 0;
        int n10 = this.bytesPerPixel * this.xDim;
        if (this.biCompression == 0 && n10 % 4 != 0) {
            this.linePad = 4 - n10 % 4;
        }
        this.frameDataSize = (this.bytesPerPixel * this.xDim + this.linePad) * this.yDim;
        int n11 = (int)Math.round(1.0 / this.getFrameRate(imagePlus) * 1000000.0);
        this.writeString("RIFF");
        this.chunkSizeHere();
        this.writeString("AVI ");
        this.writeString("LIST");
        this.chunkSizeHere();
        this.writeString("hdrl");
        this.writeString("avih");
        this.writeInt(56);
        this.writeInt(n11);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        this.writeInt(this.zDim);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeString("LIST");
        this.chunkSizeHere();
        this.writeString("strl");
        this.writeString("strh");
        this.writeInt(56);
        this.writeString("vids");
        this.writeString("DIB ");
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt((int)Math.round(this.getFrameRate(imagePlus)));
        this.writeInt(0);
        this.writeInt(this.zDim);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeString("strf");
        this.chunkSizeHere();
        this.writeInt(40);
        this.writeInt(this.xDim);
        this.writeInt(this.yDim);
        this.writeShort(1);
        this.writeShort((short)(8 * this.bytesPerPixel));
        this.writeInt(this.biCompression);
        int n12 = this.biCompression == 0 ? 0 : this.xDim * this.yDim * this.bytesPerPixel;
        this.writeInt(n12);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(bl7 ? 256 : 0);
        this.writeInt(0);
        if (bl7) {
            this.writeLUT(imagePlus.getProcessor());
        }
        this.chunkEndWriteSize();
        this.writeString("strn");
        this.writeInt(16);
        this.writeString("ImageJ AVI     \u0000");
        this.chunkEndWriteSize();
        this.chunkEndWriteSize();
        this.writeString("JUNK");
        this.chunkSizeHere();
        this.raFile.seek(4096L);
        this.chunkEndWriteSize();
        this.writeString("LIST");
        this.chunkSizeHere();
        long l = this.raFile.getFilePointer();
        this.writeString("movi");
        if (this.biCompression == 0) {
            this.bufferWrite = new byte[this.frameDataSize];
        } else {
            this.raOutputStream = new RaOutputStream(this.raFile);
        }
        int n13 = this.biCompression == 0 ? 1650733104 : 1667510320;
        int n14 = 0;
        int[] nArray = new int[this.zDim];
        int[] nArray2 = new int[this.zDim];
        for (n3 = 0; n3 < this.zDim; ++n3) {
            IJ.showProgress(n3, this.zDim);
            IJ.showStatus(n3 + "/" + this.zDim);
            ImageProcessor imageProcessor = null;
            if (bl || bl2 || bl3) {
                if (bl4) {
                    imagePlus.setPositionWithoutUpdate(n7, n8, n3 + 1);
                } else if (bl5) {
                    imagePlus.setPositionWithoutUpdate(n7, n3 + 1, n9);
                } else if (bl6) {
                    imagePlus.setPositionWithoutUpdate(n3 + 1, n8, n9);
                }
                ImagePlus imagePlus2 = imagePlus;
                if (bl3) {
                    if (!(bl4 || bl5 || bl6)) {
                        imagePlus.setSliceWithoutUpdate(n3 + 1);
                    }
                    imagePlus2 = imagePlus.flatten();
                }
                imageProcessor = new ColorProcessor(imagePlus2.getImage());
            } else {
                imageProcessor = this.zDim == 1 ? imagePlus.getProcessor() : imagePlus.getStack().getProcessor(n3 + 1);
            }
            int n15 = (int)this.raFile.getFilePointer();
            this.writeInt(n13);
            this.chunkSizeHere();
            if (this.biCompression == 0) {
                if (this.bytesPerPixel == 1) {
                    this.writeByteFrame(imageProcessor);
                } else {
                    this.writeRGBFrame(imageProcessor);
                }
            } else {
                this.writeCompressedFrame(imageProcessor);
            }
            nArray[n3] = (int)((long)n15 - l);
            nArray2[n3] = (int)(this.raFile.getFilePointer() - (long)n15 - 8L);
            if (n14 < nArray2[n3]) {
                n14 = nArray2[n3];
            }
            this.chunkEndWriteSize();
        }
        this.chunkEndWriteSize();
        if (bl || bl2) {
            imagePlus.setPosition(n7, n8, n9);
        }
        this.writeString("idx1");
        this.chunkSizeHere();
        for (n3 = 0; n3 < this.zDim; ++n3) {
            this.writeInt(n13);
            this.writeInt(16);
            this.writeInt(nArray[n3]);
            this.writeInt(nArray2[n3]);
        }
        this.chunkEndWriteSize();
        this.chunkEndWriteSize();
        this.raFile.close();
        IJ.showProgress(1.0);
    }

    private void chunkSizeHere() throws IOException {
        this.sizePointers[this.stackPointer] = this.raFile.getFilePointer();
        this.writeInt(0);
        ++this.stackPointer;
    }

    private void chunkEndWriteSize() throws IOException {
        --this.stackPointer;
        long l = this.raFile.getFilePointer();
        this.raFile.seek(this.sizePointers[this.stackPointer]);
        this.writeInt((int)(l - (this.sizePointers[this.stackPointer] + 4L)));
        this.raFile.seek((l + 1L) / 2L * 2L);
    }

    private void writeByteFrame(ImageProcessor imageProcessor) throws IOException {
        imageProcessor = imageProcessor.convertToByte(true);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = 0;
        for (int i = n2 - 1; i >= 0; --i) {
            int n4;
            int n5 = i * n;
            for (n4 = 0; n4 < n; ++n4) {
                this.bufferWrite[n3++] = byArray[n5++];
            }
            for (n4 = 0; n4 < this.linePad; ++n4) {
                this.bufferWrite[n3++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    private void writeRGBFrame(ImageProcessor imageProcessor) throws IOException {
        imageProcessor = imageProcessor.convertToRGB();
        int[] nArray = (int[])imageProcessor.getPixels();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = 0;
        for (int i = n2 - 1; i >= 0; --i) {
            int n4;
            int n5 = i * n;
            for (n4 = 0; n4 < n; ++n4) {
                int n6 = nArray[n5++];
                this.bufferWrite[n3++] = (byte)(n6 & 0xFF);
                this.bufferWrite[n3++] = (byte)((n6 & 0xFF00) >> 8);
                this.bufferWrite[n3++] = (byte)((n6 & 0xFF0000) >> 16);
            }
            for (n4 = 0; n4 < this.linePad; ++n4) {
                this.bufferWrite[n3++] = 0;
            }
        }
        this.raFile.write(this.bufferWrite);
    }

    private void writeCompressedFrame(ImageProcessor imageProcessor) throws IOException {
        if (this.biCompression == 1196444237) {
            BufferedImage bufferedImage = this.getBufferedImage(imageProcessor);
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", this.raOutputStream);
        } else {
            BufferedImage bufferedImage = imageProcessor.getBufferedImage();
            ImageIO.write((RenderedImage)bufferedImage, "png", this.raOutputStream);
        }
    }

    private BufferedImage getBufferedImage(ImageProcessor imageProcessor) {
        BufferedImage bufferedImage = new BufferedImage(imageProcessor.getWidth(), imageProcessor.getHeight(), 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageProcessor.createImage(), 0, 0, null);
        return bufferedImage;
    }

    private void writeLUT(ImageProcessor imageProcessor) throws IOException {
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getCurrentColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[1024];
        for (int i = 0; i < 256; ++i) {
            if (i >= n) continue;
            byArray[4 * i] = (byte)indexColorModel.getBlue(i);
            byArray[4 * i + 1] = (byte)indexColorModel.getGreen(i);
            byArray[4 * i + 2] = (byte)indexColorModel.getRed(i);
            byArray[4 * i + 3] = 0;
        }
        this.raFile.write(byArray);
    }

    private double getFrameRate(ImagePlus imagePlus) {
        double d = imagePlus.getCalibration().fps;
        if (d == 0.0) {
            d = Animator.getFrameRate();
        }
        if (d <= 0.5) {
            d = 0.5;
        }
        return d;
    }

    private void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF8");
        this.raFile.write(byArray);
    }

    private void writeInt(int n) throws IOException {
        this.raFile.write(n & 0xFF);
        this.raFile.write(n >>> 8 & 0xFF);
        this.raFile.write(n >>> 16 & 0xFF);
        this.raFile.write(n >>> 24 & 0xFF);
    }

    private void writeShort(int n) throws IOException {
        this.raFile.write(n & 0xFF);
        this.raFile.write(n >>> 8 & 0xFF);
    }

    class RaOutputStream
    extends OutputStream {
        RandomAccessFile raFile;

        RaOutputStream(RandomAccessFile randomAccessFile) {
            this.raFile = randomAccessFile;
        }

        public void write(int n) throws IOException {
            this.raFile.writeByte(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.raFile.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.raFile.write(byArray, n, n2);
        }
    }
}

