/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

class RollingBall {
    float[] data;
    int width;
    int shrinkFactor;

    RollingBall(double d) {
        int n;
        if (d <= 10.0) {
            this.shrinkFactor = 1;
            n = 24;
        } else if (d <= 30.0) {
            this.shrinkFactor = 2;
            n = 24;
        } else if (d <= 100.0) {
            this.shrinkFactor = 4;
            n = 32;
        } else {
            this.shrinkFactor = 8;
            n = 40;
        }
        this.buildRollingBall(d, n);
    }

    void buildRollingBall(double d, int n) {
        this.shrinkFactor = this.shrinkFactor;
        double d2 = d / (double)this.shrinkFactor;
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        double d3 = d2 * d2;
        int n2 = (int)((double)n * d2) / 100;
        int n3 = (int)Math.round(d2 - (double)n2);
        this.width = 2 * n3 + 1;
        this.data = new float[this.width * this.width];
        int n4 = 0;
        for (int i = 0; i < this.width; ++i) {
            int n5 = 0;
            while (n5 < this.width) {
                int n6 = n5 - n3;
                int n7 = i - n3;
                double d4 = d3 - (double)(n6 * n6) - (double)(n7 * n7);
                this.data[n4] = d4 > 0.0 ? (float)Math.sqrt(d4) : 0.0f;
                ++n5;
                ++n4;
            }
        }
    }
}

