% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_app.R
\name{create_app}
\alias{create_app}
\title{Creates installation files and Inno Setup Script (ISS), "app_name.iss"}
\usage{
create_app(app_name = "myapp", app_dir = getwd(),
  dir_out = "RInno_installer", pkgs = c("jsonlite", "shiny",
  "magrittr"), pkgs_path = "bin", repo = "https://cran.rstudio.com",
  remotes = "none", locals = NULL, app_repo_url = "none",
  auth_user = "none", auth_pw = "none", auth_token = github_pat(),
  user_browser = "electron", include_R = FALSE,
  include_Pandoc = FALSE, include_Chrome = FALSE,
  include_Rtools = FALSE, R_version = paste0(">=", R.version$major,
  ".", R.version$minor), Pandoc_version = rmarkdown::pandoc_version(),
  Rtools_version = "3.5", overwrite = TRUE, force_nativefier = TRUE,
  nativefier_opts = c(), ...)
}
\arguments{
\item{app_name}{The name of the app. It will be displayed throughout the installer's window titles, wizard pages, and dialog boxes. See \href{http://www.jrsoftware.org/ishelp/topic_setup_appname.htm}{[Setup]:AppName} for details. For continuous installations, \code{app_name} is used to check for an R package of the same name, and update it. The Continuous Installation vignette has more details.}

\item{app_dir}{Development app's directory, defaults to \code{getwd()}.}

\item{dir_out}{Installer's directory. A sub-directory of \code{app_dir}, which will be created if it does not exist. Defaults to 'RInno_installer'.}

\item{pkgs}{Character vector of package dependencies. Remote development versions are supported via \code{remotes}. \code{pkgs} are downloaded into \code{file.path(app_dir, pkgs_path)} as Windows binary packages (.zip). If you build binary packages and store them there before calling \code{create_app}, they will be included as well.}

\item{pkgs_path}{Default location inside the app working directory to install package dependencies This defaults to \code{pkgs_path = "bin"}}

\item{repo}{Default repository to install CRAN package dependencies. Defaults to \code{repo = "https://cran.rstudio.com"}.}

\item{remotes}{Character vector of GitHub repository addresses in the format \code{username/repo[/subdir][\@ref|#pull]} for GitHub package dependencies.}

\item{locals}{Character vector of local package dependencies. Deprecated as of v1.0.0. Use \code{pkgs} instead.}

\item{app_repo_url}{Repository address for continuous installations in the format \code{"https://bitbucket.org/username/repo"} (\code{repo = app_name}). Only Bitbucket and GitHub repositories are supported.}

\item{auth_user}{Bitbucket username. It is recommended to create a read-only account for each app.  Support for OAuth 2 and tokens is in the works.}

\item{auth_pw}{Bitbucket password matching the above username.}

\item{auth_token}{To install from a private Github repo, generate a personal access token (PAT) in \url{https://github.com/settings/tokens} and supply to this argument. This is safer than using a password because you can easily delete a PAT without affecting any others.}

\item{user_browser}{Character for the default browser. Options include "chrome", "firefox", and "ie."}

\item{include_R}{To include R in the installer, \code{include_R = TRUE}. The version of R specified by \code{R_version} is used. The installer will check each user's registry and only install R if necessary.}

\item{include_Pandoc}{To include Pandoc in the installer, \code{include_Pandoc = TRUE}. If installing a flexdashboard app, some users may need a copy of Pandoc. The installer will check the user's registry for the version of Pandoc specified in \code{Pandoc_version} and only install it if necessary.}

\item{include_Chrome}{To include Chrome in the installer, \code{include_Chrome = TRUE}. If you would like to use Chrome's app mode, it is no longer supported by Google :(.}

\item{include_Rtools}{To include Rtools in the installer, \code{include_Rtools = TRUE}. For some packages to build properly, you may need to include Rtools.}

\item{R_version}{R version to use. Supports inequalities. Defaults to: \code{paste0(">=", R.version$major, '.', R.version$minor)}.}

\item{Pandoc_version}{Pandoc version to use, defaults to: \link[rmarkdown]{pandoc_available}.}

\item{Rtools_version}{Rtools version to include. For more information, see \href{https://cran.r-project.org/bin/windows/Rtools/}{Building R for Windows}.}

\item{overwrite}{Logical. Should existing installation files be overwritten? See \code{\link{copy_installation}} for details.}

\item{force_nativefier}{Boolean. Defaults to true and re-builds UI. If false, the UI is not rebuilt.}

\item{nativefier_opts}{Character vector. Extra options to pass to nativefier when \code{user_browser = "electron"}. Each string in the vector should be a valid nativefier command. For example, \code{c('--no-overwrite', '--conceal', '--show-menu-bar')}. For more information, \code{system("nativefier --help")}.}

\item{...}{Arguments passed on to \code{setup_section}, \code{files_section}, \code{directives_section}, \code{icons_section}, \code{languages_section}, \code{code_section}, \code{tasks_section}, and \code{run_section}.}
}
\description{
This function manages installation and app start up. To accept all defaults, just provide \code{app_name}. After calling \code{create_app}, call \code{\link{compile_iss}} to create an installer in \code{dir_out}.
}
\details{
Creates the following files in \code{app_dir}:
\itemize{
  \item Icons for installer and app, \emph{setup.ico} and \emph{default.ico} respectively.
  \item Files that manage app start up, \emph{utils/package_manager.R}, \emph{utils/ensure.R}, and \emph{utils/launch_app.R}.
  \item First/last page of the installer, \emph{infobefore.txt} and \emph{infoafter.txt}.
  \item Batch support files, \emph{utils/wsf/run.wsf}, \emph{utils/wsf/js/run.js}, \emph{utils/wsf/js/json2.js}, \emph{utils/wsf/js/JSON.minify.js}.
  \item A configuration file, \emph{config.cfg}. See \code{\link{create_config}} for details.
  \item A batch file, \emph{app_name.bat}. See \code{\link{create_bat}} for details.
  \item An Inno Setup Script, \emph{app_name.iss}.
}
}
\examples{
\dontrun{

create_app('myapp')

create_app(
  app_name     = 'My AppName',
  app_dir      = 'My/app/path',
  dir_out      = 'wizard',
  pkgs         = c('jsonlite', 'shiny', 'magrittr', 'xkcd'),
  include_R    = TRUE,   # Download R and install it with the app
  R_version    = "2.2.1",  # Old version of R
  privilege    = 'high', # Admin only installation
  default_dir  = 'pf') # Program Files
}
}
\seealso{
\code{\link{get_R}}, \code{\link{copy_installation}}, \code{\link{create_config}}, \code{\link{create_bat}}, \code{\link{directives_section}}, \code{\link{setup_section}}, \code{\link{languages_section}}, \code{\link{tasks_section}}, \code{\link{files_section}}, \code{\link{icons_section}}, \code{\link{run_section}}, and \code{\link{code_section}}.
}
\author{
Jonathan M. Hill and Hanjo Odendaal
}
