/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.Determinant;
import ec.tstoolkit.eco.Likelihood;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class ArmaKF {
    public static int fnCalls;
    private IArimaModel arma_;
    private Polynomial phi_;
    private int dim_;
    private double h0_;
    private double[] c0_;
    private double eps_ = 0.0;
    private boolean fast_;

    public ArmaKF(IArimaModel arma) {
        this.initmodel(arma, 0);
    }

    public DataBlock fastFilter(IReadDataBlock y) {
        int nq;
        double[] C = (double[])this.c0_.clone();
        double h = this.h0_;
        double var = this.arma_.getInnovationVariance();
        if (var != 1.0) {
            h /= var;
            int i = 0;
            while (i < C.length) {
                int n = i++;
                C[n] = C[n] / var;
            }
        }
        double[] L = (double[])C.clone();
        double[] a = new double[this.dim_];
        int n = y.getLength();
        double[] yl = new double[n];
        int ilast = this.dim_ - 1;
        Polynomial theta = this.arma_.getMA().getPolynomial();
        int np = this.phi_.getDegree();
        int im = np > (nq = theta.getDegree()) ? np : nq;
        for (int pos = 0; pos < im; ++pos) {
            double zlv;
            double e;
            double s = Math.sqrt(h);
            yl[pos] = e = (y.get(pos) - a[0]) / s;
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + C[i] * v;
            }
            a[ilast] = la + C[ilast] * v;
            double zl = L[0];
            if ((h -= zl * (zlv = zl / h)) < 1.0) {
                h = 1.0;
            }
            if (Double.isNaN(h)) {
                throw new ArimaException();
            }
            if (!(h - 1.0 > this.eps_)) continue;
            double llast = this.tlast(L);
            double clast = C[ilast];
            for (int i = 0; i < ilast; ++i) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - C[i] * zlv;
                    int n2 = i;
                    C[n2] = C[n2] - zlv * li;
                    continue;
                }
                L[i] = li;
            }
            L[ilast] = llast - zlv * clast;
            int n3 = ilast;
            C[n3] = C[n3] - zlv * llast;
        }
        for (int i = im; i < n; ++i) {
            double x = y.get(i);
            for (int p = 1; p <= np; ++p) {
                x += y.get(i - p) * this.phi_.get(p);
            }
            for (int q = 1; q <= nq; ++q) {
                x -= yl[i - q] * theta.get(q);
            }
            yl[i] = x;
        }
        return new DataBlock(yl);
    }

    public double fastProcessing(IReadDataBlock y, int nparams) {
        DataBlock yl = this.fastFilter(y);
        int n = yl.getLength();
        double ssqerr = yl.ssq();
        return Math.log(ssqerr / (double)n) + (double)nparams * Math.log(n) / (double)n;
    }

    private void initmodel(IArimaModel arma, int statedim) {
        if (!arma.isStationary()) {
            throw new ArimaException("acgf_err_st");
        }
        this.arma_ = arma;
        this.phi_ = this.arma_.getAR().getPolynomial();
        if (statedim == 0) {
            statedim = Math.max(this.phi_.getDegree(), this.arma_.getMA().getLength());
        }
        this.dim_ = statedim;
        this.c0_ = this.arma_.getAutoCovarianceFunction().values(this.dim_);
        this.h0_ = this.c0_[0];
        this.tx(this.c0_);
    }

    public boolean process(IReadDataBlock y, IDataBlock res, IDataBlock stde) {
        ++fnCalls;
        this.fast_ = false;
        Determinant det = new Determinant();
        double[] C = (double[])this.c0_.clone();
        double[] L = (double[])C.clone();
        double h = this.h0_;
        double var = this.arma_.getInnovationVariance();
        double[] a = new double[this.dim_];
        int n = y.getLength();
        int pos = 0;
        int ilast = this.dim_ - 1;
        do {
            if (Double.isNaN(h) || h < 0.0) {
                return false;
            }
            det.add(h);
            double s = Math.sqrt(h);
            double e = (y.get(pos) - a[0]) / s;
            res.set(pos, e);
            stde.set(pos, s);
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + C[i] * v;
            }
            a[ilast] = la + C[ilast] * v;
            double zl = L[0];
            double zlv = zl / h;
            if (this.fast_) continue;
            double llast = this.tlast(L);
            double clast = C[ilast];
            for (int i = 0; i < ilast; ++i) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - C[i] * zlv;
                    int n2 = i;
                    C[n2] = C[n2] - zlv * li;
                    continue;
                }
                L[i] = li;
            }
            L[ilast] = llast - zlv * clast;
            int n3 = ilast;
            C[n3] = C[n3] - zlv * llast;
            if ((h -= zl * zlv) < var) {
                h = var;
            }
            if (!(h - var <= this.eps_)) continue;
            this.fast_ = true;
        } while (++pos < n);
        return true;
    }

    public boolean process(IReadDataBlock y, Likelihood ll) {
        ++fnCalls;
        this.fast_ = false;
        Determinant det = new Determinant();
        double[] C = (double[])this.c0_.clone();
        double[] L = (double[])C.clone();
        double h = this.h0_;
        double var = this.arma_.getInnovationVariance();
        double[] a = new double[this.dim_];
        int n = y.getLength();
        double[] yl = new double[n];
        int pos = 0;
        int ilast = this.dim_ - 1;
        do {
            double e;
            if (Double.isNaN(h) || h < 0.0) {
                return false;
            }
            det.add(h);
            double s = Math.sqrt(h);
            yl[pos] = e = (y.get(pos) - a[0]) / s;
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + C[i] * v;
            }
            a[ilast] = la + C[ilast] * v;
            double zl = L[0];
            double zlv = zl / h;
            if (this.fast_) continue;
            double llast = this.tlast(L);
            double clast = C[ilast];
            for (int i = 0; i < ilast; ++i) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - C[i] * zlv;
                    int n2 = i;
                    C[n2] = C[n2] - zlv * li;
                    continue;
                }
                L[i] = li;
            }
            L[ilast] = llast - zlv * clast;
            int n3 = ilast;
            C[n3] = C[n3] - zlv * llast;
            if ((h -= zl * zlv) < var) {
                h = var;
            }
            if (!(h - var <= this.eps_)) continue;
            this.fast_ = true;
        } while (++pos < n);
        double ssqerr = 0.0;
        for (int i = 0; i < n; ++i) {
            ssqerr += yl[i] * yl[i];
        }
        ll.set(ssqerr, det.getLogDeterminant(), n);
        ll.setRes(yl);
        return true;
    }

    public boolean process(IReadDataBlock y, SubArrayOfInt ao, SubMatrix x, ConcentratedLikelihood ll) {
        ++fnCalls;
        this.fast_ = false;
        Determinant det = new Determinant();
        double[] c = (double[])this.c0_.clone();
        double[] l = (double[])c.clone();
        double h = this.h0_;
        double var = this.arma_.getInnovationVariance();
        double[] a = new double[this.dim_];
        int nx = x.getColumnsCount();
        int n = y.getLength();
        double[] yl = new double[n];
        Matrix xl = new Matrix(n, nx);
        double[][] A = new double[nx][];
        double[] px = xl.internalStorage();
        int pos = 0;
        int ilast = this.dim_ - 1;
        DataBlockIterator xrows = x.rows();
        DataBlock xrow = xrows.getData();
        do {
            double e;
            det.add(h);
            double s = Math.sqrt(h);
            yl[pos] = e = (y.get(pos) - a[0]) / s;
            double la = this.tlast(a);
            double v = e / s;
            for (int i = 0; i < ilast; ++i) {
                a[i] = a[i + 1] + c[i] * v;
            }
            a[ilast] = la + c[ilast] * v;
            int ix = 0;
            int ipx = pos;
            while (ix < nx) {
                double[] acur = A[ix];
                double xcur = xrow.get(ix);
                if (acur == null && xcur != 0.0) {
                    A[ix] = acur = new double[this.dim_];
                }
                if (acur != null) {
                    px[ipx] = e = (xcur - acur[0]) / s;
                    v = e / s;
                    la = this.tlast(acur);
                    for (int i = 0; i < ilast; ++i) {
                        acur[i] = acur[i + 1] + c[i] * v;
                    }
                    acur[ilast] = la + c[ilast] * v;
                }
                ++ix;
                ipx += n;
            }
            double zl = l[0];
            double zlv = zl / h;
            if (!this.fast_) {
                double llast = this.tlast(l);
                double clast = c[ilast];
                for (int i = 0; i < ilast; ++i) {
                    double li = l[i + 1];
                    if (zlv != 0.0) {
                        l[i] = li - c[i] * zlv;
                        int n2 = i;
                        c[n2] = c[n2] - zlv * li;
                        continue;
                    }
                    l[i] = li;
                }
                l[ilast] = llast - zlv * clast;
                int n3 = ilast;
                c[n3] = c[n3] - zlv * llast;
                if ((h -= zl * zlv) < var) {
                    h = var;
                }
                if (h - var <= this.eps_) {
                    this.fast_ = true;
                }
            }
            xrows.next();
        } while (++pos < n);
        double[] res = new double[n - nx];
        double[] b = new double[nx];
        Householder qr = new Householder(false);
        qr.decompose(xl);
        qr.leastSquares(new DataBlock(yl), new DataBlock(b), new DataBlock(res));
        Matrix R = qr.getR();
        double ssqerr = 0.0;
        for (int i = 0; i < res.length; ++i) {
            ssqerr += res[i] * res[i];
        }
        double ldet = det.getLogDeterminant();
        if (ao != null && !ao.isEmpty()) {
            DataBlock rdiag = qr.getRDiagonal();
            n -= ao.getLength();
            for (int i = 0; i < ao.getLength(); ++i) {
                ldet += 2.0 * Math.log(Math.abs(rdiag.get(ao.get(i))));
            }
        }
        ll.set(ssqerr, ldet, n);
        ll.setRes(res);
        Matrix bvar = SymmetricMatrix.XXt(UpperTriangularMatrix.inverse(R));
        bvar.mul(ssqerr / (double)n);
        ll.setB(b, bvar, nx);
        return true;
    }

    public void setEpsilon(double eps) {
        this.eps_ = eps;
    }

    public double getEpsilon() {
        return this.eps_;
    }

    private double tlast(double[] x) {
        double last = 0.0;
        for (int i = 1; i <= this.phi_.getDegree(); ++i) {
            last -= this.phi_.get(i) * x[this.dim_ - i];
        }
        return last;
    }

    private void tx(double[] x) {
        int i;
        double last = 0.0;
        for (i = 1; i <= this.phi_.getDegree(); ++i) {
            last -= this.phi_.get(i) * x[this.dim_ - i];
        }
        for (i = 1; i < this.dim_; ++i) {
            x[i - 1] = x[i];
        }
        x[this.dim_ - 1] = last;
    }
}

