/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.IRootsSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.PolynomialException;

public class Laguerre
implements IRootsSolver {
    private static final int MR = 8;
    private static final int MT = 10;
    private static final int MAXIT = 80;
    private static final double EPS = 1.0E-12;
    private static final double EPSS = 1.0E-14;
    private static final boolean m_bPolish = true;
    private Complex m_x = Complex.ZERO;
    private static final double[] m_frac = new double[]{0.0, 0.5, 0.25, 0.75, 0.13, 0.38, 0.62, 0.88, 1.0};
    private Complex[] m_roots;
    private Polynomial m_remainder;

    @Override
    public void clear() {
        this.m_roots = null;
        this.m_remainder = null;
    }

    @Override
    public boolean factorize(Polynomial p) {
        try {
            int d = p.getDegree();
            this.m_roots = new Complex[d];
            Complex[] a = new Complex[d + 1];
            for (int u = 0; u <= d; ++u) {
                a[u] = Complex.cart(p.get(u), 0.0);
            }
            this.zroots(a, this.m_roots, true);
            this.m_remainder = Polynomial.valueOf(p.get(p.getDegree()), new double[0]);
            return true;
        }
        catch (PolynomialException e) {
            this.m_remainder = p;
            this.m_roots = null;
            return false;
        }
    }

    void laguer(Complex[] a) throws PolynomialException {
        for (int iter = 1; iter <= 80; ++iter) {
            Complex dx;
            Complex x1;
            double abm;
            int m = a.length - 1;
            Complex b = a[m];
            double err = b.abs();
            Complex d = Complex.ZERO;
            Complex f = Complex.ZERO;
            double abx = this.m_x.abs();
            for (int j = m - 1; j >= 0; --j) {
                f = this.m_x.times(f).plus(d);
                d = this.m_x.times(d).plus(b);
                b = this.m_x.times(b).plus(a[j]);
                err = b.abs() + abx * err;
            }
            err *= 1.0E-14;
            if (b.abs() <= err) {
                return;
            }
            Complex g = d.div(b);
            Complex g2 = g.times(g);
            Complex h = g2.minus(f.div(b).times(2.0));
            Complex sq = h.times(m).minus(g2).times(m - 1).sqrt();
            Complex gp = g.plus(sq);
            Complex gm = g.minus(sq);
            double abp = gp.abs();
            if (abp < (abm = gm.abs())) {
                gp = gm;
            }
            if (this.m_x.equals((Object)(x1 = this.m_x.minus(dx = Math.max(abp, abm) > 0.0 ? Complex.cart(m).div(gp) : Complex.cart(Math.cos(iter), Math.sin(iter)).times(1.0 + abx))))) {
                return;
            }
            this.m_x = iter % 10 != 0 ? x1 : this.m_x.minus(dx.times(m_frac[iter / 10]));
        }
        throw new PolynomialException("Laguerre failed");
    }

    @Override
    public Polynomial remainder() {
        return this.m_remainder;
    }

    @Override
    public Complex[] roots() {
        return this.m_roots;
    }

    @Override
    public Laguerre exemplar() {
        Laguerre solver = new Laguerre();
        return solver;
    }

    void zroots(Complex[] a, Complex[] roots, boolean polish) {
        int j;
        int m = a.length - 1;
        Complex[] ad = (Complex[])a.clone();
        for (j = m - 1; j >= 0; --j) {
            this.m_x = Complex.cart(0.0);
            Complex[] adv = new Complex[j + 2];
            for (int jj = 0; jj < j + 2; ++jj) {
                adv[jj] = ad[jj];
            }
            this.laguer(adv);
            if (Math.abs(this.m_x.getIm()) <= 2.0E-12 * Math.abs(this.m_x.getRe())) {
                this.m_x = Complex.cart(this.m_x.getRe());
            }
            roots[j] = this.m_x;
            Complex b = ad[j + 1];
            for (int jj = j; jj >= 0; --jj) {
                Complex c = ad[jj];
                ad[jj] = b;
                b = this.m_x.times(b).plus(c);
            }
        }
        if (polish) {
            for (j = 0; j < m; ++j) {
                this.m_x = roots[j];
                this.laguer(a);
            }
        }
        for (j = 1; j < m; ++j) {
            this.m_x = roots[j];
            for (int i = j - 1; i >= 0 && !(roots[i].getRe() <= this.m_x.getRe()); --i) {
                roots[i + 1] = roots[i];
            }
            roots[i + 1] = this.m_x;
        }
    }
}

