/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima;

import ec.tstoolkit.arima.ArimaException;

public class SarmaSpecification
implements Cloneable {
    int frequency;
    int P;
    int Q;
    int BP;
    int BQ;

    public SarmaSpecification() {
    }

    public SarmaSpecification(int freq) {
        this.frequency = freq;
    }

    public SarmaSpecification clone() {
        try {
            return (SarmaSpecification)super.clone();
        }
        catch (CloneNotSupportedException err) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SarmaSpecification && this.equals((SarmaSpecification)obj);
    }

    private boolean equals(SarmaSpecification other) {
        return other.frequency == this.frequency && other.P == this.P && other.Q == this.Q && other.BP == this.BP && other.BQ == this.BQ;
    }

    public int getBP() {
        return this.BP;
    }

    public int getBQ() {
        return this.BQ;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getP() {
        return this.P;
    }

    public int getParametersCount() {
        return this.P + this.BP + this.Q + this.BQ;
    }

    public int getQ() {
        return this.Q;
    }

    public int hashCode() {
        return this.frequency + this.P + this.Q + this.BP + this.BQ;
    }

    public void initialize(int freq) {
        this.frequency = freq;
    }

    public void setBP(int value) throws ArimaException {
        this.BP = value;
    }

    public void setBQ(int value) throws ArimaException {
        this.BQ = value;
    }

    public void setFrequency(int value) {
        this.frequency = value;
    }

    public void setP(int value) throws ArimaException {
        this.P = value;
    }

    public void setQ(int value) throws ArimaException {
        this.Q = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(this.P).append(',');
        builder.append(this.Q).append(')');
        if (this.getFrequency() > 1) {
            builder.append('(');
            builder.append(this.BP).append(',');
            builder.append(this.BQ).append(')');
        }
        return builder.toString();
    }
}

