/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.seats.SeatsKernel;
import ec.satoolkit.seats.SeatsResults;
import ec.satoolkit.seats.SeatsSpecification;
import ec.satoolkit.seats.SeatsToolkit;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.special.MixedAirlineModel;
import ec.tstoolkit.arima.special.MixedAirlineMonitor;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MixedAirlineResults
implements ISaResults {
    public static final String NOISE = "noisecomponent";
    public static final String NOISE_DATA = "noise";
    public static final String IRREGULAR = "irregular";
    public static final String NOISE_LBOUND = "lbound";
    public static final String NOISE_UBOUND = "ubound";
    public static final String RESIDUALS = "residuals";
    private MixedAirlineMonitor monitor_;
    private SmoothingResults srslts_;
    private final InformationSet info_ = new InformationSet();
    private TsData y_;
    private TsData yc_;
    private TsData im_;
    private TsData t_;
    private TsData sa_;
    private TsData s_;
    private TsData noise_;
    private TsData i_;
    private TsData enoise_;
    private UcarimaModel ucm_;
    private WienerKolmogorovEstimators wk_;
    private boolean mul_;
    private static final InformationMapping<MixedAirlineResults> MAPPING = new InformationMapping<MixedAirlineResults>(MixedAirlineResults.class);

    MixedAirlineResults(TsData y, MixedAirlineMonitor monitor, boolean b) {
        this.y_ = y;
        this.mul_ = b;
        this.monitor_ = monitor;
        MixedAirlineMonitor.MixedEstimation rslt = monitor.getBestModel();
        if (rslt != null) {
            this.computeDecomposition(rslt.model);
        }
    }

    private void computeDecomposition(MixedAirlineModel model) {
        Smoother smoother = new Smoother();
        ISsf ssf = model.makeSsf();
        smoother.setSsf(ssf);
        smoother.setCalcVar(true);
        SsfData data = new SsfData(this.y_.internalStorage(), null);
        this.srslts_ = new SmoothingResults(true, true);
        smoother.process(data, this.srslts_);
        this.noise_ = new TsData(this.y_.getStart(), this.srslts_.component(ssf.getStateDim() - 1), false);
        this.enoise_ = new TsData(this.y_.getStart(), this.srslts_.componentStdev(ssf.getStateDim() - 1), false);
        for (int i = 0; i < this.noise_.getLength(); ++i) {
            if (this.noise_.get(i) != 0.0) continue;
            this.enoise_.set(i, 0.0);
        }
        this.yc_ = TsData.subtract(this.y_, this.noise_);
        SeatsKernel kernel = new SeatsKernel();
        SeatsSpecification spec = new SeatsSpecification();
        kernel.setToolkit(SeatsToolkit.create(spec));
        SeatsResults rslts = kernel.process(this.yc_);
        this.ucm_ = rslts.getUcarimaModel();
        this.t_ = rslts.getSeriesDecomposition().getSeries(ComponentType.Trend, ComponentInformation.Value);
        this.sa_ = rslts.getSeriesDecomposition().getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
        this.s_ = rslts.getSeriesDecomposition().getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        this.im_ = rslts.getSeriesDecomposition().getSeries(ComponentType.Irregular, ComponentInformation.Value);
        this.i_ = TsData.add(this.noise_, this.im_);
        this.sa_ = TsData.add(this.sa_, this.noise_);
        InformationSet ninfo = this.info_.subSet(NOISE);
        ninfo.add(NOISE_DATA, this.noise_);
        ninfo.add(IRREGULAR, this.im_);
        ninfo.add(NOISE_LBOUND, TsData.subtract(this.noise_, this.enoise_));
        ninfo.add(NOISE_UBOUND, TsData.add(this.noise_, this.enoise_));
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, tclass);
            }
            return this.info_.search(id, tclass);
        }
        return null;
    }

    @Override
    public boolean contains(String id) {
        if (MAPPING.contains(id)) {
            return true;
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, Object.class) != null;
            }
            return this.info_.search(id, Object.class) != null;
        }
        return false;
    }

    @Override
    public ISeriesDecomposition getSeriesDecomposition() {
        DefaultSeriesDecomposition decomposition = new DefaultSeriesDecomposition(this.mul_ ? DecompositionMode.Multiplicative : DecompositionMode.Additive);
        if (this.mul_) {
            decomposition.add(this.y_.exp(), ComponentType.Series);
            decomposition.add(this.sa_.exp(), ComponentType.SeasonallyAdjusted);
            decomposition.add(this.t_.exp(), ComponentType.Trend);
            decomposition.add(this.s_.exp(), ComponentType.Seasonal);
            decomposition.add(this.i_.exp(), ComponentType.Irregular);
        } else {
            decomposition.add(this.y_, ComponentType.Series);
            decomposition.add(this.sa_, ComponentType.SeasonallyAdjusted);
            decomposition.add(this.t_, ComponentType.Trend);
            decomposition.add(this.s_, ComponentType.Seasonal);
            decomposition.add(this.i_, ComponentType.Irregular);
        }
        return decomposition;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    public UcarimaModel getUcarimaModel() {
        return this.ucm_;
    }

    public WienerKolmogorovEstimators getWienerKolmogorovEstimators() {
        if (this.ucm_ == null) {
            return null;
        }
        if (this.wk_ == null) {
            this.wk_ = new WienerKolmogorovEstimators(this.ucm_);
        }
        return this.wk_;
    }

    public MixedAirlineMonitor.MixedEstimation getBestModel() {
        return this.monitor_.getBestModel();
    }

    public int getBestModelPosition() {
        return this.monitor_.getBestModelPosition();
    }

    public List<MixedAirlineMonitor.MixedEstimation> getAllModels() {
        return this.monitor_.getAllResults();
    }

    public TsData getResiduals() {
        TsDomain domain = this.y_.getDomain();
        double[] res = this.monitor_.getBestModel().ll.getResiduals();
        return new TsData(domain.getStart().plus(domain.getLength() - res.length), res, false);
    }

    public TsData getNoise() {
        return this.noise_;
    }

    public TsData getNoiseStdev() {
        return this.enoise_;
    }

    @Override
    public InformationSet getInformation() {
        return this.info_;
    }

    public static InformationMapping<MixedAirlineResults> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<MixedAirlineResults, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<MixedAirlineResults, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set("y_cmp", source -> source.mul_ ? source.y_.exp() : source.y_);
        MAPPING.set("t_cmp", source -> source.mul_ ? source.t_.exp() : source.t_);
        MAPPING.set("sa_cmp", source -> source.mul_ ? source.sa_.exp() : source.sa_);
        MAPPING.set("s_cmp", source -> source.mul_ ? source.s_.exp() : source.s_);
        MAPPING.set("i_cmp", source -> source.mul_ ? source.i_.exp() : source.i_);
        MAPPING.set("y_lin", source -> source.y_);
        MAPPING.set("t_lin", source -> source.t_);
        MAPPING.set("sa_lin", source -> source.sa_);
        MAPPING.set("s_lin", source -> source.s_);
        MAPPING.set("i_lin", source -> source.i_);
        MAPPING.set("si_cmp", source -> {
            TsData si = TsData.add(source.s_, source.i_);
            if (si == null) {
                return null;
            }
            return source.mul_ ? si.exp() : si;
        });
        MAPPING.set(RESIDUALS, source -> source.getResiduals());
        MAPPING.set(IRREGULAR, source -> source.im_);
        MAPPING.set(NOISE_DATA, source -> source.noise_);
    }
}

