/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ProcessingInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelProcessingNode<I>
implements IProcessingNode<I> {
    private final int NBR_EXECUTORS = Runtime.getRuntime().availableProcessors();
    private final String name;
    private final String prefix;
    private ArrayList<IProcessingNode<I>> nodes_ = new ArrayList();

    public ParallelProcessingNode(String name, String prefix) {
        this.name = name;
        this.prefix = prefix;
    }

    public void add(IProcessingNode<I> node) {
        this.nodes_.add(node);
    }

    private List<Callable<IProcessing.Status>> createTasks(final I input, final Map<String, IProcResults> map, final Map<String, String> errors) {
        ArrayList<Callable<IProcessing.Status>> result = new ArrayList<Callable<IProcessing.Status>>();
        for (final IProcessingNode<I> o : this.nodes_) {
            result.add(new Callable<IProcessing.Status>(){

                @Override
                public IProcessing.Status call() throws Exception {
                    try {
                        return o.process(input, map);
                    }
                    catch (Exception err) {
                        errors.put(o.getName(), err.getMessage());
                        return IProcessing.Status.Invalid;
                    }
                }
            });
        }
        result.trimToSize();
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public IProcessing.Status process(I input, Map<String, IProcResults> results) {
        CompositeResults cresults = new CompositeResults();
        ConcurrentHashMap<String, IProcResults> map = new ConcurrentHashMap<String, IProcResults>();
        ExecutorService executorService = Executors.newFixedThreadPool(this.NBR_EXECUTORS, CustomThreadFactory.INSTANCE);
        ConcurrentHashMap<String, String> errors = new ConcurrentHashMap<String, String>();
        List<Callable<IProcessing.Status>> tasks = this.createTasks(input, map, errors);
        try {
            executorService.invokeAll(tasks);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return IProcessing.Status.Invalid;
        }
        executorService.shutdown();
        for (IProcessingNode<I> iProcessingNode : this.nodes_) {
            String cname = iProcessingNode.getName();
            IProcResults cresult = map.get(cname);
            cresults.put(cname, cresult, iProcessingNode.getPrefix());
        }
        if (!errors.isEmpty()) {
            for (Map.Entry entry : errors.entrySet()) {
                cresults.addInformation(ProcessingInformation.error((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        results.put(this.name, cresults);
        return IProcessing.Status.Valid;
    }

    private static enum CustomThreadFactory implements ThreadFactory
    {
        INSTANCE;

        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        private CustomThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + CustomThreadFactory.class.getSimpleName() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

