/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.information;

import ec.tstoolkit.information.InformationMappingExtension;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.WildCards;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;

public class InformationMapping<S> {
    public static final String LSTART = "(";
    public static final String LEND = ")";
    private final LinkedHashMap<String, TFunction<S, ?>> map = new LinkedHashMap();
    private final LinkedHashMap<String, TListFunction<S, ?>> lmap = new LinkedHashMap();
    private final Class<S> sourceClass;

    public static String listKey(String prefix, int item) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        if (LSTART != null) {
            builder.append(LSTART);
        }
        builder.append(item);
        if (LEND != null) {
            builder.append(LEND);
        }
        return builder.toString();
    }

    public static String wcKey(String prefix, char wc) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        if (LSTART != null) {
            builder.append(LSTART);
        }
        builder.append(wc);
        if (LEND != null) {
            builder.append(LEND);
        }
        return builder.toString();
    }

    public static int listItem(String prefix, String key) {
        if (!key.startsWith(prefix)) {
            return Integer.MIN_VALUE;
        }
        int start = prefix.length();
        if (LSTART != null) {
            start += LSTART.length();
        }
        int end = key.length();
        if (LEND != null) {
            end -= LEND.length();
        }
        if (end <= start) {
            return Integer.MIN_VALUE;
        }
        String s = key.substring(start, end);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return Integer.MIN_VALUE;
        }
    }

    public static boolean isIParamItem(String prefix, String key) {
        if (!key.startsWith(prefix)) {
            return false;
        }
        int start = prefix.length();
        if (LSTART != null) {
            start += LSTART.length();
        }
        int end = key.length();
        if (LEND != null) {
            end -= LEND.length();
        }
        if (end <= start) {
            return false;
        }
        String s = key.substring(start, end);
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public InformationMapping(Class<S> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public static void updateAll(ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        ServiceLoader<InformationMappingExtension> services = ServiceLoader.load(InformationMappingExtension.class, loader);
        HashSet set = new HashSet();
        for (InformationMappingExtension informationMappingExtension : services) {
            set.add(informationMappingExtension.getSourceClass());
        }
        for (Class clazz : set) {
            InformationMapping.update(clazz, loader);
        }
    }

    public static boolean update(Class sourceClass, ClassLoader loader) {
        try {
            Method method = sourceClass.getMethod("getMapping", new Class[0]);
            if (method == null) {
                return false;
            }
            InformationMapping rslt = (InformationMapping)method.invoke(null, new Object[0]);
            if (!rslt.sourceClass.equals(sourceClass)) {
                return false;
            }
            rslt.update(loader);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(ClassLoader loader) {
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        ServiceLoader<InformationMappingExtension> services = ServiceLoader.load(InformationMappingExtension.class, loader);
        for (InformationMappingExtension extension : services) {
            if (!extension.getSourceClass().equals(this.sourceClass)) continue;
            extension.updateExtractors(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set(String name, Class<T> tclass, Function<S, T> extractor) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.map.put(name, new TFunction<S, T>(tclass, extractor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set(String name, Function<S, TsData> extractor) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.map.put(name, new TFunction<S, TsData>(TsData.class, extractor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setList(String prefix, int start, int end, Class<T> tclass, BiFunction<S, Integer, T> extractor) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.lmap.put(prefix, new TListFunction<S, T>(tclass, start, end, extractor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setList(String prefix, int start, int end, BiFunction<S, Integer, TsData> extractor) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.lmap.put(prefix, new TListFunction<S, TsData>(TsData.class, start, end, extractor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set(String prefix, int defparam, Class<T> tclass, BiFunction<S, Integer, T> extractor) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.lmap.put(prefix, new TListFunction<S, T>(tclass, defparam, defparam, extractor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set(String prefix, int defparam, BiFunction<S, Integer, TsData> extractor) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            this.lmap.put(prefix, new TListFunction<S, TsData>(TsData.class, defparam, defparam, extractor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            for (Map.Entry<String, TFunction<S, ?>> entry : this.map.entrySet()) {
                dic.put(InformationSet.item(prefix, entry.getKey()), entry.getValue().targetClass);
            }
            if (compact) {
                for (Map.Entry<String, Object> entry : this.lmap.entrySet()) {
                    TListFunction fn = (TListFunction)entry.getValue();
                    if (fn.start == fn.end) {
                        dic.put(InformationSet.item(prefix, InformationMapping.wcKey(entry.getKey(), '?')), fn.targetClass);
                        continue;
                    }
                    dic.put(InformationSet.item(prefix, InformationMapping.wcKey(entry.getKey(), '*')), fn.targetClass);
                }
            } else {
                for (Map.Entry<String, Object> entry : this.lmap.entrySet()) {
                    TListFunction fn = (TListFunction)entry.getValue();
                    if (fn.start == fn.end) {
                        dic.put(InformationSet.item(prefix, InformationMapping.listKey(entry.getKey(), fn.start)), fn.targetClass);
                        continue;
                    }
                    for (int i = fn.start; i <= fn.end; ++i) {
                        dic.put(InformationSet.item(prefix, InformationMapping.listKey(entry.getKey(), i)), fn.targetClass);
                    }
                }
            }
        }
    }

    private int lmapsize() {
        return this.lmap.entrySet().stream().map(x -> 1 + ((TListFunction)x.getValue()).end - ((TListFunction)x.getValue()).start).reduce(0, Integer::sum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() {
        ArrayList<String> k = new ArrayList<String>();
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            k.addAll(this.map.keySet());
            for (Map.Entry<String, TListFunction<S, ?>> entry : this.lmap.entrySet()) {
                for (int j = entry.getValue().start; j <= entry.getValue().end; ++j) {
                    k.add(InformationMapping.listKey(entry.getKey(), j));
                }
            }
        }
        return k.toArray(new String[k.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String id) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            if (this.map.containsKey(id)) {
                return true;
            }
            for (Map.Entry<String, TListFunction<S, ?>> x : this.lmap.entrySet()) {
                if (x.getValue().start == x.getValue().end) {
                    if (!InformationMapping.isIParamItem(x.getKey(), id)) continue;
                    return true;
                }
                int idx = InformationMapping.listItem(x.getKey(), id);
                if (idx < x.getValue().start || idx > x.getValue().end) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getData(S source, String id, Class<T> tclass) {
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            TFunction<S, ?> fn = this.map.get(id);
            if (fn != null) {
                if (!tclass.isAssignableFrom(fn.targetClass)) {
                    return null;
                }
                return fn.extractor.apply(source);
            }
            for (Map.Entry<String, TListFunction<S, ?>> x : this.lmap.entrySet()) {
                int idx;
                TListFunction<S, ?> value = x.getValue();
                if (!tclass.isAssignableFrom(value.targetClass) || (idx = InformationMapping.listItem(x.getKey(), id)) == Integer.MIN_VALUE) continue;
                if (value.start == value.end) {
                    return value.extractor.apply(source, idx);
                }
                if (idx < value.start || idx > value.end) continue;
                return value.extractor.apply(source, idx);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<String, T> searchAll(S source, String pattern, Class<T> tclass) {
        LinkedHashMap list = new LinkedHashMap();
        WildCards wc = new WildCards(pattern);
        InformationMapping informationMapping = this;
        synchronized (informationMapping) {
            Object fn;
            for (Map.Entry<String, TFunction<S, ?>> entry : this.map.entrySet()) {
                if (!wc.match(entry.getKey())) continue;
                fn = entry.getValue();
                if (!tclass.isAssignableFrom(((TFunction)fn).targetClass)) continue;
                list.put(entry.getKey(), ((TFunction)fn).extractor.apply(source));
            }
            for (Map.Entry<String, Object> entry : this.lmap.entrySet()) {
                fn = (TListFunction)entry.getValue();
                if (!tclass.isAssignableFrom(((TListFunction)fn).targetClass)) continue;
                for (int i = ((TListFunction)fn).start; i <= ((TListFunction)fn).end; ++i) {
                    String key = InformationMapping.listKey(entry.getKey(), i);
                    if (!wc.match(key)) continue;
                    list.put(key, ((TListFunction)fn).extractor.apply(source, i));
                }
            }
        }
        return list;
    }

    private static class TFunction<S, T> {
        final Class<T> targetClass;
        final Function<S, T> extractor;

        TFunction(Class<T> tclass, Function<S, T> extractor) {
            this.targetClass = tclass;
            this.extractor = extractor;
        }
    }

    private static class TListFunction<S, T> {
        final Class<T> targetClass;
        final BiFunction<S, Integer, T> extractor;
        final int start;
        final int end;

        TListFunction(Class<T> tclass, int start, int end, BiFunction<S, Integer, T> extractor) {
            this.targetClass = tclass;
            this.extractor = extractor;
            this.start = start;
            this.end = end;
        }
    }
}

