/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special.mixedfrequencies;

import ec.benchmarking.Cumulator;
import ec.benchmarking.ssf.SsfDisaggregation;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.arima.estimation.AnsleyFilter;
import ec.tstoolkit.arima.special.EasterSpec;
import ec.tstoolkit.arima.special.RegressionSpec;
import ec.tstoolkit.arima.special.TradingDaysSpec;
import ec.tstoolkit.arima.special.mixedfrequencies.EstimateSpec;
import ec.tstoolkit.arima.special.mixedfrequencies.MixedFrequenciesSpecification;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.DifferenceStationaryModelHelper;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.matrices.ElementaryTransformations;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.DefaultArimaSpec;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.ArimaSpec;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DisturbanceSmoother;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfAlgorithm;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.SsfFunction;
import ec.tstoolkit.ssf.SsfFunctionInstance;
import ec.tstoolkit.ssf.SsfModel;
import ec.tstoolkit.ssf.arima.SsfArima;
import ec.tstoolkit.timeseries.DataType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.regression.DiffConstant;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class MixedFrequenciesMonitor {
    private TsData ls_;
    private TsData hs_;
    private TsData le_;
    private TsData he_;
    private TsData si_;
    private TsData esi_;
    private int c_;
    private MixedFrequenciesSpecification spec_;
    private TsDomain hdomain_;
    private TsDomain edomain_;
    private final ProcessingContext context_;
    private TsVariableList x_;
    private Matrix X_;
    private Matrix J_;
    private Matrix pcov_;
    private SarimaModel arima0_;
    private SarimaModel arima_;
    private ConcentratedLikelihood ll_;
    private ISsqFunction fn_;

    public MixedFrequenciesMonitor() {
        this.context_ = ProcessingContext.getActiveContext();
    }

    public MixedFrequenciesMonitor(ProcessingContext context) {
        this.context_ = context;
    }

    public boolean process(TsData lseries, TsData hseries, MixedFrequenciesSpecification spec) {
        this.clear();
        TsFrequency lf = lseries.getFrequency();
        TsFrequency hf = hseries.getFrequency();
        if (lf == hf) {
            return false;
        }
        if (lf.intValue() < hf.intValue()) {
            this.ls_ = lseries;
            this.hs_ = hseries;
        } else {
            this.ls_ = hseries;
            this.hs_ = lseries;
        }
        this.spec_ = spec;
        if (!this.computeDomains()) {
            return false;
        }
        this.buildRegression();
        this.computeX();
        this.calcInitialModel();
        if (this.spec_.getEstimate().getMethod() == EstimateSpec.Method.KalmanFilter) {
            return this.estimateSsf();
        }
        return this.estimateMatrix();
    }

    public void calcInterpolation() {
        if (this.spec_.getEstimate().getMethod() == EstimateSpec.Method.KalmanFilter) {
            this.ssfInterpolate();
        } else {
            this.matrixInterpolation();
        }
    }

    public TsData getInterpolatedSeries() {
        if (this.si_ == null) {
            this.calcInterpolation();
        }
        return this.si_;
    }

    public TsData getInterpolationErrors() {
        if (this.esi_ == null) {
            this.calcInterpolation();
        }
        return this.esi_;
    }

    public SarimaModel getArima() {
        return this.arima_;
    }

    public ConcentratedLikelihood getLikelihood() {
        return this.ll_;
    }

    public TsVariableList getRegression() {
        this.buildRegression();
        return this.x_;
    }

    public Matrix getX() {
        return this.X_;
    }

    public Matrix getJ() {
        return this.J_;
    }

    public TsDomain getEstimationDomain() {
        return this.edomain_;
    }

    public TsData getHighFreqInput() {
        return this.hs_;
    }

    public TsData getLowFreqInput() {
        return this.ls_;
    }

    public TsData getHighFreqData() {
        return this.he_;
    }

    public TsData getLowFreqData() {
        return this.le_;
    }

    public int getFrequenciesRatio() {
        return this.c_;
    }

    Matrix getParametersCovariance() {
        return this.pcov_;
    }

    private void clear() {
        this.ls_ = null;
        this.hs_ = null;
        this.spec_ = null;
        this.hdomain_ = null;
        this.edomain_ = null;
        this.x_ = null;
        this.X_ = null;
        this.J_ = null;
        this.arima_ = null;
        this.arima0_ = null;
        this.fn_ = null;
        this.ll_ = null;
        this.si_ = null;
        this.esi_ = null;
    }

    public ISsqFunction getFunction() {
        return this.fn_;
    }

    private void calcInitialModel() {
        this.arima0_ = this.spec_.getArima().getArima(this.edomain_.getFrequency().intValue());
        if (!this.spec_.getArima().hasFreeParameters()) {
            return;
        }
        this.arima0_.setDefault();
        TramoSpecification spec = TramoSpecification.TR0.clone();
        if (this.spec_.getBasic().isLog()) {
            spec.getTransform().setFunction(DefaultTransformationType.Log);
        }
        ArimaSpec tarima = spec.getArima();
        DefaultArimaSpec sarima = this.spec_.getArima();
        tarima.setPhi(sarima.getPhi());
        tarima.setTheta(sarima.getTheta());
        tarima.setBPhi(sarima.getBPhi());
        tarima.setBTheta(sarima.getBTheta());
        tarima.setD(sarima.getD());
        tarima.setBD(sarima.getBD());
        tarima.setMean(sarima.isMean());
        TradingDaysSpec std = this.spec_.getRegression().getTradingDays();
        ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec ttd = spec.getRegression().getCalendar().getTradingDays();
        if (std.isUsed()) {
            ttd.setTradingDaysType(ttd.getTradingDaysType());
            ttd.setLeapYear(std.isLeapYear());
            ttd.setStockTradingDays(std.getStockTradingDays());
            if (std.getHolidays() != null) {
                ttd.setHolidays(std.getHolidays());
            } else if (std.getUserVariables() != null) {
                std.setUserVariables(ttd.getUserVariables());
            }
        }
        EasterSpec se = this.spec_.getRegression().getEaster();
        ec.tstoolkit.modelling.arima.tramo.EasterSpec te = spec.getRegression().getCalendar().getEaster();
        if (se.isUsed()) {
            te.setDuration(se.getDuration());
            te.setOption(se.getOption());
        }
        RegressionSpec sreg = this.spec_.getRegression();
        ec.tstoolkit.modelling.arima.tramo.RegressionSpec treg = spec.getRegression();
        treg.setInterventionVariables(sreg.getInterventionVariables());
        treg.setOutliers(sreg.getOutliers());
        treg.setRamps(sreg.getRamps());
        treg.setUserDefinedVariables(sreg.getUserDefinedVariables());
        IPreprocessor preprocessor = spec.build();
        try {
            PreprocessingModel model = preprocessor.process(this.hs_, null);
            if (model != null) {
                this.arima0_ = model.estimation.getArima();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean computeDomains() {
        TsDomain ldom;
        TsFrequency hf = this.hs_.getFrequency();
        TsFrequency lf = this.ls_.getFrequency();
        this.c_ = hf.ratio(lf);
        TsDomain hdom = this.hs_.getDomain();
        if (!hdom.intersection(ldom = this.ls_.getDomain().changeFrequency(hf, true)).isEmpty()) {
            return false;
        }
        this.hdomain_ = hdom.union(ldom).select(this.spec_.getBasic().getSpan());
        if (this.hdomain_.intersection(hdom).isEmpty() || this.hdomain_.intersection(ldom).isEmpty()) {
            return false;
        }
        this.edomain_ = this.hdomain_.select(this.spec_.getEstimate().getSpan());
        TsPeriodSelector sel = new TsPeriodSelector();
        sel.between(this.edomain_.getStart().firstday(), this.edomain_.getLast().lastday());
        this.he_ = this.hs_.select(sel);
        this.le_ = this.ls_.select(sel);
        return !this.edomain_.intersection(hdom).isEmpty() && !this.edomain_.intersection(ldom).isEmpty();
    }

    private void computeX() {
        if (this.x_.isEmpty()) {
            return;
        }
        this.X_ = this.x_.all().matrix(this.edomain_);
    }

    private void buildRegression() {
        this.x_ = new TsVariableList();
        if (this.spec_.getArima().isMean()) {
            this.x_.add(new DiffConstant(this.spec_.getArima().getSpecification(this.edomain_.getFrequency().intValue()).getDifferencingFilter(), this.edomain_.getStart().firstday()));
        }
        this.spec_.getRegression().fill(this.x_, this.edomain_.getFrequency(), this.context_);
    }

    private DataBlock buildSsfY() {
        int i0;
        TsFrequency hf = this.hs_.getFrequency();
        TsFrequency lf = this.ls_.getFrequency();
        TsData h = this.hs_.fittoDomain(this.edomain_);
        TsDomain ldom = this.ls_.getDomain();
        TsDomain hdom = this.hs_.getDomain();
        int l0 = this.edomain_.search(ldom.getStart().firstPeriod(hf));
        int l1 = this.edomain_.search(ldom.getEnd().firstPeriod(hf));
        if (l0 < 0) {
            l0 = 0;
        }
        l0 += this.c_ - 1;
        if (l1 < 0) {
            l1 = this.edomain_.getLength();
        }
        if ((i0 = ldom.search(this.edomain_.getStart().firstday())) < 0) {
            i0 = 0;
        }
        int h0 = this.edomain_.search(hdom.getStart());
        int h1 = this.edomain_.search(hdom.getEnd());
        if (h0 < 0) {
            h0 = 0;
        }
        if (h1 < 0) {
            h1 = this.edomain_.getLength();
        }
        boolean log = this.spec_.getBasic().isLog();
        boolean flow = this.spec_.getBasic().getDataType() == DataType.Flow;
        DataBlock y = new DataBlock(log ? h.log() : h);
        if (flow) {
            Cumulator cumul = new Cumulator(this.c_);
            cumul.transform(y.range(h0, h1));
        }
        if (log) {
            double cl = Math.log(this.c_);
            int j = l0;
            int i = i0;
            while (j < l1) {
                double cur = Math.log(this.ls_.get(i));
                if (flow) {
                    y.set(j, (double)this.c_ * (cur - cl));
                } else {
                    y.set(j, cur);
                }
                j += this.c_;
                ++i;
            }
        } else {
            int j = l0;
            int i = i0;
            while (j < l1) {
                y.set(j, this.ls_.get(i));
                j += this.c_;
                ++i;
            }
        }
        return y;
    }

    private Matrix buildSsfX() {
        if (this.X_ != null) {
            Matrix x = this.X_.clone();
            if (this.spec_.getBasic().getDataType() == DataType.Flow) {
                TsFrequency hf = this.hs_.getFrequency();
                TsFrequency lf = this.ls_.getFrequency();
                int c = hf.ratio(lf);
                Cumulator cumul = new Cumulator(c);
                DataBlockIterator cols = x.columns();
                DataBlock col = cols.getData();
                do {
                    cumul.transform(col);
                } while (cols.next());
            }
            return x;
        }
        return null;
    }

    private boolean estimateSsf() {
        DataBlock yc = this.buildSsfY();
        Matrix Xc = this.buildSsfX();
        if (this.spec_.getBasic().getDataType() == DataType.Flow) {
            return this.calcDisaggSsf(yc, Xc);
        }
        return this.calcSsf(yc, Xc);
    }

    private boolean estimateMatrix() {
        int r;
        TsFrequency hf = this.hs_.getFrequency();
        TsFrequency lf = this.ls_.getFrequency();
        int c = hf.ratio(lf);
        TsDomain ldom = this.ls_.getDomain();
        TsDomain hdom = this.hs_.getDomain();
        TsPeriodSelector sel = new TsPeriodSelector();
        sel.between(this.edomain_.getStart().firstday(), this.edomain_.getLast().lastday());
        int l0 = this.edomain_.search(ldom.getStart().firstPeriod(hf));
        int l1 = this.edomain_.search(ldom.getEnd().firstPeriod(hf));
        if (l0 < 0) {
            l0 = 0;
        }
        if (l1 < 0) {
            l1 = this.edomain_.getLength();
        }
        TsData tsl = this.ls_.select(sel);
        int h0 = this.edomain_.search(hdom.getStart());
        int h1 = this.edomain_.search(hdom.getEnd());
        if (h0 < 0) {
            h0 = 0;
        }
        if (h1 < 0) {
            h1 = this.edomain_.getLength();
        }
        TsData tsh = this.hs_.select(sel);
        int d = this.spec_.getArima().getD() + this.spec_.getArima().getBD() * this.edomain_.getFrequency().intValue();
        int n = this.edomain_.getLength();
        int m = tsl.getObsCount() + tsh.getObsCount();
        int[] initials = DifferenceStationaryModelHelper.searchDefaultInitialValues(tsh, d);
        if (initials == null) {
            return false;
        }
        DataBlock y = new DataBlock(m);
        this.J_ = new Matrix(m, n);
        boolean log = this.spec_.getBasic().isLog();
        boolean flow = this.spec_.getBasic().getDataType() == DataType.Flow;
        double lc = log ? Math.log(c) : 0.0;
        double cf = log ? 1.0 / (double)c : 1.0;
        for (r = 0; r < d; ++r) {
            y.set(r, log ? Math.log(tsh.get(initials[r])) : tsh.get(initials[r]));
            this.J_.set(r, h0 + initials[r], 1.0);
        }
        int i = 0;
        int j = l0;
        while (i < tsl.getLength()) {
            if (!tsl.isMissing(i)) {
                double cur = log ? Math.log(tsl.get(i)) : tsl.get(i);
                y.set(r, flow ? cur - lc : cur);
                if (flow) {
                    for (int k = j; k < j + c; ++k) {
                        this.J_.set(r, k, cf);
                    }
                } else {
                    this.J_.set(r, j + c - 1, 1.0);
                }
                ++r;
            }
            ++i;
            j += c;
        }
        i = 0;
        j = h0;
        while (i < tsh.getLength()) {
            if (!tsh.isMissing(i) && !MixedFrequenciesMonitor.contains(initials, i)) {
                y.set(r, log ? Math.log(tsh.get(i)) : tsh.get(i));
                this.J_.set(r, j, 1.0);
                ++r;
            }
            ++i;
            ++j;
        }
        return this.calcMcElroy(y);
    }

    private static boolean contains(int[] inits, int c) {
        if (inits == null) {
            return false;
        }
        for (int i = 0; i < inits.length; ++i) {
            if (inits[i] != c) continue;
            return true;
        }
        return false;
    }

    private boolean calcDisaggSsf(DataBlock yc, Matrix Xc) {
        SsfFunction<SsfDisaggregation> fn;
        SarimaModel arima = this.arima0_.clone();
        SsfArima ssf = new SsfArima(arima);
        SsfDisaggregation disagg = new SsfDisaggregation(this.c_, ssf);
        SsfModel<SsfDisaggregation<SsfArima>> model = new SsfModel<SsfDisaggregation<SsfArima>>(disagg, new SsfData(yc, null), Xc != null ? Xc.subMatrix() : null, null);
        SsfAlgorithm alg = new SsfAlgorithm();
        DisaggregationMapping mapping = new DisaggregationMapping();
        this.fn_ = fn = new SsfFunction<SsfDisaggregation>(model, mapping, alg, false, true);
        if (!this.spec_.getArima().hasFreeParameters()) {
            this.arima_ = this.arima0_.clone();
            SsfFunctionInstance rslt = (SsfFunctionInstance)fn.evaluate(mapping.map(disagg));
            this.ll_ = rslt.getLikelihood().toConcentratedLikelihood();
        } else {
            IFunctionMinimizer min = this.minimizer();
            boolean converged = min.minimize(fn, fn.evaluate(mapping.map(disagg)));
            SsfFunctionInstance rslt = (SsfFunctionInstance)min.getResult();
            disagg = (SsfDisaggregation)rslt.ssf;
            ssf = (SsfArima)disagg.getInternalSsf();
            this.arima_ = (SarimaModel)ssf.getModel();
            this.ll_ = rslt.getLikelihood().toConcentratedLikelihood();
        }
        return true;
    }

    private void ssfInterpolate(SsfArima model, DataBlock yc, Matrix Xc) {
        Smoother smoother = new Smoother();
        smoother.setCalcVar(true);
        smoother.setSsf(model);
        SmoothingResults srslts = new SmoothingResults();
        if (!smoother.process(new SsfData(this.calcYc(yc, Xc), null), srslts)) {
            return;
        }
        int n = yc.getLength();
        double[] yl = new double[n];
        double[] vyl = new double[n];
        double sig = this.ll_.getSigma();
        for (int i = 0; i < n; ++i) {
            yl[i] = model.ZX(i, srslts.A(i));
            vyl[i] = sig * model.ZVZ(i, srslts.P(i));
        }
        if (Xc != null) {
            Matrix Xl = new Matrix(n, Xc.getColumnsCount());
            DataBlockIterator xccols = Xc.columns();
            DataBlockIterator xlcols = Xl.columns();
            DataBlock xccol = xccols.getData();
            DataBlock xlcol = xlcols.getData();
            DisturbanceSmoother dsm = new DisturbanceSmoother();
            dsm.setSsf(model);
            DiffuseFilteringResults dfrslts = smoother.getFilteringResults();
            double[] tmp = new double[n];
            do {
                xccol.copyTo(tmp, 0);
                dfrslts.getVarianceFilter().process(dfrslts.getFilteredData(), 0, tmp, null);
                if (!dsm.process(new SsfData(tmp, null), dfrslts)) {
                    return;
                }
                srslts = dsm.calcSmoothedStates();
                for (int i = 0; i < n; ++i) {
                    xlcol.set(i, model.ZX(i, srslts.A(i)));
                }
            } while (xccols.next() && xlcols.next());
            DataBlock rcy = new DataBlock(yl);
            DataBlockIterator xcols = this.X_.columns();
            DataBlock xcol = xcols.getData();
            DataBlock b = new DataBlock(this.ll_.getB());
            do {
                rcy.addAY(b.get(xcols.getPosition()), xcol);
            } while (xcols.next());
            DataBlockIterator xrows = this.X_.rows();
            DataBlockIterator xlrows = Xl.rows();
            DataBlock xrow = xrows.getData();
            DataBlock xlrow = xlrows.getData();
            Matrix bvar = this.ll_.getBVar();
            do {
                xlrow.sub(xrow);
                int n2 = xlrows.getPosition();
                vyl[n2] = vyl[n2] + SymmetricMatrix.quadraticForm(bvar, xlrow);
            } while (xrows.next() && xlrows.next());
        }
        DescriptiveStatistics ds = new DescriptiveStatistics(yl);
        for (int i = 0; i < vyl.length; ++i) {
            vyl[i] = vyl[i] < ds.getVar() * 1.0E-12 ? 0.0 : Math.sqrt(vyl[i]);
        }
        this.si_ = new TsData(this.edomain_.getStart(), yl, false);
        this.esi_ = new TsData(this.edomain_.getStart(), vyl, false);
    }

    private void ssfInterpolate() {
        DataBlock yc = this.buildSsfY();
        Matrix Xc = this.buildSsfX();
        SsfArima ssf = new SsfArima(this.arima_);
        if (this.spec_.getBasic().getDataType() == DataType.Flow) {
            SsfDisaggregation<SsfArima> disagg = new SsfDisaggregation<SsfArima>(this.c_, ssf);
            this.ssfInterpolate(disagg, yc, Xc);
        } else {
            this.ssfInterpolate(ssf, yc, Xc);
        }
    }

    private void ssfInterpolate(SsfDisaggregation model, DataBlock yc, Matrix Xc) {
        Object issf = model.getInternalSsf();
        int dim = model.getStateDim();
        Smoother smoother = new Smoother();
        smoother.setCalcVar(true);
        smoother.setSsf(model);
        SmoothingResults srslts = new SmoothingResults();
        DataBlock ycc = this.calcYc(yc, Xc);
        if (!smoother.process(new SsfData(ycc, null), srslts)) {
            return;
        }
        int n = yc.getLength();
        double[] yl = new double[n];
        double[] vyl = new double[n];
        double sig = this.ll_.getSigma();
        for (int i = 0; i < n; ++i) {
            yl[i] = issf.ZX(i, srslts.A(i).drop(1, 0));
            vyl[i] = sig * issf.ZVZ(i, srslts.P(i).extract(1, dim, 1, dim));
        }
        if (Xc != null) {
            Matrix Xl = new Matrix(n, Xc.getColumnsCount());
            DataBlockIterator xccols = Xc.columns();
            DataBlockIterator xlcols = Xl.columns();
            DataBlock xccol = xccols.getData();
            DataBlock xlcol = xlcols.getData();
            DisturbanceSmoother dsm = new DisturbanceSmoother();
            dsm.setSsf(model);
            DiffuseFilteringResults dfrslts = smoother.getFilteringResults();
            double[] tmp = new double[n];
            do {
                xccol.copyTo(tmp, 0);
                dfrslts.getVarianceFilter().process(dfrslts.getFilteredData(), 0, tmp, null);
                if (!dsm.process(new SsfData(tmp, null), dfrslts)) {
                    return;
                }
                srslts = dsm.calcSmoothedStates();
                for (int i = 0; i < n; ++i) {
                    xlcol.set(i, issf.ZX(i, srslts.A(i).drop(1, 0)));
                }
            } while (xccols.next() && xlcols.next());
            DataBlock rcy = new DataBlock(yl);
            DataBlockIterator xcols = this.X_.columns();
            DataBlock xcol = xcols.getData();
            DataBlock b = new DataBlock(this.ll_.getB());
            do {
                rcy.addAY(b.get(xcols.getPosition()), xcol);
            } while (xcols.next());
            DataBlockIterator xrows = this.X_.rows();
            DataBlockIterator xlrows = Xl.rows();
            DataBlock xrow = xrows.getData();
            DataBlock xlrow = xlrows.getData();
            Matrix bvar = this.ll_.getBVar();
            do {
                xlrow.sub(xrow);
                int n2 = xlrows.getPosition();
                vyl[n2] = vyl[n2] + SymmetricMatrix.quadraticForm(bvar, xlrow);
            } while (xrows.next() && xlrows.next());
        }
        DescriptiveStatistics ds = new DescriptiveStatistics(yl);
        for (int i = 0; i < vyl.length; ++i) {
            vyl[i] = vyl[i] < ds.getVar() * 1.0E-12 ? 0.0 : Math.sqrt(vyl[i]);
        }
        this.si_ = new TsData(this.edomain_.getStart(), yl, false);
        this.esi_ = new TsData(this.edomain_.getStart(), vyl, false);
    }

    private DataBlock calcYc(DataBlock y, Matrix Xc) {
        if (Xc != null) {
            DataBlock yc = y.deepClone();
            DataBlockIterator cols = Xc.columns();
            DataBlock col = cols.getData();
            double[] b = this.ll_.getB();
            do {
                yc.addAY(-b[cols.getPosition()], col);
            } while (cols.next());
            return yc;
        }
        return y;
    }

    private boolean calcSsf(DataBlock yc, Matrix Xc) {
        SsfFunction<SsfArima> fn;
        SarimaModel arima = this.arima0_.clone();
        SsfArima ssf = new SsfArima(arima);
        SsfModel<SsfArima> model = new SsfModel<SsfArima>(ssf, new SsfData(yc, null), Xc != null ? Xc.subMatrix() : null, null);
        SsfAlgorithm alg = new SsfAlgorithm();
        Mapping mapping = new Mapping();
        this.fn_ = fn = new SsfFunction<SsfArima>(model, mapping, alg);
        IFunctionMinimizer min = this.minimizer();
        boolean converged = min.minimize(fn, fn.evaluate(mapping.map(ssf)));
        SsfFunctionInstance rslt = (SsfFunctionInstance)min.getResult();
        ssf = (SsfArima)rslt.ssf;
        this.arima_ = (SarimaModel)ssf.getModel();
        this.ll_ = rslt.getLikelihood().toConcentratedLikelihood();
        this.ssfInterpolate(ssf, yc, Xc);
        return true;
    }

    private boolean calcMcElroy(DataBlock y) {
        SarimaModel arima = this.arima0_.clone();
        ModelProvider provider = new ModelProvider(y, this.J_, this.X_, arima);
        SarimaMapping mapping = new SarimaMapping(arima.getSpecification(), true);
        DifferenceStationaryModelHelper.LikelihoodFunction<ModelProvider> fn = new DifferenceStationaryModelHelper.LikelihoodFunction<ModelProvider>(provider, mapping);
        fn.setLCompute(this.spec_.getEstimate().getMethod() == EstimateSpec.Method.Cholesky);
        this.fn_ = fn;
        if (!this.spec_.getArima().hasFreeParameters()) {
            DifferenceStationaryModelHelper.LikelihoodFunctionInstance rslt = (DifferenceStationaryModelHelper.LikelihoodFunctionInstance)fn.evaluate(mapping.map(arima));
            this.arima_ = this.arima0_.clone();
            this.ll_ = rslt.getLikelihood();
        } else {
            IFunctionMinimizer min = this.minimizer();
            boolean converged = min.minimize(fn, fn.evaluate(mapping.map(arima)));
            DifferenceStationaryModelHelper.LikelihoodFunctionInstance rslt = (DifferenceStationaryModelHelper.LikelihoodFunctionInstance)min.getResult();
            this.arima_ = mapping.map(rslt.getParameters());
            this.ll_ = rslt.getLikelihood();
        }
        return true;
    }

    private void matrixInterpolation() {
        DifferenceStationaryModelHelper.LikelihoodFunction fn = (DifferenceStationaryModelHelper.LikelihoodFunction)this.fn_;
        Matrix proj = fn.getHelper().computeProjections(null, ((ModelProvider)fn.getModelProvider()).getStationnaryCovariance(this.arima_.getParameters()));
        if (proj != null) {
            this.si_ = new TsData(this.edomain_.getStart(), proj.column(0));
            this.esi_ = new TsData(this.edomain_.getStart(), proj.subDiagonal(1)).sqrt();
        }
    }

    private IFunctionMinimizer minimizer() {
        LevenbergMarquardtMethod lm = new LevenbergMarquardtMethod();
        lm.setConvergenceCriterion(this.spec_.getEstimate().getTol());
        return new ProxyMinimizer(lm);
    }

    static class ModelProvider
    implements DifferenceStationaryModelHelper.IModelProviderEx {
        private final DataBlock y_;
        private final Matrix J_;
        private final Matrix X_;
        private final SarimaModel starima_;
        private final BackFilter diff_;

        ModelProvider(DataBlock y, Matrix J, Matrix X, SarimaModel arima) {
            this.y_ = y;
            this.J_ = J;
            this.X_ = X;
            StationaryTransformation sf = arima.stationaryTransformation();
            this.starima_ = (SarimaModel)sf.stationaryModel;
            this.diff_ = sf.unitRoots;
        }

        @Override
        public Matrix getStationnaryCovariance(IReadDataBlock parameters) {
            SarimaModel tmp = this.starima_.clone();
            tmp.setParameters(parameters);
            return tmp.covariance(this.J_.getColumnsCount() - this.diff_.getDegree());
        }

        @Override
        public BackFilter getDifferencing() {
            return this.diff_;
        }

        @Override
        public Matrix getTransformation() {
            return this.J_;
        }

        @Override
        public DataBlock getTransformedData() {
            return this.y_;
        }

        @Override
        public Matrix getDesignMatrix() {
            return this.X_;
        }

        @Override
        public Matrix getLCholesky(IReadDataBlock parameters, Matrix B) {
            SarimaModel tmp = this.starima_.clone();
            tmp.setParameters(parameters);
            int n = B.getColumnsCount();
            int m = B.getRowsCount();
            AnsleyFilter filter = new AnsleyFilter();
            filter.initialize(tmp, n);
            Matrix L = filter.getCholeskyFactor();
            Matrix Bt = B.transpose();
            DataBlockIterator rows = Bt.columns();
            DataBlock row = rows.getData();
            Polynomial P = tmp.getStationaryAR().getPolynomial();
            if (P.getDegree() > 0) {
                do {
                    this.ptransform(row, P, P.getDegree());
                } while (rows.next());
                rows.begin();
            }
            do {
                this.ltransform(row, L);
            } while (rows.next());
            ElementaryTransformations.fastGivensTriangularize(Bt.subMatrix().transpose());
            return new Matrix(Bt.subMatrix(0, m, 0, m).transpose());
        }

        private void ptransform(DataBlock b, Polynomial p, int n) {
            double z;
            int l;
            int d = p.getDegree();
            for (l = b.getLength(); l > d && b.get(l - 1) == 0.0; --l) {
            }
            DataBlock w = new DataBlock(p.rextract(1, d));
            int i = 1;
            int j = l - 1;
            while (i < d) {
                z = b.range(j, l).dot(w.range(0, i));
                b.add(j - 1, -z);
                ++i;
                --j;
            }
            for (int j2 = l - d; j2 > n; --j2) {
                double z2 = b.range(j2, j2 + d).dot(w);
                b.add(j2 - 1, -z2);
            }
            i = 0;
            j = n;
            while (j > n - d) {
                z = b.range(n, n + d - i).dot(w.range(i, d));
                b.add(j - 1, -z);
                --j;
                ++i;
            }
        }

        private void ltransform(DataBlock b, Matrix L) {
            int i;
            int n;
            int k = L.getRowsCount();
            for (n = b.getLength(); n > k && b.get(n - 1) == 0.0; --n) {
            }
            DataBlock bc = b.range(0, k);
            for (i = 0; i < n - k; ++i) {
                b.set(i, L.column(i).dot(bc));
                bc.move(1);
            }
            i = n - k;
            int j = 0;
            while (i < n) {
                b.set(i, L.column(i).drop(0, j).dot(bc));
                bc.bshrink();
                ++i;
                ++j;
            }
        }
    }

    private class DisaggregationMapping
    implements IParametricMapping<SsfDisaggregation> {
        private final SarimaMapping internalMapping;
        private final int c;

        public DisaggregationMapping() {
            TsFrequency lf = MixedFrequenciesMonitor.this.ls_.getFrequency();
            TsFrequency hf = MixedFrequenciesMonitor.this.hs_.getFrequency();
            this.c = hf.ratio(lf);
            this.internalMapping = new SarimaMapping(MixedFrequenciesMonitor.this.spec_.getArima().getSpecification(hf.intValue()), true);
        }

        @Override
        public SsfDisaggregation map(IReadDataBlock p) {
            SarimaModel arima = this.internalMapping.map(p);
            return new SsfDisaggregation<SsfArima>(this.c, new SsfArima(arima));
        }

        @Override
        public IReadDataBlock map(SsfDisaggregation t) {
            SsfArima ssf = (SsfArima)t.getInternalSsf();
            SarimaModel arima = (SarimaModel)ssf.getModel();
            return this.internalMapping.map(arima);
        }

        @Override
        public boolean checkBoundaries(IReadDataBlock inparams) {
            return this.internalMapping.checkBoundaries(inparams);
        }

        @Override
        public double epsilon(IReadDataBlock inparams, int idx) {
            return this.internalMapping.epsilon(inparams, idx);
        }

        @Override
        public int getDim() {
            return this.internalMapping.getDim();
        }

        @Override
        public double lbound(int idx) {
            return this.internalMapping.lbound(idx);
        }

        @Override
        public double ubound(int idx) {
            return this.internalMapping.ubound(idx);
        }

        @Override
        public ParamValidation validate(IDataBlock ioparams) {
            return this.internalMapping.validate(ioparams);
        }

        @Override
        public String getDescription(int idx) {
            return this.internalMapping.getDescription(idx);
        }
    }

    private class Mapping
    implements IParametricMapping<SsfArima> {
        private final SarimaMapping internalMapping;
        private final int c;

        public Mapping() {
            TsFrequency lf = MixedFrequenciesMonitor.this.ls_.getFrequency();
            TsFrequency hf = MixedFrequenciesMonitor.this.hs_.getFrequency();
            this.c = hf.ratio(lf);
            this.internalMapping = new SarimaMapping(MixedFrequenciesMonitor.this.spec_.getArima().getSpecification(hf.intValue()), true);
        }

        @Override
        public SsfArima map(IReadDataBlock p) {
            SarimaModel arima = this.internalMapping.map(p);
            return new SsfArima(arima);
        }

        @Override
        public IReadDataBlock map(SsfArima t) {
            SarimaModel arima = (SarimaModel)t.getModel();
            return this.internalMapping.map(arima);
        }

        @Override
        public boolean checkBoundaries(IReadDataBlock inparams) {
            return this.internalMapping.checkBoundaries(inparams);
        }

        @Override
        public double epsilon(IReadDataBlock inparams, int idx) {
            return this.internalMapping.epsilon(inparams, idx);
        }

        @Override
        public int getDim() {
            return this.internalMapping.getDim();
        }

        @Override
        public double lbound(int idx) {
            return this.internalMapping.lbound(idx);
        }

        @Override
        public double ubound(int idx) {
            return this.internalMapping.ubound(idx);
        }

        @Override
        public ParamValidation validate(IDataBlock ioparams) {
            return this.internalMapping.validate(ioparams);
        }

        @Override
        public String getDescription(int idx) {
            return this.internalMapping.getDescription(idx);
        }
    }
}

