/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.multivariate.AbstractMultivariateSsf;
import ec.tstoolkit.ssf.multivariate.IMSsfData;
import ec.tstoolkit.ssf.multivariate.IMultivariateSsf;
import ec.tstoolkit.ssf.multivariate.INoiseProvider;
import ec.tstoolkit.ssf.multivariate.MultivariateSsfData;

public class RichMultivariateSsf {
    private final IMultivariateSsf ssf_;
    private final MatrixStorage X_;
    private final MatrixStorage W_;
    private final DataBlockStorage k_;
    private final INoiseProvider e_;
    private final int nv_;
    private final int ndim_;
    private final int nx_;
    private final int nw_;
    private final int ne_;
    private DataBlockStorage l_;
    private DataBlockStorage yc_;
    private MatrixStorage V_;
    private MatrixStorage Xc_;

    public RichMultivariateSsf(IMultivariateSsf ssf, INoiseProvider e, MatrixStorage X, MatrixStorage W, DataBlockStorage k) {
        this.ssf_ = ssf;
        this.e_ = e;
        this.X_ = X;
        this.W_ = W;
        this.k_ = k;
        this.ndim_ = this.ssf_.getStateDim();
        this.nv_ = ssf.getVarsCount();
        this.nx_ = this.X_ == null ? 0 : this.X_.getMatrixColumnsCount();
        this.nw_ = this.W_ == null ? 0 : this.W_.getMatrixColumnsCount();
        this.ne_ = this.e_ == null ? 0 : this.nv_;
        this.cumul();
    }

    private void cumul() {
        int i;
        int n;
        if (this.W_ != null) {
            n = this.W_.getCapacity();
            this.V_ = new MatrixStorage(this.ndim_, this.nw_, n);
            this.Xc_ = new MatrixStorage(this.nv_, this.nw_, n);
            SubMatrix v0 = this.V_.matrix(0);
            v0.copy(this.W_.matrix(0));
            this.ssf_.ZM(0, v0, this.Xc_.matrix(0));
            for (i = 1; i < n; ++i) {
                SubMatrix vi = this.V_.matrix(i);
                vi.copy(this.V_.matrix(i - 1));
                this.ssf_.TM(i, vi);
                vi.add(this.W_.matrix(i));
                this.ssf_.ZM(i, vi, this.Xc_.matrix(i));
            }
        }
        if (this.k_ != null) {
            n = this.k_.getCapacity();
            this.yc_ = new DataBlockStorage(this.nv_, n);
            this.l_ = new DataBlockStorage(this.ndim_, n);
            DataBlock l0 = this.l_.block(0);
            l0.copy(this.k_.block(0));
            this.ssf_.ZX(0, l0, this.yc_.block(0));
            for (i = 1; i < n; ++i) {
                DataBlock li = this.l_.block(i);
                li.copy(this.k_.block(i - 1));
                this.ssf_.TX(i, li);
                li.add(this.k_.block(i));
                this.ssf_.ZX(i, li, this.yc_.block(i));
            }
        }
    }

    public IMultivariateSsf toSsf() {
        return new SsfRepresentation();
    }

    public IMSsfData adapt(IMSsfData data) {
        int c;
        double[] initialState = data.getInitialState();
        int nr = data.getVarsCount();
        int nc = data.count(0);
        for (int i = 1; i < nr; ++i) {
            c = data.count(i);
            if (c == nc) continue;
            return null;
        }
        Matrix m = new Matrix(nr, nc);
        for (c = 0; c < nc; ++c) {
            for (int r = 0; r < nr; ++r) {
                m.set(r, c, data.get(r, c));
            }
            m.column(c).sub(this.yc_.block(c));
        }
        return new MultivariateSsfData(m, initialState);
    }

    private class SsfRepresentation
    extends AbstractMultivariateSsf {
        private final DataBlock tmp0_;
        private final DataBlock tmp1_;

        private SsfRepresentation() {
            int dim = RichMultivariateSsf.this.ndim_ + RichMultivariateSsf.this.nx_ + RichMultivariateSsf.this.nw_ + RichMultivariateSsf.this.ne_;
            this.tmp0_ = new DataBlock(dim);
            this.tmp1_ = new DataBlock(dim);
        }

        @Override
        public int getVarsCount() {
            return RichMultivariateSsf.this.ssf_.getVarsCount();
        }

        @Override
        public boolean hasZ(int pos, int v) {
            return true;
        }

        @Override
        public void VpZdZ(int pos, int v, int w, SubMatrix vm, double d) {
            this.tmp0_.set(0.0);
            this.Z(pos, v, this.tmp0_);
            if (v != w) {
                this.tmp1_.set(0.0);
                this.Z(pos, w, this.tmp1_);
            } else {
                this.tmp1_.copy(this.tmp0_);
            }
            DataBlockIterator cols = vm.columns();
            DataBlock col = cols.getData();
            do {
                double k = d * this.tmp0_.get(cols.getPosition());
                col.addAY(k, this.tmp1_);
            } while (cols.next());
        }

        @Override
        public void XpZd(int pos, int v, DataBlock x, double d) {
            int n0 = 0;
            int n1 = RichMultivariateSsf.this.ndim_;
            RichMultivariateSsf.this.ssf_.XpZd(pos, v, x.range(n0, n1), d);
            n0 = n1;
            if (RichMultivariateSsf.this.ne_ > 0) {
                x.range(n0, n1 += RichMultivariateSsf.this.ne_).add(d);
                n0 = n1;
            }
            if (RichMultivariateSsf.this.nx_ > 0) {
                x.range(n0, n1 += RichMultivariateSsf.this.nx_).addAY(d, RichMultivariateSsf.this.X_.matrix(pos).row(v));
                n0 = n1;
            }
            if (RichMultivariateSsf.this.nw_ > 0) {
                x.range(n0, n1 += RichMultivariateSsf.this.nw_).addAY(d, RichMultivariateSsf.this.Xc_.matrix(pos).row(v));
            }
        }

        @Override
        public void Z(int pos, int v, DataBlock z) {
            int n0 = 0;
            int n1 = RichMultivariateSsf.this.ndim_;
            RichMultivariateSsf.this.ssf_.Z(pos, v, z.range(n0, n1));
            n0 = n1;
            if (RichMultivariateSsf.this.ne_ > 0) {
                z.range(n0, n1 += RichMultivariateSsf.this.ne_).set(1.0);
                n0 = n1;
            }
            if (RichMultivariateSsf.this.nx_ > 0) {
                z.range(n0, n1 += RichMultivariateSsf.this.nx_).copy(RichMultivariateSsf.this.X_.matrix(pos).row(v));
                n0 = n1;
            }
            if (RichMultivariateSsf.this.nw_ > 0) {
                z.range(n0, n1 += RichMultivariateSsf.this.nw_).copy(RichMultivariateSsf.this.Xc_.matrix(pos).row(v));
            }
        }

        @Override
        public double ZVZ(int pos, int v, int w, SubMatrix vm) {
            this.ZM(pos, v, vm, this.tmp0_);
            return this.ZX(pos, w, this.tmp0_);
        }

        @Override
        public double ZX(int pos, int v, DataBlock x) {
            int n0 = 0;
            int n1 = RichMultivariateSsf.this.ndim_;
            double zx = RichMultivariateSsf.this.ssf_.ZX(pos, v, x.range(n0, n1));
            n0 = n1;
            if (RichMultivariateSsf.this.ne_ > 0) {
                zx += x.range(n0, n1 += RichMultivariateSsf.this.ne_).sum();
                n0 = n1;
            }
            if (RichMultivariateSsf.this.nx_ > 0) {
                zx += x.range(n0, n1 += RichMultivariateSsf.this.nx_).dot(RichMultivariateSsf.this.X_.matrix(pos).row(v));
                n0 = n1;
            }
            if (RichMultivariateSsf.this.nw_ > 0) {
                zx += x.range(n0, n1 += RichMultivariateSsf.this.nw_).dot(RichMultivariateSsf.this.Xc_.matrix(pos).row(v));
            }
            return zx;
        }

        @Override
        public void diffuseConstraints(SubMatrix b) {
            int nd = RichMultivariateSsf.this.ssf_.getNonStationaryDim();
            if (nd > 0) {
                RichMultivariateSsf.this.ssf_.diffuseConstraints(b.extract(0, RichMultivariateSsf.this.ndim_, 0, nd));
            }
            for (int i = 0; i < RichMultivariateSsf.this.nx_ + RichMultivariateSsf.this.nw_; ++i) {
                b.set(RichMultivariateSsf.this.ndim_ + i, nd + i, 1.0);
            }
        }

        @Override
        public void fullQ(int pos, SubMatrix qm) {
            RichMultivariateSsf.this.ssf_.fullQ(pos, qm.extract(0, RichMultivariateSsf.this.ndim_, 0, RichMultivariateSsf.this.ndim_));
            if (RichMultivariateSsf.this.e_ != null) {
                int e0 = RichMultivariateSsf.this.ndim_;
                int e1 = e0 + RichMultivariateSsf.this.ne_;
                RichMultivariateSsf.this.e_.e(pos, qm.extract(e0, e1, e0, e1));
            }
        }

        @Override
        public int getNonStationaryDim() {
            return RichMultivariateSsf.this.ssf_.getNonStationaryDim() + RichMultivariateSsf.this.nx_ + RichMultivariateSsf.this.nw_;
        }

        @Override
        public int getStateDim() {
            return RichMultivariateSsf.this.ndim_ + RichMultivariateSsf.this.nx_ + RichMultivariateSsf.this.nw_ + RichMultivariateSsf.this.ne_;
        }

        @Override
        public int getTransitionResCount() {
            return RichMultivariateSsf.this.ssf_.getTransitionResCount() + RichMultivariateSsf.this.ne_;
        }

        @Override
        public int getTransitionResDim() {
            return RichMultivariateSsf.this.ssf_.getTransitionResDim() + RichMultivariateSsf.this.ne_;
        }

        @Override
        public boolean hasR() {
            return RichMultivariateSsf.this.nx_ > 0 || RichMultivariateSsf.this.nw_ > 0 || RichMultivariateSsf.this.ssf_.hasR();
        }

        @Override
        public boolean hasTransitionRes(int pos) {
            return RichMultivariateSsf.this.ne_ > 0 || RichMultivariateSsf.this.ssf_.hasTransitionRes(pos);
        }

        @Override
        public boolean hasW() {
            return RichMultivariateSsf.this.ssf_.hasW();
        }

        @Override
        public boolean isDiffuse() {
            return RichMultivariateSsf.this.nx_ > 0 || RichMultivariateSsf.this.nw_ > 0 || RichMultivariateSsf.this.ssf_.isDiffuse();
        }

        @Override
        public boolean isMeasurementEquationTimeInvariant() {
            return RichMultivariateSsf.this.ssf_.isMeasurementEquationTimeInvariant() && RichMultivariateSsf.this.nx_ == 0 && RichMultivariateSsf.this.nw_ == 0;
        }

        @Override
        public boolean isTimeInvariant() {
            return RichMultivariateSsf.this.ssf_.isTimeInvariant() && RichMultivariateSsf.this.nx_ == 0 && RichMultivariateSsf.this.nw_ == 0 && (RichMultivariateSsf.this.e_ == null || RichMultivariateSsf.this.e_.isTimeInvariant());
        }

        @Override
        public boolean isTransitionEquationTimeInvariant() {
            return RichMultivariateSsf.this.ssf_.isTransitionEquationTimeInvariant() && (RichMultivariateSsf.this.e_ == null || RichMultivariateSsf.this.e_.isTimeInvariant());
        }

        @Override
        public boolean isTransitionResidualTimeInvariant() {
            return RichMultivariateSsf.this.ssf_.isTransitionResidualTimeInvariant() && (RichMultivariateSsf.this.e_ == null || RichMultivariateSsf.this.e_.isTimeInvariant());
        }

        @Override
        public boolean isValid() {
            return RichMultivariateSsf.this.ssf_.isValid();
        }

        @Override
        public void Pf0(SubMatrix pf0) {
            RichMultivariateSsf.this.ssf_.Pf0(pf0.extract(0, RichMultivariateSsf.this.ndim_, 0, RichMultivariateSsf.this.ndim_));
        }

        @Override
        public void Pi0(SubMatrix pi0) {
            RichMultivariateSsf.this.ssf_.Pf0(pi0.extract(0, RichMultivariateSsf.this.ndim_, 0, RichMultivariateSsf.this.ndim_));
            if (RichMultivariateSsf.this.nx_ > 0 || RichMultivariateSsf.this.nw_ > 0) {
                pi0.diagonal().drop(RichMultivariateSsf.this.ndim_ + RichMultivariateSsf.this.ne_, 0).set(1.0);
            }
        }

        @Override
        public void Q(int pos, SubMatrix qm) {
            int n = RichMultivariateSsf.this.ssf_.getTransitionResDim();
            RichMultivariateSsf.this.ssf_.Q(pos, qm.extract(0, n, 0, n));
            if (RichMultivariateSsf.this.ne_ > 0) {
                RichMultivariateSsf.this.e_.e(pos, qm.extract(n, n + RichMultivariateSsf.this.ne_, n, n + RichMultivariateSsf.this.ne_));
            }
        }

        @Override
        public void R(int pos, SubArrayOfInt rv) {
            int i;
            int n;
            if (RichMultivariateSsf.this.ssf_.hasR()) {
                n = RichMultivariateSsf.this.ssf_.getTransitionResCount();
                RichMultivariateSsf.this.ssf_.R(pos, rv.range(0, n));
            } else {
                n = RichMultivariateSsf.this.ndim_;
                for (i = 0; i < n; ++i) {
                    rv.set(i, i);
                }
            }
            for (i = 0; i < RichMultivariateSsf.this.ne_; ++i) {
                rv.set(n + i, RichMultivariateSsf.this.ndim_ + i);
            }
        }

        @Override
        public void T(int pos, SubMatrix tr) {
            RichMultivariateSsf.this.ssf_.T(pos, tr.extract(0, RichMultivariateSsf.this.ndim_, 0, RichMultivariateSsf.this.ndim_));
            tr.diagonal().drop(RichMultivariateSsf.this.ndim_ + RichMultivariateSsf.this.ne_, 0).set(1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            RichMultivariateSsf.this.ssf_.TX(pos, x.range(0, RichMultivariateSsf.this.ndim_));
            if (RichMultivariateSsf.this.ne_ > 0) {
                x.range(RichMultivariateSsf.this.ndim_, RichMultivariateSsf.this.ndim_ + RichMultivariateSsf.this.ne_).set(0.0);
            }
        }

        @Override
        public void W(int pos, SubMatrix wv) {
            if (RichMultivariateSsf.this.ssf_.hasW()) {
                int r = RichMultivariateSsf.this.ssf_.getTransitionResCount();
                int c = RichMultivariateSsf.this.ssf_.getTransitionResDim();
                RichMultivariateSsf.this.ssf_.W(pos, wv.extract(0, r, 0, c));
                for (int i = 0; i < RichMultivariateSsf.this.ne_; ++i) {
                    wv.set(r + i, c + i, 1.0);
                }
            }
        }

        @Override
        public void XT(int pos, DataBlock x) {
            RichMultivariateSsf.this.ssf_.XT(pos, x.range(0, RichMultivariateSsf.this.ndim_));
            if (RichMultivariateSsf.this.ne_ > 0) {
                x.range(RichMultivariateSsf.this.ndim_, RichMultivariateSsf.this.ndim_ + RichMultivariateSsf.this.ne_).set(0.0);
            }
        }
    }
}

