/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.design;

import ec.tstoolkit.design.Singleton;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class InterfaceLoader {
    public static <T> T create(Class<T> interfaceType, String className) {
        if (className == null) {
            return null;
        }
        try {
            return InterfaceLoader.create(ClassLoader.getSystemClassLoader(), interfaceType, className);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T> T create(ClassLoader loader, Class<T> interfaceType, String className) {
        Class<?> tclass = null;
        try {
            tclass = loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        Singleton an = tclass.getAnnotation(Singleton.class);
        if (an != null) {
            String instance = an.name();
            try {
                Field field = tclass.getField(instance);
                Object obj = field.get(null);
                if (obj != null && interfaceType.isInstance(obj)) {
                    return (T)obj;
                }
            }
            catch (Exception field) {
                // empty catch block
            }
            String entry = an.entryPoint();
            try {
                Method method = tclass.getMethod(entry, new Class[0]);
                Object obj = method.invoke(null, new Object[0]);
                if (obj != null && interfaceType.isInstance(obj)) {
                    return (T)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Constructor<?> c = tclass.getConstructor(new Class[0]);
            Object obj = c.newInstance(new Object[0]);
            if (interfaceType.isInstance(obj)) {
                return (T)obj;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T create(String urlString, Class<T> interfaceType, String className) {
        if (className == null) {
            return null;
        }
        if (urlString == null) {
            return InterfaceLoader.create(interfaceType, className);
        }
        try {
            URL url = new URL(null, urlString);
            URLClassLoader loader = new URLClassLoader(new URL[]{url});
            return InterfaceLoader.create(loader, interfaceType, className);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

