/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.demetra;

import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.demetra.DemetraModule;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.DayClustering;
import ec.tstoolkit.timeseries.calendars.GenericTradingDays;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.GenericTradingDaysVariables;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class TradingDaysSelectionModule2
extends DemetraModule
implements IPreprocessingModule {
    private static final String REGS = "Regression variables";
    private static final double DEF_MODEL_EPS = 0.01;
    private static final double DEF_CONSTRAINT_EPS = 0.01;
    private static final GenericTradingDays[] DEF_TD = new GenericTradingDays[]{GenericTradingDays.contrasts(DayClustering.TD7), GenericTradingDays.contrasts(DayClustering.TD4), GenericTradingDays.contrasts(DayClustering.TD3), GenericTradingDays.contrasts(DayClustering.TD3c), GenericTradingDays.contrasts(DayClustering.TD2)};
    private static final double DEF_TVAL = 1.96;
    private final boolean fix;
    private final GenericTradingDays[] tdVars;
    private PreprocessingModel[] models;
    private Comparator<PreprocessingModel> comparator;
    private double tval = 1.96;
    private int choice;

    public TradingDaysSelectionModule2() {
        this.fix = false;
        this.tdVars = DEF_TD;
        this.comparator = (l1, l2) -> Double.compare(-l1.estimation.getStatistics().AIC, -l2.estimation.getStatistics().AIC);
    }

    public TradingDaysSelectionModule2(boolean fix, Comparator<PreprocessingModel> comparator) {
        this.fix = fix;
        this.tdVars = DEF_TD;
        this.comparator = comparator;
    }

    public TradingDaysSelectionModule2(boolean fix, GenericTradingDays[] td, Comparator<PreprocessingModel> comparator) {
        this.fix = fix;
        this.tdVars = td;
        this.comparator = comparator;
    }

    public double getTValue() {
        return this.tval;
    }

    public void setTvalue(double tval) {
        this.tval = tval;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        this.models = new PreprocessingModel[this.tdVars.length + 1];
        this.models[0] = this.refModel(context, this.tdVars[0], LengthOfPeriodType.LeapYear);
        for (int i = 1; i < this.tdVars.length; ++i) {
            this.models[i] = this.model(this.tdVars[i], LengthOfPeriodType.LeapYear);
        }
        this.models[this.tdVars.length] = this.model(null, LengthOfPeriodType.LeapYear);
        Optional<PreprocessingModel> max = Arrays.stream(this.models).max(this.comparator);
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] != max.get()) continue;
            this.choice = i;
            break;
        }
        GenericTradingDays best = this.choice == this.tdVars.length ? null : this.tdVars[this.choice];
        context.description = this.backModel(context, best, this.checkLY(max.get()) ? LengthOfPeriodType.LeapYear : LengthOfPeriodType.None);
        context.estimation = null;
        return ProcessingResult.Changed;
    }

    private PreprocessingModel refModel(ModellingContext context, GenericTradingDays td, LengthOfPeriodType lp) {
        ModelDescription model = context.description.clone();
        model.setAirline(context.hasseas);
        model.setMean(true);
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (td != null) {
            GenericTradingDaysVariables vars = new GenericTradingDaysVariables(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        ModellingContext cxt = new ModellingContext();
        cxt.description = model;
        ModelEstimation estimation = new ModelEstimation(model.buildRegArima());
        int nhp = model.getArimaComponent().getFreeParametersCount();
        estimation.compute(this.monitor(), nhp);
        cxt.estimation = estimation;
        return cxt.current(true);
    }

    private PreprocessingModel model(GenericTradingDays td, LengthOfPeriodType lp) {
        ModelDescription model = this.models[0].description.clone();
        model.removeVariable(var -> var.isCalendar());
        if (td != null) {
            GenericTradingDaysVariables vars = new GenericTradingDaysVariables(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        ModellingContext cxt = new ModellingContext();
        cxt.description = model;
        int nhp = model.getArimaComponent().getFreeParametersCount();
        if (this.fix) {
            ModelEstimation estimation = new ModelEstimation(model.buildRegArima());
            estimation.computeLikelihood(nhp);
            cxt.estimation = estimation;
        } else {
            RegArimaEstimation<SarimaModel> nmodel = this.monitor().optimize(model.buildRegArima());
            ModelEstimation estimation = new ModelEstimation(nmodel.model);
            estimation.computeLikelihood(nhp);
            cxt.estimation = estimation;
        }
        return cxt.current(true);
    }

    private ModelDescription backModel(ModellingContext context, GenericTradingDays td, LengthOfPeriodType lp) {
        ModelDescription model = context.description.clone();
        if (context.automodelling) {
            model.setMean(true);
        }
        model.setOutliers(null);
        model.removeVariable(var -> var.isCalendar());
        if (td != null) {
            GenericTradingDaysVariables vars = new GenericTradingDaysVariables(td);
            model.addVariable(Variable.calendarVariable(vars, RegStatus.Accepted));
        }
        if (lp != LengthOfPeriodType.None) {
            model.addVariable(Variable.calendarVariable(new LeapYearVariable(lp), RegStatus.Accepted));
        }
        return model;
    }

    private boolean checkLY(PreprocessingModel model) {
        boolean retval = true;
        ConcentratedLikelihood ll = model.estimation.getLikelihood();
        int start = model.description.getRegressionVariablesStartingPosition();
        TsVariableList x = model.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(ILengthOfPeriodVariable.class);
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        double[] Tstat = ll.getTStats(true, 2);
        double t = Tstat[start + items[items.length - 1].position];
        if (Math.abs(t) < this.tval) {
            retval = false;
        }
        return retval;
    }

    public int getChoice() {
        return this.choice;
    }

    public GenericTradingDays[] getTdVars() {
        return this.tdVars;
    }

    public PreprocessingModel[] getModels() {
        return this.models;
    }

    public LikelihoodStatistics[] statistics() {
        LikelihoodStatistics[] stats = new LikelihoodStatistics[this.models.length];
        for (int i = 0; i < this.models.length; ++i) {
            stats[i] = this.models[i] != null ? this.models[i].estimation.getStatistics() : null;
        }
        return stats;
    }
}

