/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.util.LoginDialog;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class Configuration {
    private static final String sourceClass = Configuration.class.getSimpleName();
    public static final String CONFIGURATION_FILE = "configuration.properties";
    private static final String CENTRAL_CONFIGURATION_FILE_PROP = "SDMX_CONF";
    private static final String PROXY_NAME = "http.proxy.name";
    private static final String PROXY_DEFAULT = "http.proxy.default";
    private static final String HTTP_AUTH_USER = "http.auth.user";
    private static final String PROXY_AUTH_PW = "http.auth.pw";
    private static final String REVERSE_DUMP_PROP = "reverse.dump";
    private static boolean REVERSE_DUMP = false;
    private static final String SDMX_LANG_PROP = "sdmx.lang";
    private static String SDMX_LANG = "en";
    private static final String SDMX_DEFAULT_LANG = "en";
    private static Properties props = new Properties();
    protected static final String LOGGER_NAME = "SDMX";
    protected static final String PROXY_AUTH_KERBEROS = "Kerberos";
    protected static final String PROXY_AUTH_DIGEST = "digest";
    protected static final String PROXY_AUTH_BASIC = "basic";
    protected static final String JAVA_SECURITY_KERBEROS_CONF = "java.security.krb5.conf";
    protected static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    protected static final String HTTP_AUTH_PREF = "http.auth.preference";
    protected static final String SSL_DISABLE_CERT_CHECK = "ssl.disable.cert.check";
    protected static final String SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    protected static Logger SDMX_LOGGER = null;

    protected static void setSdmxLogger() {
        if (SDMX_LOGGER == null) {
            SDMX_LOGGER = Logger.getLogger(LOGGER_NAME);
            LogManager.getLogManager().addLogger(SDMX_LOGGER);
        }
    }

    public static Logger getSdmxLogger() {
        Configuration.setSdmxLogger();
        return SDMX_LOGGER;
    }

    public static boolean isSSLCertificatesDisabled() {
        return props.getProperty(SSL_DISABLE_CERT_CHECK, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static boolean isReverse() {
        return REVERSE_DUMP;
    }

    public static String getLang() {
        return SDMX_LANG;
    }

    public static void setLang(String string) {
        SDMX_LANG = string;
    }

    public static void init() {
        Object object;
        Object object2;
        Object object3;
        Configuration.setSdmxLogger();
        System.setProperty("http.agent", LOGGER_NAME);
        String string = null;
        try {
            object3 = Class.forName("it.bancaditalia.oss.sdmx.util.SdmxConfiguration");
            object2 = ((Class)object3).getMethod("init", new Class[0]);
            ((Method)object2).invoke((Object)null, new Object[0]);
            string = ((Class)object3).getCanonicalName();
            SDMX_LOGGER.info("Reading " + string + " configuration.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = null;
        object2 = null;
        if (new File(CONFIGURATION_FILE).exists()) {
            try {
                object3 = new FileInputStream(CONFIGURATION_FILE);
                object2 = new FileInputStream(CONFIGURATION_FILE);
                Configuration.init((InputStream)object3, (InputStream)object2);
                string = System.getProperty("user.dir") + File.separator + CONFIGURATION_FILE;
                SDMX_LOGGER.info("Configuration file: " + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            object = System.getenv(CENTRAL_CONFIGURATION_FILE_PROP);
            if (object != null && !((String)object).isEmpty() && new File((String)object).exists()) {
                try {
                    object3 = new FileInputStream((String)object);
                    object2 = new FileInputStream((String)object);
                    Configuration.init((InputStream)object3, (InputStream)object2);
                    string = CENTRAL_CONFIGURATION_FILE_PROP;
                    SDMX_LOGGER.info("Configuration file: " + string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (string == null) {
            object = new ConsoleHandler();
            ((Handler)object).setLevel(Level.INFO);
            SDMX_LOGGER.addHandler((Handler)object);
            string = "default";
            SDMX_LOGGER.info("No configuration found. Apply defaults.");
        }
    }

    public static void init(InputStream inputStream, InputStream inputStream2) throws SecurityException, IOException {
        Configuration.setSdmxLogger();
        LogManager.getLogManager().readConfiguration(inputStream);
        inputStream.close();
        props.load(inputStream2);
        inputStream2.close();
        String string = props.getProperty(SSL_TRUSTSTORE);
        if (string != null && !string.isEmpty()) {
            System.setProperty(SSL_TRUSTSTORE, string);
        }
        SDMX_LANG = props.getProperty(SDMX_LANG_PROP, SDMX_DEFAULT_LANG);
        REVERSE_DUMP = props.getProperty(REVERSE_DUMP_PROP, "TRUE").equalsIgnoreCase("TRUE");
        Configuration.configureProxy(props);
    }

    private static void configureProxy(Properties properties) {
        String string;
        Object object;
        String string2;
        String[] stringArray;
        Logger logger = SDMX_LOGGER;
        logger.entering(sourceClass, "configureProxy");
        String string3 = properties.getProperty(PROXY_DEFAULT);
        String string4 = null;
        int n = 0;
        boolean bl = false;
        if (string3 != null && !string3.isEmpty()) {
            bl = true;
            stringArray = string3.split(":");
            if (stringArray.length != 2 || stringArray[0] == null || stringArray[0].isEmpty() || stringArray[1] == null || stringArray[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. found: '" + string3 + "'");
            }
            string4 = stringArray[0].trim();
            n = Integer.parseInt(stringArray[1].trim());
        }
        stringArray = new SdmxProxySelector(string4, n);
        int n2 = 0;
        while ((string2 = properties.getProperty(PROXY_NAME + n2)) != null && !string2.isEmpty()) {
            bl = true;
            object = null;
            object = string2.split(":");
            if (object == null || ((String[])object).length != 2 || object[0] == null || object[0].isEmpty() || object[1] == null || object[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + object[0] + "', port: '" + object[1] + "'");
            }
            string = properties.getProperty(PROXY_NAME + n2 + ".urls");
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + (String)object[0] + "', port: '" + (String)object[1] + "'" + ", urls: " + string);
            }
            String[] stringArray2 = string.split(",");
            stringArray.addProxy((String)object[0], (String)object[1], stringArray2);
            logger.finer("Proxy has been configured: '" + string2 + "' for " + string);
            ++n2;
        }
        if (bl) {
            ProxySelector.setDefault((ProxySelector)stringArray);
        }
        if (properties != null && bl) {
            String string5 = properties.getProperty(HTTP_AUTH_PREF);
            if (string5 != null) {
                string5 = string5.trim();
                System.setProperty(HTTP_AUTH_PREF, string5);
                logger.finer(string5 + " authentication enabled.");
                if (string5.equalsIgnoreCase(PROXY_AUTH_KERBEROS)) {
                    string2 = properties.getProperty(JAVA_SECURITY_KERBEROS_CONF);
                    object = properties.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
                    string = System.getenv().get("KRB5CCNAME");
                    if (string != null && object != null && string2 != null) {
                        string = string.trim();
                        object = ((String)object).trim();
                        string2 = string2.trim();
                        System.setProperty("user.krb5cc", string);
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                        System.setProperty(JAVA_SECURITY_KERBEROS_CONF, string2);
                        System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, (String)object);
                        logger.finer("java.security.krb5.conf = " + string2);
                        logger.finer("java.security.auth.login.config = " + (String)object);
                        logger.finer("Environment variable KRB5CCNAME = " + string);
                    } else {
                        logger.warning("Kerberos ticket cache not configured because one of the parameters is not set.");
                        logger.warning("java.security.krb5.conf = " + string2);
                        logger.warning("java.security.auth.login.config = " + (String)object);
                        logger.warning("Environment variable KRB5CCNAME = " + string);
                    }
                } else if (string5.equalsIgnoreCase(PROXY_AUTH_BASIC)) {
                    string2 = properties.getProperty(HTTP_AUTH_USER);
                    object = properties.getProperty(PROXY_AUTH_PW);
                    Configuration.setCredentials(string5, string2, (String)object);
                } else {
                    logger.finer("Authentication type not supported: " + string5);
                }
            } else {
                logger.finer("No authentication enabled.");
            }
        }
        logger.exiting(sourceClass, "configureProxy");
    }

    private static void setCredentials(String string, String string2, String string3) {
        Object object;
        Object object2;
        System.setProperty(HTTP_AUTH_PREF, string);
        if (string2 == null || string3 == null) {
            object2 = new JFrame("Proxy Authentication");
            ((JFrame)object2).setDefaultCloseOperation(2);
            object = new LoginDialog((Frame)object2, "Proxy Authentication");
            ((Dialog)object).setVisible(true);
            string2 = ((LoginDialog)object).getUsername();
            string3 = ((LoginDialog)object).getPassword();
            ((Window)object2).dispose();
        }
        object2 = string2.trim();
        object = string3.trim();
        Authenticator.setDefault(new Authenticator((String)object2, (String)object){
            final /* synthetic */ String val$user;
            final /* synthetic */ String val$pw;
            {
                this.val$user = string;
                this.val$pw = string2;
            }

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                Logger logger = SDMX_LOGGER;
                logger.entering(sourceClass, "getPasswordAuthentication");
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.val$user, this.val$pw.toCharArray());
                logger.finer("Requesting Host  : " + this.getRequestingHost());
                logger.finer("Requesting Port  : " + this.getRequestingPort());
                logger.finer("Requesting Protocol: " + this.getRequestingProtocol());
                logger.finer("Requesting Scheme : " + this.getRequestingScheme());
                logger.entering(sourceClass, "getPasswordAuthentication");
                return passwordAuthentication;
            }
        });
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }
}

