% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset07}
\alias{dataset07}
\title{Lucy Warren FROC dataset}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:5, 1:7, 1:162, 1:4], of non-lesion localizations, NLs}
\item{\code{LL}}{ Ratings array [1:5, 1:7, 1:81, 1:3], of lesion localizations, LLs}
\item{\code{lesionNum}}{ array [1:81], number of lesions per diseased case, all set to 1}
\item{\code{lesionID}}{ array [1:81, 1:3], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:81, 1:3] weights (or clinical importance) of lesions, all set to 1}
\item{\code{dataType}}{ "FROC", the data type}
\item{\code{modalityID}}{ [1:5] "1" "2", ..., treatment labels}
\item{\code{readerID}}{ [1:7] "1" "2" ..., reader labels}
}}
\usage{
dataset07
}
\description{
This is referred to in the book as the "OPT" dataset (for OptiMam). It consists of 162 cases, 
81 of which are diseased, interpreted in five treatments (see reference, basically different ways
of acquiring the images) by seven radiologists using the FROC paradigm.
}
\examples{
str(dataset07)
PlotEmpiricalOperatingCharacteristics(dataset = dataset07, opChType = "wAFROC")$Plot


}
\references{
Warren LM, Mackenzie A, Cooke J, et al. Effect of image quality on 
calcification detection in digital mammography. 
Medical Physics. 2012;39(6):3202-3213.
}
\keyword{datasets}
