% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset09}
\alias{dataset09}
\title{Nico Karssemeijer ROC dataset (CAD vs. radiologists)}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1, 1:10, 1:200, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1, 1:10, 1:80, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:80], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:80, 1], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:80, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset09", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "NICO-CAD-ROC", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1, 1:10, 1:200, 1:2], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr "1", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:10] "1" "2" "3" "4" ..., reader labels}
}
}
\usage{
dataset09
}
\description{
This is referred to in the book as the "NICO" dataset. It consists of 200 mammograms, 
80 of which contain one malignant mass, 
interpreted by a CAD system and nine radiologists using the 
LROC paradigm. The first reader is CAD. The highest rating was used to convert this to an ROC 
dataset. The original LROC data is \code{datasetCadLroc}. Analyzing this 
data requires methods described in the book, implemented in the function  
\code{\link{StSignificanceTestingCadVsRad}}.
}
\examples{
str(dataset09)
PlotEmpiricalOperatingCharacteristics(dataset = dataset09, rdrs = 1:10, opChType = "ROC")$Plot


}
\references{
Hupse R  et al. Standalone computer-aided detection compared to radiologists' 
performance for the detection of mammographic masses. Eur Radiol. 2013;23(1):93-100.
}
\keyword{datasets}
