library("mgcv")
library("RLRsim")
extract.lmeDesign <- function(m){
	require(mgcv)
	start.level = 1
	data<-m$data
	grps <- getGroups(m)
	n <- length(grps)
	X <- list()
	grp.dims <- m$dims$ncol
	Zt <- model.matrix(m$modelStruct$reStruct, data)
	cov <- as.matrix(m$modelStruct$reStruct)
	i.col <- 1
	n.levels <- length(m$groups)
	Z <- matrix(0, n, 0)
	if (start.level <= n.levels) {
		for (i in 1:(n.levels - start.level + 1)) {
			if(length(levels(m$groups[[n.levels-i+1]]))!=1)
			{
				X[[1]] <- model.matrix(~m$groups[[n.levels - i +
										1]] - 1, contrasts.arg = c("contr.treatment",
								"contr.treatment"))
			}
			else X[[1]]<-matrix(1)
			X[[2]] <- as.matrix(Zt[, i.col:(i.col + grp.dims[i] -
										1)])
			i.col <- i.col + grp.dims[i]
			Z <- cbind(tensor.prod.model.matrix(X),Z)
		}
		Vr <- matrix(0, ncol(Z), ncol(Z))
		start <- 1
		for (i in 1:(n.levels - start.level + 1)) {
			k <- n.levels - i + 1
			for (j in 1:m$dims$ngrps[i]) {
				stop <- start + ncol(cov[[k]]) - 1
				Vr[ncol(Z)+1-(stop:start),ncol(Z)+1-(stop:start)] <- cov[[k]]
				start <- stop + 1
			}
		}
	}
	if(class(m$call$fixed) == "name"){
		X <- m$data$X
	} else 	{
		X<-model.matrix(formula(m$call$fixed),data)
	}
	y<-as.vector(matrix(m$residuals,nc=NCOL(m$residuals))[,NCOL(m$residuals)] +matrix(m$fitted,nc=NCOL(m$fitted))[,NCOL(m$fitted)])
	return(list(
					Vr=Vr, #Cov(RanEf)/Var(Error)
					X=X,
					Z=Z,
					sigmasq=m$sigma^2,
					lambda=unique(diag(Vr)),
					y=y
			)
	)
}

set.seed(777)

x <- runif(100,-pi,pi)
w <- exp(-rnorm(100))
y <- sin(x) + rnorm(100, 0, sd=sqrt(w))


test1 <- gamm(y ~ s(x, bs="ps", m=c(4,2)), weights=1/w, method="REML")
des1 <- extract.lmeDesign(test$lme)

test2 <- gamm(y ~ s(x, bs="ps", m=c(4,2)), method="REML")
des2 <- extract.lmeDesign(test2$lme)

yp <- rpois(length(y), exp(y))
test3 <- gamm(yp ~ s(x, bs="ps", m=c(4,2)), method="REML", family=poisson)
des3 <- extract.lmeDesign(test3$lme)

