% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{decodeLinear}
\alias{decodeLinear}
\title{decodeLinear}
\usage{
decodeLinear(data)
}
\arguments{
\item{data}{pointer to array of bytes to be decoded (need memorycont. repr.)}
}
\value{
the number of decoded doubles, or -1 if dataSize < 4 or 4 < dataSize < 8
}
\description{
Decodes data encoded by encodeLinear.
}
\details{
result vector guaranteed to be shorter or equal to (|data| - 8) * 2

Note that this method may throw a const char* if it deems the input data to be corrupt, i.e.
that the last encoded int does not use the last byte in the data. In addition the last encoded 
int need to use either the last halfbyte, or the second last followed by a 0x0 halfbyte.
}
\examples{
\dontrun{
## Retention time data that is encoded with encodeLinear and is zlib compressed
### NOTE: For the sake of this example, I have broken the raw vector into several parts
###       to avoid Rd line widths (>100 characters) issues with CRAN build checks.
rt_raw1 <- c("78", "9c", "73", "50", "61", "00", "83", "aa", "15", "0c", "0c", "73", "80")
rt_raw2 <- c("b8", "a3", "5d", "fe", "47", "07", "84", "28", "fc", "8f", "c4", "40", "e5")
rt_raw3 <- c("61", "51", "84", "a9", "85", "08", "e1", "06", "00", "06", "be", "41", "cf")
## Add all character representation of raw data back together and convert back to hex raw vector
rt_blob <- as.raw(as.hexmode(c(rt_raw1, rt_raw2, rt_raw3 )))
## Decompress blob
rt_blob_uncompressed <- as.raw(Rcompression::uncompress( rt_blob, asText = FALSE ))
## Decode to rentention time double values
rt_array <- decodeLinear(rt_blob_uncompressed)
}
}
\seealso{
[\code{\link{encodeLinear}}]
}
