/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import com.mongodb.DBPortPool;
import com.mongodb.Mongo;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.NativeAuthenticationHelper;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.util.ThreadUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DBPort {
    public static final int PORT = 27017;
    static final boolean USE_NAGLE = false;
    static final long CONN_RETRY_TIME_MS = 15000L;
    private static Logger _rootLogger = Logger.getLogger("com.mongodb.port");
    final int _hashCode;
    final ServerAddress _sa;
    final InetSocketAddress _addr;
    final DBPortPool _pool;
    final MongoOptions _options;
    final Logger _logger;
    final DBDecoder _decoder;
    private volatile Socket _socket;
    private volatile InputStream _in;
    private volatile OutputStream _out;
    private volatile boolean _processingResponse;
    final Set<String> authenticatedDatabases = Collections.synchronizedSet(new HashSet());
    volatile int _lastThread;
    final AtomicLong _calls = new AtomicLong();
    private volatile ActiveState _activeState;
    private volatile Boolean useCRAMAuthenticationProtocol;

    public DBPort(ServerAddress addr) {
        this(addr, null, new MongoOptions());
    }

    DBPort(ServerAddress addr, DBPortPool pool, MongoOptions options) {
        this._options = options;
        this._sa = addr;
        this._addr = addr.getSocketAddress();
        this._pool = pool;
        this._hashCode = this._addr.hashCode();
        this._logger = Logger.getLogger(_rootLogger.getName() + "." + addr.toString());
        this._decoder = this._options.dbDecoderFactory.create();
    }

    Response call(OutMessage msg, DBCollection coll) throws IOException {
        return this.go(msg, coll);
    }

    Response call(OutMessage msg, DBCollection coll, DBDecoder decoder) throws IOException {
        return this.go(msg, coll, false, decoder);
    }

    void say(OutMessage msg) throws IOException {
        this.go(msg, null);
    }

    private synchronized Response go(OutMessage msg, DBCollection coll) throws IOException {
        return this.go(msg, coll, false, null);
    }

    private synchronized Response go(OutMessage msg, DBCollection coll, DBDecoder decoder) throws IOException {
        return this.go(msg, coll, false, decoder);
    }

    private synchronized Response go(OutMessage msg, DBCollection coll, boolean forceResponse, DBDecoder decoder) throws IOException {
        if (this._processingResponse && coll != null) {
            throw new IllegalStateException("DBPort.go called and expecting a response while processing another response");
        }
        this._calls.incrementAndGet();
        if (this._socket == null) {
            this._open();
        }
        if (this._out == null) {
            throw new IllegalStateException("_out shouldn't be null");
        }
        try {
            msg.prepare();
            this._activeState = new ActiveState(msg);
            msg.pipe(this._out);
            if (this._pool != null) {
                this._pool._everWorked = true;
            }
            if (coll == null && !forceResponse) {
                Response response = null;
                return response;
            }
            this._processingResponse = true;
            Response response = new Response(this._sa, coll, this._in, decoder == null ? this._decoder : decoder);
            return response;
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        finally {
            this._activeState = null;
            this._processingResponse = false;
        }
    }

    synchronized CommandResult getLastError(DB db, WriteConcern concern) throws IOException {
        DBApiLayer dbAL = (DBApiLayer)db;
        return this.runCommand(dbAL, concern.getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Response findOne(DB db, String coll, DBObject q) throws IOException {
        OutMessage msg = OutMessage.query(db.getCollection(coll), 0, 0, -1, q, null);
        try {
            Response res;
            Response response = res = this.go(msg, db.getCollection(coll), null);
            return response;
        }
        finally {
            msg.doneWithMessage();
        }
    }

    synchronized CommandResult runCommand(DB db, DBObject cmd) throws IOException {
        Response res = this.findOne(db, "$cmd", cmd);
        return this.convertToCommandResult(cmd, res);
    }

    private CommandResult convertToCommandResult(DBObject cmd, Response res) {
        if (res.size() == 0) {
            return null;
        }
        if (res.size() > 1) {
            throw new MongoInternalException("something is wrong.  size:" + res.size());
        }
        DBObject data = res.get(0);
        if (data == null) {
            throw new MongoInternalException("something is wrong, no command result");
        }
        CommandResult cr = new CommandResult(res.serverUsed());
        cr.putAll(data);
        return cr;
    }

    synchronized CommandResult tryGetLastError(DB db, long last2, WriteConcern concern) throws IOException {
        if (last2 != this._calls.get()) {
            return null;
        }
        return this.getLastError(db, concern);
    }

    public synchronized void ensureOpen() throws IOException {
        if (this._socket != null) {
            return;
        }
        this._open();
    }

    void _open() throws IOException {
        long sleepTime = 100L;
        long maxAutoConnectRetryTime = 15000L;
        if (this._options.maxAutoConnectRetryTime > 0L) {
            maxAutoConnectRetryTime = this._options.maxAutoConnectRetryTime;
        }
        boolean successfullyConnected = false;
        long start = System.currentTimeMillis();
        do {
            try {
                this._socket = this._options.socketFactory.createSocket();
                this._socket.connect(this._addr, this._options.connectTimeout);
                this._socket.setTcpNoDelay(true);
                this._socket.setKeepAlive(this._options.socketKeepAlive);
                this._socket.setSoTimeout(this._options.socketTimeout);
                this._in = new BufferedInputStream(this._socket.getInputStream());
                this._out = this._socket.getOutputStream();
                successfullyConnected = true;
            }
            catch (IOException e) {
                this.close();
                if (!this._options.autoConnectRetry || this._pool != null && !this._pool._everWorked) {
                    throw e;
                }
                long waitSoFar = System.currentTimeMillis() - start;
                if (waitSoFar >= maxAutoConnectRetryTime) {
                    throw e;
                }
                if (sleepTime + waitSoFar > maxAutoConnectRetryTime) {
                    sleepTime = maxAutoConnectRetryTime - waitSoFar;
                }
                this._logger.log(Level.WARNING, "Exception connecting to " + this.serverAddress().getHost() + ": " + e + ".  Total wait time so far is " + waitSoFar + " ms.  Will retry after sleeping for " + sleepTime + " ms.");
                ThreadUtil.sleep(sleepTime);
                sleepTime *= 2L;
            }
        } while (!successfullyConnected);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String host() {
        return this._addr.toString();
    }

    public ServerAddress serverAddress() {
        return this._sa;
    }

    public String toString() {
        return "{DBPort  " + this.host() + "}";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    ActiveState getActiveState() {
        return this._activeState;
    }

    int getLocalPort() {
        return this._socket != null ? this._socket.getLocalPort() : -1;
    }

    protected void close() {
        this.authenticatedDatabases.clear();
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._in = null;
        this._out = null;
        this._socket = null;
    }

    CommandResult authenticate(Mongo mongo, MongoCredential credentials) {
        Authenticator authenticator;
        if (credentials.getMechanism().equals("MONGODB-CR")) {
            authenticator = new NativeAuthenticator(mongo, credentials);
        } else if (credentials.getMechanism().equals("GSSAPI")) {
            authenticator = new GSSAPIAuthenticator(mongo, credentials);
        } else {
            throw new IllegalArgumentException("Unsupported authentication protocol: " + credentials.getMechanism());
        }
        CommandResult res = ((Authenticator)authenticator).authenticate();
        this.authenticatedDatabases.add(credentials.getSource());
        return res;
    }

    void checkAuth(Mongo mongo) throws IOException {
        HashSet<String> unauthenticatedDatabases = new HashSet<String>(mongo.getAuthority().getCredentialsStore().getDatabases());
        unauthenticatedDatabases.removeAll(this.authenticatedDatabases);
        for (String databaseName : unauthenticatedDatabases) {
            this.authenticate(mongo, mongo.getAuthority().getCredentialsStore().get(databaseName));
        }
    }

    public DBPortPool getPool() {
        return this._pool;
    }

    abstract class Authenticator {
        protected final Mongo mongo;
        protected final MongoCredential credential;

        Authenticator(Mongo mongo, MongoCredential credential) {
            this.mongo = mongo;
            this.credential = credential;
        }

        abstract CommandResult authenticate();
    }

    class NativeAuthenticator
    extends Authenticator {
        NativeAuthenticator(Mongo mongo, MongoCredential credentials) {
            super(mongo, credentials);
        }

        public CommandResult authenticate() {
            try {
                DB db = this.mongo.getDB(this.credential.getSource());
                CommandResult res = DBPort.this.runCommand(db, NativeAuthenticationHelper.getNonceCommand());
                res.throwOnError();
                res = DBPort.this.runCommand(db, NativeAuthenticationHelper.getAuthCommand(this.credential.getUserName(), this.credential.getPassword(), res.getString("nonce")));
                res.throwOnError();
                return res;
            }
            catch (IOException e) {
                throw new MongoException.Network("IOException authenticating the connection", e);
            }
        }
    }

    abstract class SaslAuthenticator
    extends Authenticator {
        public static final String MONGODB_PROTOCOL = "mongodb";

        SaslAuthenticator(Mongo mongo, MongoCredential credentials) {
            super(mongo, credentials);
        }

        public CommandResult authenticate() {
            SaslClient saslClient = this.createSaslClient();
            try {
                byte[] response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
                CommandResult res = this.sendSaslStart(response);
                res.throwOnError();
                int conversationId = (Integer)res.get("conversationId");
                while (!((Boolean)res.get("done")).booleanValue()) {
                    response = saslClient.evaluateChallenge((byte[])res.get("payload"));
                    if (response == null) {
                        throw new MongoException("SASL protocol error: no client response to challenge");
                    }
                    res = this.sendSaslContinue(conversationId, response);
                    res.throwOnError();
                }
                CommandResult commandResult = res;
                return commandResult;
            }
            catch (IOException e) {
                throw new MongoException.Network("IOException authenticating the connection", e);
            }
            finally {
                try {
                    saslClient.dispose();
                }
                catch (SaslException e) {}
            }
        }

        protected abstract SaslClient createSaslClient();

        protected abstract DB getDatabase();

        private CommandResult sendSaslStart(byte[] outToken) throws IOException {
            BasicDBObject cmd = new BasicDBObject("saslStart", (Object)1).append("mechanism", this.getMechanismName()).append("payload", outToken != null ? outToken : new byte[]{});
            return DBPort.this.runCommand(this.getDatabase(), cmd);
        }

        private CommandResult sendSaslContinue(int conversationId, byte[] outToken) throws IOException {
            DB adminDB = this.getDatabase();
            BasicDBObject cmd = new BasicDBObject("saslContinue", (Object)1).append("conversationId", conversationId).append("payload", outToken);
            return DBPort.this.runCommand(adminDB, cmd);
        }

        public abstract String getMechanismName();
    }

    class GSSAPIAuthenticator
    extends SaslAuthenticator {
        public static final String GSSAPI_OID = "1.2.840.113554.1.2.2";
        public static final String GSSAPI_MECHANISM = "GSSAPI";

        GSSAPIAuthenticator(Mongo mongo, MongoCredential credentials) {
            super(mongo, credentials);
            if (!this.credential.getMechanism().equals(GSSAPI_MECHANISM)) {
                throw new MongoException("Incorrect mechanism: " + this.credential.getMechanism());
            }
        }

        protected SaslClient createSaslClient() {
            try {
                HashMap<String, GSSCredential> props = new HashMap<String, GSSCredential>();
                props.put("javax.security.sasl.credentials", this.getGSSCredential(this.credential.getUserName()));
                return Sasl.createSaslClient(new String[]{GSSAPI_MECHANISM}, this.credential.getUserName(), "mongodb", DBPort.this.serverAddress().getHost(), props, null);
            }
            catch (SaslException e) {
                throw new MongoException("Exception initializing SASL client", e);
            }
            catch (GSSException e) {
                throw new MongoException("Exception initializing GSSAPI credentials", e);
            }
        }

        protected DB getDatabase() {
            return this.mongo.getDB(this.credential.getSource());
        }

        public String getMechanismName() {
            return GSSAPI_MECHANISM;
        }

        private GSSCredential getGSSCredential(String userName) throws GSSException {
            Oid krb5Mechanism = new Oid(GSSAPI_OID);
            GSSManager manager = GSSManager.getInstance();
            GSSName name = manager.createName(userName, GSSName.NT_USER_NAME);
            return manager.createCredential(name, Integer.MAX_VALUE, krb5Mechanism, 1);
        }
    }

    class GenericSaslAuthenticator
    extends SaslAuthenticator {
        static final String CRAM_MD5 = "CRAM-MD5";
        private final String mechanism;

        GenericSaslAuthenticator(Mongo mongo, MongoCredential credentials, String mechanism) {
            super(mongo, credentials);
            this.mechanism = mechanism;
        }

        protected SaslClient createSaslClient() {
            try {
                return Sasl.createSaslClient(new String[]{this.mechanism}, this.credential.getUserName(), "mongodb", DBPort.this.serverAddress().getHost(), null, new CredentialsHandlingCallbackHandler());
            }
            catch (SaslException e) {
                throw new MongoException("Exception initializing SASL client", e);
            }
        }

        protected DB getDatabase() {
            return this.mongo.getDB(this.credential.getSource());
        }

        public String getMechanismName() {
            return this.mechanism;
        }

        class CredentialsHandlingCallbackHandler
        implements CallbackHandler {
            CredentialsHandlingCallbackHandler() {
            }

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(GenericSaslAuthenticator.this.credential.getUserName());
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    String hashedPassword = new String(NativeAuthenticationHelper.createHash(GenericSaslAuthenticator.this.credential.getUserName(), GenericSaslAuthenticator.this.credential.getPassword()));
                    passwordCallback.setPassword(hashedPassword.toCharArray());
                }
            }
        }
    }

    class ActiveState {
        final OutMessage outMessage;
        final long startTime;
        final String threadName;

        ActiveState(OutMessage outMessage) {
            this.outMessage = outMessage;
            this.startTime = System.nanoTime();
            this.threadName = Thread.currentThread().getName();
        }
    }
}

