% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getRels.R
\name{getRels}
\alias{getRels}
\title{Retrieve Relationships with Cypher Queries}
\usage{
getRels(graph, query, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{query}{A character string.}

\item{...}{Parameters to pass to the query in the form key = value, if applicable.}
}
\value{
A list of relationship objects.
}
\description{
Deprecated. Use \code{\link{cypherToList}}. Retrieve relationships from the graph with a Cypher query.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, "Person", name = "Bob")
charles = createNode(graph, "Person", name = "Charles")
david = createNode(graph, "Person", name = "David")

createRel(alice, "KNOWS", bob)
createRel(alice, "KNOWS", charles)
createRel(charles, "KNOWS", david)

createRel(bob, "WORKS_WITH", david)
createRel(alice, "WORKS_WITH", david)

getRels(graph, "MATCH (:Person)-[k:KNOWS]->(:Person) RETURN k")
getRels(graph, "MATCH (:Person {name:{name}})-[r]->(:Person) RETURN r", name = "Alice")
}
}
\seealso{
\code{\link{getSingleRel}}
}

