% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measureit.R
\name{measureit.rocit}
\alias{measureit.rocit}
\title{Performance Metrics of Binary Classifier}
\usage{
\method{measureit}{rocit}(x, measure = c("ACC", "SENS"), ... = NULL)
}
\arguments{
\item{x}{An object of class \code{"rocit"} created with \code{\link{rocit}}.}

\item{measure}{The performance metrics to be evaluated. See "Details"
for available options.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
An object of class \code{"measureit"}, same as returned by
\code{\link{measureit.default}}.
}
\description{
This is an S3 method for object of class \code{"rocit"}.
It computes various performance metrics at different cutoff values.
}
\details{
This function calls \code{\link{measureit.default}}. From the
components of \code{"rocit"} objects, it calculates the \code{score}
and \code{class}
variables internally. See \code{\link{measureit.default}} for other
details and available options for \code{measure} argument.
}
\note{
See \code{\link{measureit.default}}.
}
\examples{
data("Diabetes")
logistic.model <- glm(as.factor(dtest)~chol+age+bmi,
                      data = Diabetes,family = "binomial")
class <- logistic.model$y
score <- logistic.model$fitted.values
rocit_object <- rocit(score = score, class = class)
# -------------------------------------------------------------
measure <- measureit(rocit_object, measure = c("ACC", "SENS", "FSCR"))
names(measure)
plot(measure$ACC~measure$Cutoff, type = "l")
plot(measure$TP~measure$FP, type = "l")

}
\seealso{
\code{\link{measureit.default}}, \code{\link{print.measureit}}
}
